/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.core.opensearch.migration.Migration;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

abstract class AllSearchHitsMigration
extends Migration {
    private static final Logger LOG = Logger.getLogger(AllSearchHitsMigration.class.getName());
    protected int newModelVersion;

    public AllSearchHitsMigration(OpenSearchService oss, int newModelVersion) {
        super(oss);
        this.newModelVersion = newModelVersion;
    }

    abstract List<IndexRequest> migrateSearchHit(RestHighLevelClient var1, IndexToMigrate var2, IndexToMigrate var3, SearchHit var4);

    public IndexToMigrate migrateIndex(final IndexToMigrate oldIndex) throws IndexMigrationException {
        LOG.info("migrateIndex oldIndex=" + oldIndex);
        final OpenSearchService oss = this.getOpenSearchService();
        final IndexToMigrate newIndex = new IndexToMigrate(oldIndex.getAlias(), oss.newIndexNameForAlias(oldIndex.getAlias()));
        this.migrate(oldIndex, newIndex, this.newModelVersion, new Migration.Migrator(){

            @Override
            public void migrate(RestHighLevelClient osClient) throws OpenSearchRelatedException {
                try {
                    SearchRequest request = new SearchRequest().indices(oldIndex.getName()).scroll(new TimeValue(60000L)).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
                    SearchResponse searchResponse = osClient.search(request, RequestOptions.DEFAULT);
                    BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                    do {
                        for (SearchHit hit : searchResponse.getHits().getHits()) {
                            List<IndexRequest> migrated = AllSearchHitsMigration.this.migrateSearchHit(osClient, oldIndex, newIndex, hit);
                            if (migrated != null && !migrated.isEmpty()) {
                                for (IndexRequest indexRequest : migrated) {
                                    bulkRequest.add(indexRequest);
                                }
                            }
                            if (bulkRequest.numberOfActions() <= 250) continue;
                            BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                            LOG.info("indexed {" + bulkRequest.numberOfActions() + "}, hasFailures: {" + bulkResponse.hasFailures() + "}");
                            bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                        }
                    } while ((searchResponse = osClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
                    oss.releaseScrollId(searchResponse);
                    if (bulkRequest.numberOfActions() > 0) {
                        BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                        LOG.info("indexed {" + bulkRequest.numberOfActions() + "}, hasFailures: {" + bulkResponse.hasFailures() + "}");
                    }
                }
                catch (IOException ex) {
                    throw new OpenSearchRelatedException(ex);
                }
                catch (OpenSearchException ex) {
                    throw new OpenSearchRelatedException(ex);
                }
            }
        });
        try {
            oss.refreshIndices(newIndex.getName());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to refresh the migrated index: " + newIndex);
        }
        return newIndex;
    }
}

