/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion12To13
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion12To13.class.getName());
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion12To13(OpenSearchService oss) {
        super(oss, 13);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOG.warning("Skipping document with ID mismatch: " + hit.getId() + " != " + sourceValues.get("id"));
            return null;
        }
        if ("backendconnection".equals(sourceValues.get("moduleId")) && "deployment_target".equals(sourceValues.get("instanceType"))) {
            String newId = hit.getId();
            HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
            updatedSourceValues.put("instanceType", "deployment_system");
            if ("dt_local".equals(sourceValues.get("instanceId"))) {
                newId = this.createSettingId((String)sourceValues.get("moduleId"), "ds_local", (String)sourceValues.get("name"));
                updatedSourceValues.put("id", newId);
                updatedSourceValues.put("instanceId", "ds_local");
            }
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newId).source(updatedSourceValues, XContentType.JSON));
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
    }

    private String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }
}

