/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion18To19
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion18To19.class.getName());
    ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();

    public BpcConfigurationIndexMigrationFromModelVersion18To19(OpenSearchService oss) {
        super(oss, 19);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Map<String, Object> sourceValues = hit.getSourceAsMap();
            String settingName = (String)sourceValues.get("name");
            String moduleId = (String)sourceValues.get("moduleId");
            if ("monitor".equals(moduleId) && "view_states".equals(settingName)) {
                LOG.info("Migrate setting view_states for monitor " + sourceValues.get("instanceId"));
                ArrayList monitorViews = (ArrayList)sourceValues.get("value");
                String MONITOR_VIEW_INDEX_NAME = "bpc-store-monitor-views";
                try {
                    if (!this.getOpenSearchService().existsIndex(MONITOR_VIEW_INDEX_NAME)) {
                        LOG.info("Create storage index " + MONITOR_VIEW_INDEX_NAME);
                        this.getOpenSearchService().createIndex(MONITOR_VIEW_INDEX_NAME, (Map)mapper.readValue("{\n        \"number_of_shards\": 5,\n        \"number_of_replicas\": 1,\n        \"analysis\": {\n          \"normalizer\": {\n            \"lowercaseNormalizer\": {\n              \"type\": \"custom\",\n              \"char_filter\": [],\n              \"filter\": [\n                \"lowercase\"\n              ]\n            }\n          }\n        }\n      }", Map.class), (Map)mapper.readValue("{\n        \"properties\": {\n          \"id\": {\n            \"type\": \"keyword\"\n          },\n          \"moduleId\": {\n            \"type\": \"keyword\"\n          },\n          \"moduleInstanceId\": {\n            \"type\": \"keyword\"\n          },\n          \"name\": {\n            \"type\": \"keyword\"\n          },\n          \"value\": {\n            \"type\": \"object\",\n            \"enabled\": false\n          },\n          \"favorite\": {\n            \"type\": \"boolean\"\n          },\n          \"customFields\": {\n            \"type\": \"object\",\n            \"enabled\": false\n          },\n          \"readRestriction\": {\n            \"properties\": {\n              \"user\": {\n                \"type\": \"keyword\"\n              },\n              \"organisations\": {\n                \"type\": \"keyword\"\n              },\n              \"roles\": {\n                \"type\": \"keyword\"\n              },\n              \"rights\": {\n                \"type\": \"keyword\"\n              }\n            }\n          },\n          \"writeRestriction\": {\n            \"properties\": {\n              \"user\": {\n                \"type\": \"keyword\"\n              },\n              \"organisations\": {\n                \"type\": \"keyword\"\n              },\n              \"roles\": {\n                \"type\": \"keyword\"\n              },\n              \"rights\": {\n                \"type\": \"keyword\"\n              }\n            }\n          }\n        }\n      }", Map.class));
                    }
                    int priority = 0;
                    for (Map monitorView : monitorViews) {
                        HashMap<String, Object> contentMap = new HashMap<String, Object>();
                        contentMap.put("value", monitorView);
                        contentMap.put("moduleId", "monitor");
                        contentMap.put("moduleInstanceId", sourceValues.get("instanceId"));
                        for (String field : new String[]{"name", "favorite"}) {
                            contentMap.put(field, monitorView.get(field));
                        }
                        ArrayList<String> roleList = new ArrayList<String>();
                        roleList.add("bpcuser");
                        HashMap<String, ArrayList<String>> restrictionMap = new HashMap<String, ArrayList<String>>();
                        restrictionMap.put("roles", roleList);
                        contentMap.put("readRestriction", restrictionMap);
                        contentMap.put("writeRestriction", restrictionMap);
                        HashMap<String, Integer> customFields = new HashMap<String, Integer>();
                        contentMap.put("customFields", customFields);
                        customFields.put("priority", priority += 100);
                        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(MONITOR_VIEW_INDEX_NAME)).id(monitorView.get("id").toString()).source(mapper.writeValueAsString(contentMap), XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        this.getOpenSearchService().getClient().index(indexRequest, RequestOptions.DEFAULT);
                    }
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, "Failed to migrate monitor views in monitor '" + sourceValues.get("instanceId") + "'.", ex);
                }
                List<IndexRequest> list = null;
                return list;
            }
            List<IndexRequest> list = Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
            return list;
        }
        finally {
            ObjectMapperPool.getInstance().restore((Object)mapper);
        }
    }
}

