/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion10To11;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion11To12;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion12To13;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion13To14;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion14To15;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion15To16;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion16To17;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion17To18;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion18To19;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion6To7;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion7To8;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion8To9;
import de.virtimo.bpc.core.opensearch.migration.BpcConfigurationIndexMigrationFromModelVersion9To10;
import de.virtimo.bpc.core.opensearch.migration.BpcNotificationIndexMigrationFromModelVersion1To2;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.MapUtil;
import java.util.Set;
import java.util.logging.Logger;

public class BpcIndicesMigrator {
    private static final Logger LOG = Logger.getLogger(BpcIndicesMigrator.class.getName());
    private final OpenSearchService oss;

    public BpcIndicesMigrator(OpenSearchService oss) {
        this.oss = oss;
    }

    public String migrateBpcConfigurationIndex() throws IndexMigrationException, OpenSearchRelatedException {
        LOG.info("migrateBpcConfigurationIndex");
        return this.migrateBpcConfigurationIndex("bpc-configuration");
    }

    public static int getLowestSupportedModelVersionOfBpcConfigurationIndex() {
        return 6;
    }

    public String migrateBpcConfigurationIndex(String aliasName) throws IndexMigrationException, OpenSearchRelatedException {
        LOG.info("migrateBpcConfigurationIndex aliasName=" + aliasName);
        int toModelVersion = 19;
        if (!this.oss.existsIndex(aliasName)) {
            LOG.info("Migration not necessary for [" + aliasName + "]. Does not exist.");
            return null;
        }
        String indexName = this.getTheOneAndOnlyIndexNameForAlias(aliasName);
        int currentModelVersion = this.oss.getModelVersion(aliasName);
        if (currentModelVersion == toModelVersion) {
            LOG.info("Migration not necessary for [" + aliasName + "]. Uses already the required model version: " + toModelVersion);
            return indexName;
        }
        this.checkFutureModelVersion(aliasName, currentModelVersion, toModelVersion);
        LOG.warning("Migration necessary. The current [" + aliasName + "] model version is '" + currentModelVersion + "' and required is '" + toModelVersion + "'.");
        IndexToMigrate nextIndexToMigrate = new IndexToMigrate(aliasName, indexName);
        if (currentModelVersion == 6) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion6To7(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 7) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion7To8(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 8) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion8To9(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 9) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion9To10(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 10) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion10To11(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 11) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion11To12(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 12) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion12To13(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 13) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion13To14(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 14) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion14To15(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 15) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion15To16(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 16) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion16To17(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 17) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion17To18(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 18) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion18To19(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 19) {
            // empty if block
        }
        return nextIndexToMigrate.getName();
    }

    public String migrateBpcNotificationIndex() throws IndexMigrationException, OpenSearchRelatedException {
        LOG.info("migrateBpcNotificationIndex");
        return this.migrateBpcNotificationIndex("bpc-notification");
    }

    public String migrateBpcNotificationIndex(String aliasName) throws IndexMigrationException, OpenSearchRelatedException {
        LOG.info("migrateBpcNotificationIndex aliasName=" + aliasName);
        int toModelVersion = 2;
        if (!this.oss.existsIndex(aliasName)) {
            LOG.info("Migration not necessary for [" + aliasName + "]. Does not exist.");
            return null;
        }
        String indexName = this.getTheOneAndOnlyIndexNameForAlias(aliasName);
        int currentModelVersion = this.oss.getModelVersion(aliasName);
        if (currentModelVersion == toModelVersion) {
            LOG.info("Migration not necessary for [" + aliasName + "]. Uses already the required model version: " + toModelVersion);
            return indexName;
        }
        this.checkFutureModelVersion(aliasName, currentModelVersion, toModelVersion);
        LOG.warning("Migration necessary. The current [" + aliasName + "] model version is '" + currentModelVersion + "' and required is '" + toModelVersion + "'.");
        IndexToMigrate nextIndexToMigrate = new IndexToMigrate(aliasName, indexName);
        if (currentModelVersion == 1) {
            nextIndexToMigrate = new BpcNotificationIndexMigrationFromModelVersion1To2(this.oss).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 2) {
            // empty if block
        }
        return nextIndexToMigrate.getName();
    }

    private String getTheOneAndOnlyIndexNameForAlias(String aliasName) throws OpenSearchRelatedException, IndexMigrationException {
        LOG.info("getIndexNameForAlias aliasName=" + aliasName);
        Set<String> indexNames = this.oss.getIndexNamesWithAlias(aliasName);
        if (indexNames.size() != 1) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_ALIAS_WITH_MULTIPLE_INDICES, "Index migration failed. Please have a look why the index alias '${aliasName}' is assigned to multiple indices: ${indexNames}", MapUtil.mapOf("aliasName", aliasName, "indexNames", "" + indexNames));
        }
        return indexNames.iterator().next();
    }

    private void checkFutureModelVersion(String aliasName, int currentModelVersion, int toModelVersion) throws IndexMigrationException {
        if (currentModelVersion > toModelVersion) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_NOT_ALLOWED_VERSION, "You are trying to use a '${indexName}' index which is from a newer BPC version. This is not possible!", MapUtil.mapOf("indexName", aliasName, "indexModelVersion", currentModelVersion, "bpcModelVersion", toModelVersion));
        }
    }
}

