/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexInfo;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.deployment.resource.DeploymentEndpoint;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceHandler;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.core.resource.response.SettingsBasedConfigImpl;
import de.virtimo.bpc.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;

public class GlobalConfigMigrator {
    private static final Logger LOG = Logger.getLogger(GlobalConfigMigrator.class.getName());
    private final ModuleManager moduleManager;
    private final OpenSearchService oss;

    public GlobalConfigMigrator(ModuleManager moduleManager, OpenSearchService oss) {
        this.moduleManager = moduleManager;
        this.oss = oss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> migrate(Map<String, Object> modulesConfig) throws ServiceNotFoundException, IOException, OpenSearchRelatedException, IndexMigrationException {
        LOG.info("migrate modulesConfig=...");
        int modelVersionOfModulesConfigToMigrate = DeploymentEndpoint.getModelVersion(modulesConfig);
        int modelVersionOfThisBpc = this.moduleManager.getModelVersionOfBpcConfigurationIndex();
        if (modelVersionOfModulesConfigToMigrate == -1) {
            return modulesConfig;
        }
        if (modelVersionOfModulesConfigToMigrate >= modelVersionOfThisBpc) {
            return modulesConfig;
        }
        if (modelVersionOfModulesConfigToMigrate < BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex()) {
            return modulesConfig;
        }
        Map metadata = (Map)modulesConfig.get("metadata");
        if (metadata == null || !metadata.containsKey("fromIndex")) {
            return modulesConfig;
        }
        String tmpBpcConfigurationIndexAlias = "tmp_" + System.currentTimeMillis() + "_bpc-configuration";
        try {
            Map fromIndex = (Map)metadata.get("fromIndex");
            Map fromIndexSettings = (Map)fromIndex.get("settings");
            Map fromIndexMappings = (Map)fromIndex.get("mappings");
            fromIndexSettings.remove("creation_date");
            fromIndexSettings.remove("provided_name");
            fromIndexSettings.remove("uuid");
            fromIndexSettings.remove("version");
            String tmpBpcConfigurationIndexName = this.oss.createIndex(tmpBpcConfigurationIndexAlias, fromIndexSettings, fromIndexMappings);
            List<Map<String, Object>> allModuleAndModuleInstanceSettings = this.getAllModuleAndModuleInstanceSettings(modulesConfig);
            this.writeSettingsToIndex(this.oss, tmpBpcConfigurationIndexName, allModuleAndModuleInstanceSettings);
            this.oss.refreshIndices(tmpBpcConfigurationIndexName);
            this.oss.setModelVersion(tmpBpcConfigurationIndexName, modelVersionOfModulesConfigToMigrate);
            BpcIndicesMigrator indicesMigrator = new BpcIndicesMigrator(this.oss);
            String migratedTmpBpcConfigurationIndexName = indicesMigrator.migrateBpcConfigurationIndex(tmpBpcConfigurationIndexAlias);
            BpcIndexInfo migratedTmpBpcConfigurationIndexInfo = this.oss.getBpcIndexInfoUsingIndexName(migratedTmpBpcConfigurationIndexName);
            List<Setting> allSettings = ModuleConfigurationPersistenceHandler.readAllSettingsFromBpcConfigurationIndex(this.oss, migratedTmpBpcConfigurationIndexName);
            SettingsBasedConfigImpl migratedConfig = new SettingsBasedConfigImpl(this.moduleManager, migratedTmpBpcConfigurationIndexInfo, modelVersionOfThisBpc, allSettings);
            Map<String, Object> migratedConfigAsMap = JsonUtil.getInstance().jsonStringAsMap(JsonUtil.getInstance().convertPojoToJsonString(migratedConfig));
            Map migratedConfigMetadata = (Map)migratedConfigAsMap.get("metadata");
            metadata.put("modelVersionPreMigration", metadata.get("modelVersion"));
            metadata.put("fromIndexPreMigration", metadata.get("fromIndex"));
            modulesConfig.put("modulesPreMigration", modulesConfig.get("modules"));
            metadata.put("modelVersion", migratedConfigMetadata.get("modelVersion"));
            metadata.put("fromIndex", migratedConfigMetadata.get("fromIndex"));
            modulesConfig.put("modules", migratedConfigAsMap.get("modules"));
            Map<String, Object> map = modulesConfig;
            return map;
        }
        finally {
            try {
                for (String tmpIndexName : this.oss.getAllIndexNamesWithPrefix(tmpBpcConfigurationIndexAlias)) {
                    try {
                        this.oss.deleteIndex(tmpIndexName);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Failed to delete the temporary tmp-bpc-configuration index: " + tmpIndexName, t);
                    }
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Failed to delete the temporary tmp-bpc-configuration indies.", t);
            }
        }
    }

    private List<Map<String, Object>> getAllModuleAndModuleInstanceSettings(Map<String, Object> modulesConfig) {
        List modules;
        LOG.info("getAllModuleAndModuleInstanceSettings modulesConfig=...");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (modulesConfig != null && (modules = (List)modulesConfig.get("modules")) != null) {
            for (Map module : modules) {
                List instances;
                List moduleSettings = (List)module.get("settings");
                if (moduleSettings != null) {
                    for (Map moduleSetting : moduleSettings) {
                        result.add(moduleSetting);
                    }
                }
                if (!module.containsKey("instances") || (instances = (List)module.get("instances")) == null) continue;
                for (Map instance : instances) {
                    List moduleInstanceSettings = (List)instance.get("settings");
                    if (moduleInstanceSettings == null) continue;
                    for (Map moduleInstanceSetting : moduleInstanceSettings) {
                        result.add(moduleInstanceSetting);
                    }
                }
            }
        }
        return result;
    }

    private void writeSettingsToIndex(OpenSearchService os, String indexName, List<Map<String, Object>> settings) throws OpenSearchRelatedException {
        LOG.info("writeSettingsToIndex os=..., indexName=" + indexName + ", settings=...");
        try {
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (Map<String, Object> setting : settings) {
                String settingId = (String)setting.get("id");
                bulkRequest.add(new IndexRequest(indexName).id(settingId).source(setting, XContentType.JSON));
            }
            BulkResponse bulkResponse = os.getClient().bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_FAILED, bulkResponse.buildFailureMessage(), null);
            }
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }
}

