/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.MapUtil;
import java.util.logging.Logger;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.client.RestHighLevelClient;

public class Migration {
    private static final Logger LOG = Logger.getLogger(Migration.class.getName());
    private final OpenSearchService oss;

    public Migration(OpenSearchService oss) {
        this.oss = oss;
    }

    public OpenSearchService getOpenSearchService() {
        return this.oss;
    }

    protected void migrate(IndexToMigrate oldIndex, IndexToMigrate newIndex, int newModelVersion, Migrator migrator) throws IndexMigrationException {
        LOG.info("migrate oldIndex=" + oldIndex + ", newIndex=" + newIndex + ", newModelVersion=" + newModelVersion + ", migrator=" + migrator);
        try {
            if (this.oss.getManagedIndicesHandler().isManagedIndex(newIndex.getAlias())) {
                this.oss.getManagedIndicesHandler().createManagedIndex(newIndex.getAlias(), newIndex.getName(), false);
            } else {
                this.oss.createIndex(newIndex.getName());
                this.oss.copyIndexMapping(oldIndex.getName(), newIndex.getName());
            }
            migrator.migrate(this.oss.getClient());
            this.oss.setModelVersion(newIndex.getName(), newModelVersion);
            this.oss.refreshIndices(newIndex.getName());
            this.oss.flushIndices(newIndex.getName());
            this.oss.moveAlias(oldIndex.getName(), newIndex.getName());
            this.oss.closeIndex(oldIndex.getName());
        }
        catch (ResourceAlreadyExistsException ex) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_INDEX_EXISTS_ALREADY, "Index migration failed. New index '${newIndexName}' for alias '${aliasName}' exists already. Should not be possible!", MapUtil.mapOf("aliasName", newIndex.getAlias(), "newIndexName", newIndex.getName()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_UNEXPECTED_ERROR, "Index migration failed: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    public static interface Migrator {
        public void migrate(RestHighLevelClient var1) throws OpenSearchRelatedException;
    }
}

