/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginError;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.plugin.OpenSearchBpcPluginErrorImpl;
import de.virtimo.bpc.core.opensearch.plugin.OpenSearchBpcPluginListener;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterAddActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveAllActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ConfigDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.FilterDTO;
import de.virtimo.bpc.opensearch.plugin.dto.FiltersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTOCreator;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.common.xcontent.ToXContent;
import org.osgi.framework.BundleContext;

public class OpenSearchBpcPluginManagerImpl
implements OpenSearchBpcPluginManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(OpenSearchBpcPluginManagerImpl.class.getName());
    public static final int MAX_ERRORS = 10;
    private final BundleContext bundleContext;
    private final CoreBundleConfiguration coreBundleConfiguration;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private ScheduledExecutorService openSearchBpcPluginExecutorService;
    private final OpenSearchBpcPluginListener openSearchBpcPluginListener;
    private final List<OpenSearchBpcPluginError> lastErrors = new ArrayList<OpenSearchBpcPluginError>();
    private OpenSearchBpcPluginManager.PluginState pluginState = OpenSearchBpcPluginManager.PluginState.UNKNOWN;
    private OpenSearchBpcPluginManager.WebsocketState websocketState = OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED;

    public OpenSearchBpcPluginManagerImpl(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.bundleContext = bundleContext;
        this.coreBundleConfiguration = coreBundleConfiguration;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.openSearchBpcPluginListener = new OpenSearchBpcPluginListener(bundleContext, this);
        this.openSearchBpcPluginExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-os-plugin-listener"));
        this.openSearchBpcPluginExecutorService.scheduleWithFixedDelay(this.openSearchBpcPluginListener, 5L, coreBundleConfiguration.getSystemPropertyValueAsInt("de.virtimo.bpc.core.os-bpc-plugin.retryInterval", 5), TimeUnit.SECONDS);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        if (this.openSearchBpcPluginExecutorService != null) {
            this.openSearchBpcPluginExecutorService.shutdownNow();
            this.openSearchBpcPluginExecutorService = null;
        }
        if (this.openSearchBpcPluginListener != null) {
            this.openSearchBpcPluginListener.destroy();
        }
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public String getOpenSearchBpcPluginWebsocketUrl() throws ServiceNotFoundException, SettingException {
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ConfigDTO config = this.getOpenSearchBpcPluginConfig(oss);
        if (config == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Failed to fetch the config from the 'os-bpc-plugin'.");
        }
        ConfigDTO.Websocket websocket = config.getWebsocket();
        if (websocket == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Did not find the websocket property in the 'os-bpc-plugin' config: " + config);
        }
        Integer websocketPort = websocket.getPort();
        if (websocketPort == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Did not find the websocket port in the 'os-bpc-plugin' config: " + config);
        }
        return "ws://" + oss.getHost() + ":" + websocketPort + "/ws/_bpc";
    }

    @Override
    public OpenSearchBpcPluginManager.PluginState getPluginState() {
        return this.pluginState;
    }

    private void setPluginState(OpenSearchBpcPluginManager.PluginState pluginState) {
        this.pluginState = pluginState;
    }

    @Override
    public OpenSearchBpcPluginManager.WebsocketState getWebsocketState() {
        return this.websocketState;
    }

    @Override
    public void setWebsocketState(OpenSearchBpcPluginManager.WebsocketState websocketState) {
        if (this.websocketState != websocketState) {
            this.websocketState = websocketState;
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "WebsocketState", (Object)websocketState);
            }
            catch (ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, "Failed to fire the websocket state change: " + websocketState, ex);
            }
        }
    }

    @Override
    public List<OpenSearchBpcPluginError> getErrors() {
        return this.lastErrors;
    }

    @Override
    public synchronized void addError(String message, Throwable t) {
        LOG.log(Level.SEVERE, message);
        OpenSearchBpcPluginError previousError = null;
        if (!this.lastErrors.isEmpty()) {
            previousError = this.lastErrors.get(this.lastErrors.size() - 1);
        }
        OpenSearchBpcPluginErrorImpl currentError = new OpenSearchBpcPluginErrorImpl(message, t);
        if (previousError != null && previousError.equals(currentError)) {
            this.lastErrors.remove(this.lastErrors.size() - 1);
        }
        this.lastErrors.add(currentError);
        if (this.lastErrors.size() > 10) {
            this.lastErrors.remove(0);
        }
    }

    @Override
    public synchronized ConfigDTO getOpenSearchBpcPluginConfig() throws ServiceNotFoundException {
        LOG.info("getOpenSearchBpcPluginConfig");
        return this.getOpenSearchBpcPluginConfig(this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized ConfigDTO getOpenSearchBpcPluginConfig(OpenSearchService oss) {
        LOG.info("getOpenSearchBpcPluginConfig oss=...");
        Request req = new Request("GET", "/_bpc/config");
        return this.getDTO(req, ConfigDTO.class, oss);
    }

    @Override
    public synchronized FiltersDTO getRegisteredFilters() throws ServiceNotFoundException {
        LOG.info("getRegisteredFilters");
        return this.getRegisteredFilters(this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized FiltersDTO getRegisteredFilters(OpenSearchService oss) {
        LOG.info("getRegisteredFilters oss=...");
        Request req = new Request("GET", "/_bpc/filter");
        req.addParameter("serverUUID", this.coreBundleConfiguration.getServerUUID());
        return this.getDTO(req, FiltersDTO.class, oss);
    }

    @Override
    public synchronized int registerFilter(FilterDTO filter) throws ServiceNotFoundException, JsonGenerationException {
        LOG.info("registerFilter filter=" + filter);
        return this.registerFilter(this.openSearchServiceTracker.getService(), filter);
    }

    @Override
    public synchronized int registerFilter(OpenSearchService oss, FilterDTO filter) throws JsonGenerationException {
        LOG.info("registerFilter oss=..., filter=" + filter);
        Request req = new Request("PUT", "/_bpc/filter");
        ChangesFilterAddActionDTO filterAddAction = new ChangesFilterAddActionDTO(this.coreBundleConfiguration.getServerUUID(), filter.getIndex(), filter.isSendIndexEventsOnlyForModifiedSources());
        return this.sendDTO(req, (OpenSearchPluginDTO)filterAddAction, oss);
    }

    @Override
    public synchronized int unregisterFilter(FilterDTO filter) throws ServiceNotFoundException, JsonGenerationException {
        LOG.info("unregisterFilter filter=" + filter);
        return this.unregisterFilter(this.openSearchServiceTracker.getService(), filter);
    }

    @Override
    public synchronized int unregisterFilter(OpenSearchService oss, FilterDTO filter) throws JsonGenerationException {
        LOG.info("unregisterFilter oss=..., filter=" + filter);
        Request req = new Request("DELETE", "/_bpc/filter");
        ChangesFilterRemoveActionDTO filterRemoveAction = new ChangesFilterRemoveActionDTO(this.coreBundleConfiguration.getServerUUID(), filter.getIndex());
        return this.sendDTO(req, (OpenSearchPluginDTO)filterRemoveAction, oss);
    }

    @Override
    public synchronized int unregisterAllFilters() throws ServiceNotFoundException, JsonGenerationException {
        LOG.info("unregisterAllFilters");
        return this.unregisterAllFilters(this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int unregisterAllFilters(OpenSearchService oss) throws JsonGenerationException {
        LOG.info("unregisterAllFilters oss=...");
        Request req = new Request("DELETE", "/_bpc/filter/all");
        ChangesFilterRemoveAllActionDTO removeAllFilterAction = new ChangesFilterRemoveAllActionDTO(this.coreBundleConfiguration.getServerUUID());
        return this.sendDTO(req, (OpenSearchPluginDTO)removeAllFilterAction, oss);
    }

    @Override
    public synchronized void registerFilters(FiltersDTO filtersToRegister) throws ServiceNotFoundException, JsonGenerationException {
        LOG.info("registerFilters oss=... filtersToRegister=" + filtersToRegister);
        this.registerFilters(this.openSearchServiceTracker.getService(), filtersToRegister);
    }

    @Override
    public synchronized void registerFilters(OpenSearchService oss, FiltersDTO filtersToRegister) throws JsonGenerationException {
        LOG.info("registerFilters oss=... filtersToRegister=" + filtersToRegister);
        FiltersDTO currentRegisteredFilters = this.getRegisteredFilters(oss);
        LOG.info("Current registered filters: " + currentRegisteredFilters);
        for (FilterDTO currentRegisteredFilter : currentRegisteredFilters.getFilters()) {
            boolean toRegister = filtersToRegister != null && filtersToRegister.containsFilter(currentRegisteredFilter);
            if (toRegister) continue;
            this.unregisterFilter(oss, currentRegisteredFilter);
        }
        if (filtersToRegister != null) {
            for (FilterDTO filterToRegister : filtersToRegister.getFilters()) {
                boolean alreadyRegistered = currentRegisteredFilters.containsFilter(filterToRegister);
                if (alreadyRegistered) continue;
                this.registerFilter(oss, filterToRegister);
            }
        }
    }

    @Override
    public synchronized ConnectedServersDTO getConnectedServers() throws ServiceNotFoundException {
        LOG.info("getConnectedServers");
        return this.getConnectedServers(this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized ConnectedServersDTO getConnectedServers(OpenSearchService oss) {
        LOG.info("getConnectedServers oss=" + oss);
        Request req = new Request("GET", "/_bpc/servers");
        return this.getDTO(req, ConnectedServersDTO.class, oss);
    }

    private int sendDTO(Request request, OpenSearchPluginDTO dto, OpenSearchService oss) throws JsonGenerationException {
        int result;
        LOG.info("sendDTO request=" + request + ", dto=" + dto + ", oss=...");
        Objects.requireNonNull(request, "request cannot be null");
        Objects.requireNonNull(request, "dto cannot be null");
        try {
            request.setJsonEntity(JsonUtil.asJsonString((ToXContent)dto));
        }
        catch (Exception ex) {
            throw new JsonGenerationException("Failed to get the '" + dto.getClass().getSimpleName() + "' as JSON.", (Throwable)ex);
        }
        try {
            Response resp = oss.getClient().getLowLevelClient().performRequest(request);
            result = resp.getStatusLine().getStatusCode();
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'os-bpc-plugin' is installed and that the following endpoint is accessible: " + request, null);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
            result = 500;
        }
        catch (Throwable t) {
            this.addError("Failed to send the '" + dto.getClass().getSimpleName() + "' to the 'os-bpc-plugin' using the endpoint: " + request, t);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.ERRORS);
            result = 500;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OpenSearchPluginDTO> T getDTO(Request request, Class<T> dtoClass, OpenSearchService oss) {
        LOG.info("getDTO request=" + request + ", dtoClass=" + dtoClass + ", oss=...");
        Objects.requireNonNull(request, "request cannot be null");
        Objects.requireNonNull(dtoClass, "dtoClass cannot be null");
        OpenSearchPluginDTO result = null;
        InputStream inputStream = null;
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Response resp = oss.getClient().getLowLevelClient().performRequest(request);
            inputStream = resp.getEntity().getContent();
            Map jsonResponseMap = (Map)objectMapper.readValue(inputStream, Map.class);
            result = OpenSearchPluginDTOCreator.newInstance(dtoClass, (Map)jsonResponseMap);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'os-bpc-plugin' is installed and that the following endpoint is accessible: " + request, null);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
        }
        catch (Throwable t) {
            this.addError("Failed to get the DTO '" + dtoClass.getSimpleName() + "' from the 'os-bpc-plugin' using the endpoint: " + request, t);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.ERRORS);
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return (T)result;
    }
}

