/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.paxjdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.FrameworkUtil;

public class PaxJdbcFeaturesMapping {
    private static final Logger LOG = Logger.getLogger(PaxJdbcFeaturesMapping.class.getName());
    private final Properties jdbcDriverClassToFeatureMappings;

    public PaxJdbcFeaturesMapping(String fileName) {
        this.jdbcDriverClassToFeatureMappings = this.loadJdbcDriverClassToFeatureMappings(fileName);
    }

    private Properties loadJdbcDriverClassToFeatureMappings(String fileName) {
        Properties props = new Properties();
        try (InputStream resourceStream = FrameworkUtil.getBundle(this.getClass()).getResource(fileName).openStream();){
            props.load(resourceStream);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Failed to load the mapping file: " + fileName);
        }
        return props;
    }

    public String getFeatureName(Object jdbcDriverClass) {
        if (jdbcDriverClass instanceof String) {
            return this.jdbcDriverClassToFeatureMappings.getProperty((String)jdbcDriverClass);
        }
        return null;
    }
}

