/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.paxjdbc;

import de.virtimo.bpc.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class PaxJdbcFeaturesToInstall {
    private static final Logger LOG = Logger.getLogger(PaxJdbcFeaturesToInstall.class.getName());
    private final Set<String> featuresToInstallWithoutCustomJdbcDriver = new HashSet<String>();
    private final Set<String> featuresToInstallWithCustomJdbcDriver = new HashSet<String>();

    public PaxJdbcFeaturesToInstall(String value) {
        if (!StringUtil.isNullOrEmpty(value)) {
            this.parseValue(value);
        }
    }

    public boolean hasFeaturesToInstall() {
        return this.hasFeaturesToInstallWithoutCustomJdbcDriver() || this.hasFeaturesToInstallWithCustomJdbcDriver();
    }

    public boolean hasFeaturesToInstallWithoutCustomJdbcDriver() {
        return !this.featuresToInstallWithoutCustomJdbcDriver.isEmpty();
    }

    public Set<String> getFeaturesToInstallWithoutCustomJdbcDriver() {
        return this.featuresToInstallWithoutCustomJdbcDriver;
    }

    public boolean hasFeaturesToInstallWithCustomJdbcDriver() {
        return !this.featuresToInstallWithCustomJdbcDriver.isEmpty();
    }

    public Set<String> getFeaturesToInstallWithCustomJdbcDriver() {
        return this.featuresToInstallWithCustomJdbcDriver;
    }

    private boolean isValidPaxJdbcFeatureName(String featureName) {
        return featureName.toLowerCase().startsWith("pax-jdbc-") && !featureName.contains(" ");
    }

    private void parseValue(String value) {
        LOG.info("parseValue value=" + value);
        List<String> features = StringUtil.explode(value, ",");
        for (String feature : features) {
            String featureName;
            if (feature.contains("(*)")) {
                featureName = feature.replace("(*)", "").trim();
                if (this.isValidPaxJdbcFeatureName(featureName)) {
                    this.featuresToInstallWithCustomJdbcDriver.add(featureName);
                    continue;
                }
                LOG.warning("Found an invalid pax-jdbc feature which cannot be installed: " + feature);
                continue;
            }
            featureName = feature.trim();
            if (this.isValidPaxJdbcFeatureName(featureName)) {
                this.featuresToInstallWithoutCustomJdbcDriver.add(featureName);
                continue;
            }
            LOG.warning("Found an invalid pax-jdbc feature which cannot be installed: " + feature);
        }
    }
}

