/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorRelatedDatabaseIDs;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.PercolatorsProcessor;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.percolators.PercolatorImpl;
import de.virtimo.bpc.core.percolators.PercolatorsOpenSearchHandler;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.utils.EventUtil;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.SetUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.index.query.QueryBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class PercolatorsManagerImpl
implements PercolatorsManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(PercolatorsManagerImpl.class.getName());
    private final BundleContext bundleContext;
    private String serverUUID;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final EventRegistration eventRegistration;

    public PercolatorsManagerImpl(BundleContext bundleContext, String serverUUID) {
        this.bundleContext = bundleContext;
        this.serverUUID = serverUUID;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forServerUuidUpdatedEvents(new ServerUuidUpdatedEventHandler());
        this.eventRegistration.forUserSessionRemovedEvents(new UserSessionRemovedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerPercolator(String sessionId, String componentId, String customId, OpenSearchService oss, String index, QueryBuilder esQueryBuilder) {
        LOG.info("registerPercolator sessionId=" + sessionId + ", componentId=" + componentId + ", customId=" + customId + ", oss=..., index=" + index + ", esQueryBuilder=...");
        long startTimeCreatePercolator = System.currentTimeMillis();
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            if (sessionId == null || !clientSessionManager.existsSession(sessionId)) {
                LOG.warning("Could not create/update percolator due to unknown session id: " + sessionId);
                boolean bl = false;
                return bl;
            }
            PercolatorImpl percolator = new PercolatorImpl(index, this.serverUUID, sessionId, componentId, customId);
            LOG.info("percolator: " + percolator);
            PercolatorsOpenSearchHandler esHandler = new PercolatorsOpenSearchHandler(oss);
            boolean bl = esHandler.registerPercolator(percolator, esQueryBuilder);
            return bl;
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to register the query as a percolator.", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            LOG.info("Time to create/update the percolator: " + (System.currentTimeMillis() - startTimeCreatePercolator) + " ms");
        }
    }

    @Override
    public void informClientsAboutReplicatedData(OpenSearchService oss, String index, PercolatorsProcessor percolatorsProcessor) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("informClientsAboutReplicatedData oss=..., index=" + index + ", percolatorsProcessor=...");
        if (oss == null || percolatorsProcessor == null) {
            return;
        }
        oss.refreshIndices(index);
        if (percolatorsProcessor.hasReceivedTooManyDatabaseIDsToGetThePercolatorsFor()) {
            try {
                Event event = new Event("de/virtimo/bpc/core/ReplicationService/dataLoaded", DictionaryUtil.dictionaryOf("index", index, "dataCount", percolatorsProcessor.getNumberOfDatabaseIDs()));
                this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin-send-percolator-hit-message", DictionaryUtil.dictionaryOf("sessionId", "ALL", "jsonMsg", EventUtil.eventAsJsonString(event)));
            }
            catch (JsonProcessingException ex) {
                LOG.log(Level.SEVERE, "Could not send the monitor/replication data by websocket.", ex);
            }
        } else {
            Map<Percolator, PercolatorRelatedDatabaseIDs> percolatorsAndTheirRelatedDatabaseIDs = percolatorsProcessor.getPercolatorsAndTheirRelatedDatabaseIDs();
            Set<String> allUpdatedDatabaseIDs = percolatorsProcessor.getUpdatedDatabaseIDs();
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            for (Percolator existingPercolator : percolatorsProcessor.getAllPercolators()) {
                Set<String> deletedDatabaseIDs;
                Set<String> newOrUpdatedDatabaseIDs;
                String percolatorServerUUID = existingPercolator.getServerUUID();
                String percolatorSessionId = existingPercolator.getSessionId();
                String percolatorComponentId = existingPercolator.getComponentId();
                String percolatorCustomId = existingPercolator.getCustomId();
                if (this.serverUUID.equals(percolatorServerUUID) && !clientSessionManager.existsSession(percolatorSessionId)) {
                    this.deletePercolators(oss, index, percolatorSessionId);
                    continue;
                }
                HashSet<String> obsoleteDatabaseIDs = new HashSet<String>();
                if (percolatorsAndTheirRelatedDatabaseIDs != null && percolatorsAndTheirRelatedDatabaseIDs.containsKey(existingPercolator)) {
                    PercolatorRelatedDatabaseIDs percolatorRelatedDatabaseIDs = percolatorsAndTheirRelatedDatabaseIDs.get(existingPercolator);
                    newOrUpdatedDatabaseIDs = percolatorRelatedDatabaseIDs.getNewOrUpdatedDatabaseIDs();
                    for (String updatedDatabaseID : allUpdatedDatabaseIDs) {
                        if (newOrUpdatedDatabaseIDs.contains(updatedDatabaseID)) continue;
                        obsoleteDatabaseIDs.add(updatedDatabaseID);
                    }
                    deletedDatabaseIDs = percolatorRelatedDatabaseIDs.getDeletedDatabaseIDs();
                } else {
                    newOrUpdatedDatabaseIDs = null;
                    obsoleteDatabaseIDs.addAll(allUpdatedDatabaseIDs);
                    deletedDatabaseIDs = null;
                }
                if (!(newOrUpdatedDatabaseIDs != null && !newOrUpdatedDatabaseIDs.isEmpty() || obsoleteDatabaseIDs != null && !obsoleteDatabaseIDs.isEmpty() || deletedDatabaseIDs != null && !deletedDatabaseIDs.isEmpty())) {
                    LOG.info("No replicated data to send to the clients by websocket!");
                    continue;
                }
                this.sendReplicatedDataByWebsocket(oss, index, newOrUpdatedDatabaseIDs, obsoleteDatabaseIDs, deletedDatabaseIDs, percolatorServerUUID, percolatorSessionId, percolatorComponentId, percolatorCustomId);
            }
        }
    }

    @Override
    public void informClientsAboutReplicatedData(OpenSearchService oss, String index, BulkResponse bulkResponse) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("informClientsAboutReplicatedData oss=..., index=" + index + ", bulkResponse=...");
        if (bulkResponse != null) {
            Set<Percolator> percolatorsFromIndex = this.getAllValidPercolatorsFromIndex(oss, index);
            PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(oss, index, percolatorsFromIndex);
            percolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
            percolatorsProcessor.process();
            this.informClientsAboutReplicatedData(oss, index, percolatorsProcessor);
        }
    }

    @Override
    public void informClientsAboutDeletedData(OpenSearchService oss, String index, Set<String> deletedIDs) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("informClientsAboutDeletedData oss=..., index=" + index + ", deletedIDs=...");
        if (deletedIDs != null && !deletedIDs.isEmpty()) {
            Set<Percolator> percolatorsFromIndex = this.getAllValidPercolatorsFromIndex(oss, index);
            PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(oss, index, percolatorsFromIndex);
            percolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            percolatorsProcessor.keepDeletedDatabaseIDs(deletedIDs);
            percolatorsProcessor.processForDeleted();
            this.informClientsAboutReplicatedData(oss, index, percolatorsProcessor);
        }
    }

    private void sendReplicatedDataByWebsocket(OpenSearchService oss, String osIndex, Set<String> newOrUpdatedDatabaseIDs, Set<String> obsoleteDatabaseIDs, Set<String> deletedDatabaseIDs, String serverUUID, String sessionId, String componentId, String customId) {
        LOG.info("sendReplicatedDataByWebsocket oss=..., osIndex=" + osIndex + ", newOrUpdatedDatabaseIDs=..., obsoleteDatabaseIDs=..., deletedDatabaseIDs=..., serverUUID=" + serverUUID + ", sessionId=" + sessionId + ", componentId=" + componentId + ", customId=" + customId);
        try {
            PercolatorsOpenSearchHandler esHandler = new PercolatorsOpenSearchHandler(oss);
            List<Object> dataList = esHandler.getContentOfNewOrUpdatedDatabaseIDs(osIndex, newOrUpdatedDatabaseIDs);
            Event event = new Event("de/virtimo/bpc/core/ReplicationService/dataLoaded", DictionaryUtil.dictionaryOf("componentId", componentId, "customId", customId, "dataCount", dataList.size(), "obsoleteIDs", obsoleteDatabaseIDs == null ? new HashSet() : obsoleteDatabaseIDs, "deletedIDs", deletedDatabaseIDs == null ? new HashSet() : deletedDatabaseIDs));
            this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin-send-percolator-hit-message", DictionaryUtil.dictionaryOf("serverUUID", serverUUID, "sessionId", sessionId, "jsonMsg", EventUtil.eventAsJsonString(event)));
        }
        catch (IOException | OpenSearchException ex) {
            LOG.log(Level.SEVERE, "Failed to send the monitor/replication data by websocket due to an OpenSearch error.", ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not send the monitor/replication data by websocket.", ex);
        }
    }

    @Override
    public Set<Percolator> getPercolatorsFromIndices(OpenSearchService oss, Set<String> indices) {
        LOG.info("getPercolatorsFromIndices oss=..., indices=" + indices);
        HashSet<Percolator> result = new HashSet<Percolator>();
        if (indices != null) {
            PercolatorsOpenSearchHandler esHandler = new PercolatorsOpenSearchHandler(oss);
            for (String index : indices) {
                result.addAll(esHandler.getPercolatorsFromIndex(index));
            }
        }
        return result;
    }

    @Override
    public Set<Percolator> getAllValidPercolatorsFromIndex(OpenSearchService oss, String index) {
        LOG.info("getAllValidPercolatorsFromIndex oss=..., index=" + index);
        HashSet<Percolator> result = new HashSet<Percolator>();
        Set<Percolator> percolatorsFromIndex = this.getPercolatorsFromIndices(oss, SetUtil.setOf(index));
        for (Percolator percolatorFromIndex : percolatorsFromIndex) {
            if (!percolatorFromIndex.isValid()) continue;
            result.add(percolatorFromIndex);
        }
        return result;
    }

    @Override
    public Set<String> getPercolatorRelatedIndexNames() throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("getPercolatorRelatedIndexNames");
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        return oss.getAliasesOfAllIndices();
    }

    @Override
    public void deletePercolators(String sessionId) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("deletePercolators sessionId=" + sessionId);
        if (sessionId == null) {
            return;
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Set<String> indexNames = this.getPercolatorRelatedIndexNames();
        for (String indexName : indexNames) {
            this.deletePercolators(oss, indexName, sessionId);
        }
    }

    private void deletePercolators(OpenSearchService oss, String osIndex, String sessionId) throws OpenSearchRelatedException {
        LOG.info("deletePercolators oss=..., osIndex=" + osIndex + ", sessionId=" + sessionId);
        if (oss == null || osIndex == null || sessionId == null) {
            return;
        }
        Set<Percolator> percolators = this.getPercolatorsFromIndices(oss, SetUtil.setOf(osIndex));
        HashSet<Percolator> toDelete = new HashSet<Percolator>();
        for (Percolator percolator : percolators) {
            if (!percolator.isValid() || !sessionId.equalsIgnoreCase(percolator.getSessionId())) continue;
            toDelete.add(percolator);
        }
        this.deletePercolators(oss, toDelete);
    }

    @Override
    public void deletePercolators(OpenSearchService oss, Set<Percolator> percolatorsToDelete) throws OpenSearchRelatedException {
        LOG.info("deletePercolators oss=..., percolatorsToDelete=" + percolatorsToDelete);
        if (oss == null || percolatorsToDelete == null || percolatorsToDelete.isEmpty()) {
            return;
        }
        PercolatorsOpenSearchHandler esHandler = new PercolatorsOpenSearchHandler(oss);
        esHandler.deletePercolators(percolatorsToDelete);
    }

    private class ServerUuidUpdatedEventHandler
    extends AbstractEventHandler {
        private ServerUuidUpdatedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Object newServerUuidObject = event.getProperty("new");
            if (newServerUuidObject instanceof String) {
                PercolatorsManagerImpl.this.serverUUID = (String)newServerUuidObject;
            }
        }
    }

    private class UserSessionRemovedEventHandler
    extends AbstractEventHandler {
        private UserSessionRemovedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Object sessionIdObject = event.getProperty("SessionId");
            if (sessionIdObject instanceof String) {
                try {
                    PercolatorsManagerImpl.this.deletePercolators((String)sessionIdObject);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to delete the percolators of a session id.", ex);
                }
            }
        }
    }
}

