/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.percolators.PercolatorImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

class PercolatorsOpenSearchHandler {
    private static final Logger LOG = Logger.getLogger(PercolatorsOpenSearchHandler.class.getName());
    private final OpenSearchService oss;

    PercolatorsOpenSearchHandler(OpenSearchService oss) {
        this.oss = oss;
    }

    boolean registerPercolator(Percolator percolator, QueryBuilder queryBuilder) {
        LOG.info("registerPercolator percolator=" + percolator + ", queryBuilder=" + queryBuilder);
        try {
            if (!this.oss.existsIndex(percolator.getIndex())) {
                LOG.info("Must not register the percolator query, because the related index '" + percolator.getIndex() + "' does not exist.");
                return false;
            }
            Map<String, String> currentFieldTypeMapping = this.oss.getFieldsTypeMapping(percolator.getIndex());
            if (!currentFieldTypeMapping.containsKey("_percolator_query") || !"percolator".equalsIgnoreCase(currentFieldTypeMapping.get("_percolator_query"))) {
                LOG.severe("Could not register the percolator query, because the mapping of the percolator type field '_percolator_query' is missing or is not of type 'percolator' in the related index '" + percolator.getIndex() + "'.");
                return false;
            }
            IndexRequest req = (IndexRequest)((IndexRequest)new IndexRequest().index(percolator.getIndex())).id(percolator.getUID()).source(XContentFactory.jsonBuilder().startObject().field("_percolator_query", queryBuilder).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            IndexResponse indexResponse = this.oss.getClient().index(req, RequestOptions.DEFAULT);
            LOG.info("indexResponse:" + indexResponse);
            return true;
        }
        catch (IOException | OpenSearchException ex) {
            LOG.log(Level.SEVERE, "Failed to create/update the percolator query of index '" + percolator.getIndex() + "' due to an OpenSearch error.", ex);
            return false;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create/update the percolator query of index '" + percolator.getIndex() + "'.", ex);
            return false;
        }
    }

    Set<Percolator> getPercolatorsFromIndex(String index) {
        LOG.info("getPercolatorsFromIndex index=" + index);
        HashSet<Percolator> result = new HashSet<Percolator>();
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            SearchResponse searchResponse = osClient.search(new SearchRequest().indices(index).source(new SearchSourceBuilder().size(100).query(QueryBuilders.existsQuery("_percolator_query"))).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT);
            SearchHit[] hits = searchResponse.getHits().getHits();
            while (hits != null && hits.length > 0) {
                for (SearchHit hit : hits) {
                    String indexName = hit.getIndex();
                    String indexAliasName = this.oss.aliasFromBpcIndexName(indexName);
                    String percolatorUID = hit.getId();
                    result.add(new PercolatorImpl(indexAliasName != null ? indexAliasName : indexName, percolatorUID));
                }
                searchResponse = osClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT);
                hits = searchResponse.getHits().getHits();
            }
            this.oss.releaseScrollId(searchResponse);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOG.warning("Evaluate percolator IDs ... the OpenSearch index does not exist: " + index);
            } else {
                LOG.log(Level.SEVERE, "Unhandled exception in PercolatorsManagerImpl.getPercolatorsFromIndex(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Evaluate percolator IDs .... failed to get the percolator of the index: " + index, ex);
        }
        return result;
    }

    void deletePercolators(Set<Percolator> percolatorsToDelete) throws OpenSearchRelatedException {
        LOG.info("deletePercolators percolatorsToDelete=" + percolatorsToDelete);
        if (percolatorsToDelete == null || percolatorsToDelete.isEmpty()) {
            return;
        }
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (Percolator percolatorToDelete : percolatorsToDelete) {
                bulkRequest.add(((DeleteRequest)new DeleteRequest().index(percolatorToDelete.getIndex())).id(percolatorToDelete.getUID()));
            }
            BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            LOG.info("Percolators deleted: " + bulkRequest.numberOfActions() + ", with failures: " + bulkResponse.hasFailures());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    List<Object> getContentOfNewOrUpdatedDatabaseIDs(String index, Set<String> newOrUpdatedDatabaseIDs) throws IOException {
        LOG.info("getContentOfNewOrUpdatedDatabaseIDs index=" + index + ", newOrUpdatedDatabaseIDs=...");
        ArrayList<Object> dataList = new ArrayList<Object>();
        if (newOrUpdatedDatabaseIDs != null && !newOrUpdatedDatabaseIDs.isEmpty()) {
            MultiGetRequest req = new MultiGetRequest().refresh(true);
            for (String databaseID : newOrUpdatedDatabaseIDs) {
                req.add(index, databaseID);
            }
            MultiGetResponse multiGetResponse = this.oss.getClient().mget(req, RequestOptions.DEFAULT);
            for (MultiGetItemResponse response : multiGetResponse.getResponses()) {
                dataList.add(response.getResponse().getSource());
            }
        }
        return dataList;
    }
}

