/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseProduct {
    private static final Logger LOG = Logger.getLogger(DatabaseProduct.class.getName());

    public static Identifier getIdentifierFromConnection(Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            LOG.info("databaseProductName = " + databaseProductName);
            if (databaseProductName != null) {
                String lowerCaseDatabaseProductName = databaseProductName.toLowerCase();
                if (lowerCaseDatabaseProductName.contains("oracle")) {
                    return Identifier.ORACLE;
                }
                if (lowerCaseDatabaseProductName.contains("microsoft")) {
                    return Identifier.MSSQL;
                }
                if (lowerCaseDatabaseProductName.contains("mysql")) {
                    return Identifier.MYSQL;
                }
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Failed to get the database product name from the JDBC connection.", ex);
        }
        return null;
    }

    public static enum Identifier {
        ORACLE,
        MSSQL,
        MYSQL;

    }
}

