/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.util.DateUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;

public class DbLowerLimitTimestampEvaluator {
    private static final Logger LOG = Logger.getLogger(DbLowerLimitTimestampEvaluator.class.getName());

    public static Timestamp getLowerLimitTimestamp(Connection connection, int queryTimeoutInSeconds, String tableName, String lastUpdateTimestampColumn, Timestamp startFromTimestamp) throws SQLException {
        LOG.info("getLowerLimitTimestamp connection=..., queryTimeoutInSeconds=" + queryTimeoutInSeconds + ", tableName=" + tableName + ", lastUpdateTimestampColumn=" + lastUpdateTimestampColumn + ", startFromTimestamp=" + startFromTimestamp);
        Timestamp ts = null;
        long currentTimestamp = System.currentTimeMillis();
        try (PreparedStatement lowerLimitStatement = connection.prepareStatement("SELECT min(" + lastUpdateTimestampColumn + ") AS MINDATE FROM " + tableName + " WHERE " + lastUpdateTimestampColumn + " >= ?");){
            lowerLimitStatement.setTimestamp(1, startFromTimestamp);
            if (queryTimeoutInSeconds >= 0) {
                lowerLimitStatement.setQueryTimeout(queryTimeoutInSeconds);
            }
            try (ResultSet lowerLimitResultSet = lowerLimitStatement.executeQuery();){
                if (lowerLimitResultSet.next()) {
                    ts = lowerLimitResultSet.getTimestamp(1);
                    if (ts != null) {
                        ts = DateUtil.addDurationToTimestamp(13, -1, ts);
                        LOG.info("lower limit resolved: " + ts);
                    } else {
                        ts = DateUtil.addDurationToTimestamp(13, -1, new Timestamp(currentTimestamp));
                        LOG.info("special case handling when the table is empty ... using the current timestamp as lower limit: " + ts);
                    }
                }
            }
        }
        return ts;
    }
}

