/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.replicator.DbColumnNamesToOpenSearchFieldNamesConverter;
import de.virtimo.bpc.core.replicator.VamSpecificXmlTypeProcessor;
import de.virtimo.bpc.util.StreamUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;

public class DbResultSetToJsonConverter {
    private static final Logger LOG = Logger.getLogger(DbResultSetToJsonConverter.class.getName());
    private final OpenSearchService oss;
    private final DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter;
    private final LookupJoins lookupJoins;
    private final VamSpecificXmlTypeProcessor vamSpecificXmlTypeProcessor;

    public DbResultSetToJsonConverter(OpenSearchService oss, DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter, LookupJoins lookupJoins, VamSpecificXmlTypeProcessor vamSpecificXmlTypeProcessor) {
        this.oss = oss;
        this.dbColumnNamesToOpenSearchFieldNamesConverter = dbColumnNamesToOpenSearchFieldNamesConverter;
        this.lookupJoins = lookupJoins;
        this.vamSpecificXmlTypeProcessor = vamSpecificXmlTypeProcessor;
    }

    private Calendar evaluateCalendarToUse(String dbColumnName, Calendar generalDateFieldColumnCalendar, String lastUpdateTimestampColumnName, Calendar lastUpdateTimestampColumnCalendar) {
        Calendar result = null;
        if (dbColumnName.equalsIgnoreCase(lastUpdateTimestampColumnName)) {
            result = lastUpdateTimestampColumnCalendar;
        }
        if (result == null) {
            result = generalDateFieldColumnCalendar;
        }
        return result;
    }

    public XContentBuilder resultToJsonObject(ResultSet rs, boolean syncFiles, boolean unzipSyncedFiles, Calendar generalDateFieldColumnCalendar, String lastUpdateTimestampColumnName, Calendar lastUpdateTimestampColumnCalendar) throws IOException, SQLException, OpenSearchRelatedException {
        XContentBuilder jsonObject = XContentFactory.jsonBuilder().startObject();
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        block24: for (int i = 1; i <= colCount; ++i) {
            String dbColumnName = rsmd.getColumnName(i);
            Calendar calToUse = this.evaluateCalendarToUse(dbColumnName, generalDateFieldColumnCalendar, lastUpdateTimestampColumnName, lastUpdateTimestampColumnCalendar);
            int dbColumnType = rsmd.getColumnType(i);
            String openSearchFieldName = this.dbColumnNamesToOpenSearchFieldNamesConverter.convert(dbColumnName);
            if (this.vamSpecificXmlTypeProcessor != null) {
                if (dbColumnName.equals("VERSIONEDATTRIBUTES") || dbColumnName.endsWith("_PROPERTIES")) {
                    SQLXML xml = rs.getSQLXML(dbColumnName);
                    if (xml == null) continue;
                    DOMSource columnValue = xml.getSource(DOMSource.class);
                    this.vamSpecificXmlTypeProcessor.appendVAMAttributes(this.oss, jsonObject, this.lookupJoins, columnValue);
                    continue;
                }
                if (dbColumnName.startsWith("VERSIONEDATTRIBUTES") || dbColumnName.equals("UNVERSIONEDATTRIBUTES")) continue;
            }
            switch (dbColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    String charValue = rs.getString(dbColumnName);
                    charValue = StringUtil.isNullOrEmpty(charValue) ? null : charValue;
                    jsonObject.field(openSearchFieldName, charValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, charValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case -16: 
                case -15: 
                case -9: {
                    String ncharValue = rs.getNString(dbColumnName);
                    ncharValue = StringUtil.isNullOrEmpty(ncharValue) ? null : ncharValue;
                    jsonObject.field(openSearchFieldName, ncharValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, ncharValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case -7: 
                case 16: {
                    boolean booleanValue = rs.getBoolean(dbColumnName);
                    jsonObject.field(openSearchFieldName, booleanValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, booleanValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case 92: {
                    Time timeObject = rs.getTime(dbColumnName);
                    String timeValue = timeObject == null ? null : timeObject.toString();
                    jsonObject.field(openSearchFieldName, timeValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, timeValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case 91: {
                    Date dateValue = calToUse != null ? rs.getDate(dbColumnName, calToUse) : rs.getDate(dbColumnName);
                    jsonObject.timeField(openSearchFieldName, this.oss.formatForOpenSearch(dateValue));
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, dateValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case 93: {
                    Timestamp timestampValue = calToUse != null ? rs.getTimestamp(dbColumnName, calToUse) : rs.getTimestamp(dbColumnName);
                    jsonObject.timeField(openSearchFieldName, this.oss.formatForOpenSearch(timestampValue));
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, timestampValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case -8: {
                    Object object = rs.getObject(dbColumnName);
                    if (object != null && Arrays.asList("oracle.sql.ROWID").contains(object.getClass().getName())) {
                        String rowidValue = String.valueOf(object);
                        jsonObject.field(openSearchFieldName, rowidValue);
                        DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, rowidValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                        continue block24;
                    }
                    if (object == null) continue block24;
                    LOG.log(Level.SEVERE, "Unhandled JDBC type class found for column '" + dbColumnName + "' with the type '" + dbColumnType + "': " + object.getClass().getName());
                    continue block24;
                }
                case -102: 
                case -101: 
                case -100: {
                    Object object = rs.getObject(dbColumnName);
                    if (object != null && Arrays.asList("oracle.sql.TIMESTAMPNS", "oracle.sql.TIMESTAMPTZ", "oracle.sql.TIMESTAMPLTZ").contains(object.getClass().getName())) {
                        Timestamp timestampValue = calToUse != null ? rs.getTimestamp(dbColumnName, calToUse) : rs.getTimestamp(dbColumnName);
                        jsonObject.timeField(openSearchFieldName, this.oss.formatForOpenSearch(timestampValue));
                        DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, timestampValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                        continue block24;
                    }
                    if (object == null) continue block24;
                    LOG.log(Level.SEVERE, "Unhandled JDBC type class found for column '" + dbColumnName + "' with the type '" + dbColumnType + "': " + object.getClass().getName());
                    continue block24;
                }
                case -155: {
                    Object object = rs.getObject(dbColumnName);
                    if (object != null && Arrays.asList("microsoft.sql.DateTimeOffset").contains(object.getClass().getName())) {
                        Timestamp timestampValue = calToUse != null ? rs.getTimestamp(dbColumnName, calToUse) : rs.getTimestamp(dbColumnName);
                        jsonObject.timeField(openSearchFieldName, this.oss.formatForOpenSearch(timestampValue));
                        DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, timestampValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                        continue block24;
                    }
                    if (object == null) continue block24;
                    LOG.log(Level.SEVERE, "Unhandled JDBC type class found for column '" + dbColumnName + "' with the type '" + dbColumnType + "': " + object.getClass().getName());
                    continue block24;
                }
                case -6: 
                case 4: 
                case 5: {
                    int intValue = rs.getInt(dbColumnName);
                    jsonObject.field(openSearchFieldName, intValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, intValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case -5: {
                    long bigintValue = rs.getLong(dbColumnName);
                    jsonObject.field(openSearchFieldName, bigintValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, bigintValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case 7: {
                    float realValue = rs.getFloat(dbColumnName);
                    jsonObject.field(openSearchFieldName, realValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, Float.valueOf(realValue), this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case 6: 
                case 8: {
                    double doubleValue = rs.getDouble(dbColumnName);
                    jsonObject.field(openSearchFieldName, doubleValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, doubleValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case 2: 
                case 3: {
                    BigDecimal bd = rs.getBigDecimal(dbColumnName);
                    if (bd == null || bd.scale() < 0) {
                        Object objectValue = rs.getObject(dbColumnName);
                        jsonObject.field(openSearchFieldName, objectValue);
                        continue block24;
                    }
                    try {
                        long longValue = bd.longValueExact();
                        if (Long.toString(longValue).equals(rs.getString(i))) {
                            jsonObject.field(openSearchFieldName, longValue);
                            DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, longValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                            continue block24;
                        }
                        double doubleValue = bd.doubleValue();
                        jsonObject.field(openSearchFieldName, doubleValue);
                        DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, doubleValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    }
                    catch (ArithmeticException e) {
                        double doubleValue = bd.doubleValue();
                        jsonObject.field(openSearchFieldName, doubleValue);
                        DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, doubleValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    }
                    continue block24;
                }
                case 2003: {
                    Array arrayValue = rs.getArray(dbColumnName);
                    jsonObject.field(openSearchFieldName, arrayValue);
                    continue block24;
                }
                case -3: 
                case -2: {
                    byte[] binaryData;
                    if (!syncFiles || (binaryData = rs.getBytes(dbColumnName)) == null || binaryData.length <= 0) continue block24;
                    jsonObject.field(openSearchFieldName, Base64.getEncoder().encode(binaryData));
                    continue block24;
                }
                case -4: {
                    if (!syncFiles) continue block24;
                    if (unzipSyncedFiles && StreamUtil.isGZipped(rs.getBinaryStream(dbColumnName))) {
                        jsonObject.field(openSearchFieldName, StreamUtil.unzip(rs.getBinaryStream(dbColumnName)));
                        continue block24;
                    }
                    byte[] binaryData = rs.getBytes(dbColumnName);
                    if (binaryData == null || binaryData.length <= 0) continue block24;
                    jsonObject.field(openSearchFieldName, Base64.getEncoder().encode(binaryData));
                    continue block24;
                }
                case 2004: {
                    Blob blob;
                    if (!syncFiles || (blob = rs.getBlob(dbColumnName)) == null) continue block24;
                    byte[] byteArrayValue = unzipSyncedFiles && StreamUtil.isGZipped(blob.getBinaryStream()) ? StreamUtil.unzip(blob.getBinaryStream()) : Base64.getEncoder().encode(blob.getBytes(1L, (int)blob.length()));
                    jsonObject.field(openSearchFieldName, byteArrayValue);
                    continue block24;
                }
                case 2005: {
                    Clob clob = rs.getClob(dbColumnName);
                    if (clob == null) continue block24;
                    String clobValue = StreamUtil.characterStreamAsString(clob.getCharacterStream());
                    jsonObject.field(openSearchFieldName, clobValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, clobValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                case 2009: {
                    SQLXML sqlXml = rs.getSQLXML(dbColumnName);
                    if (sqlXml == null) continue block24;
                    String xmlValue = sqlXml.getString();
                    jsonObject.field(openSearchFieldName, xmlValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, xmlValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
                default: {
                    Object defaultValue = rs.getObject(dbColumnName);
                    jsonObject.field(openSearchFieldName, defaultValue);
                    DbResultSetToJsonConverter.appendLookupData(this.oss, jsonObject, this.lookupJoins, dbColumnName, defaultValue, this.dbColumnNamesToOpenSearchFieldNamesConverter);
                    continue block24;
                }
            }
        }
        jsonObject.endObject();
        return jsonObject;
    }

    public static void appendLookupData(OpenSearchService oss, XContentBuilder jsonObject, LookupJoins lookupJoins, String columnName, Object columnValue, DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter) throws IOException, OpenSearchRelatedException {
        if (columnValue != null && lookupJoins.isLookupJoinKeyField(columnName)) {
            Map<String, Object> alreadyPrefixedLookupData = lookupJoins.getLookupJoinByKeyField(columnName).getAlreadyPrefixedLookupData(oss, columnValue);
            for (Map.Entry<String, Object> alreadyPrefixedLookupDataEntry : alreadyPrefixedLookupData.entrySet()) {
                String fieldName = dbColumnNamesToOpenSearchFieldNamesConverter.convert(alreadyPrefixedLookupDataEntry.getKey());
                Object fieldValue = alreadyPrefixedLookupDataEntry.getValue();
                if (fieldValue instanceof Date) {
                    jsonObject.timeField(fieldName, oss.formatForOpenSearch((Date)fieldValue));
                    continue;
                }
                if (fieldValue instanceof Timestamp) {
                    jsonObject.timeField(fieldName, oss.formatForOpenSearch((Timestamp)fieldValue));
                    continue;
                }
                if (fieldValue instanceof java.util.Date) {
                    jsonObject.timeField(fieldName, oss.formatForOpenSearch((java.util.Date)fieldValue));
                    continue;
                }
                jsonObject.field(fieldName, fieldValue);
            }
        }
    }
}

