/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.DbColumnNamesToOpenSearchFieldNamesConverter;
import de.virtimo.bpc.core.replicator.DbLowerLimitTimestampEvaluator;
import de.virtimo.bpc.core.replicator.DbResultSetToJsonConverter;
import de.virtimo.bpc.core.replicator.LastUpdateTimestampOnRestartHandler;
import de.virtimo.bpc.core.replicator.OpenSearchIndexMappingUpdater;
import de.virtimo.bpc.core.replicator.OpenSearchRecordID;
import de.virtimo.bpc.core.replicator.ReplicationJobCallback;
import de.virtimo.bpc.core.replicator.ReplicationJobSettings;
import de.virtimo.bpc.core.replicator.ReplicationJobStats;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.VamSpecificXmlTypeProcessor;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheck;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobLogData;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogService;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopy;
import de.virtimo.bpc.core.replicator.tailsync.TailSync;
import de.virtimo.bpc.core.resource.ConfigurationEndpoint;
import de.virtimo.bpc.util.DateUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentBuilder;
import org.osgi.framework.BundleContext;

public class ReplicationJob
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ReplicationJob.class.getName());
    public static final String REPLICATION_ENABLED_FIELD = "replicationEnabled";
    public static final boolean DEFAULT_REPLICATION_ENABLED = true;
    private final String id;
    private final String name;
    private final boolean enabled;
    private final ReplicationJobStats stats;
    private final ReplicationJobSettings settings;
    private final ReplicationSource source;
    private final ReplicationTarget target;
    private Timestamp lastUpdateTimestamp;
    private Timestamp lastUpdateTimestampOnRestart;
    private boolean forcedLastUpdateTimestampOnRestartReset;
    private Date lastDataRecordTimestamp;
    private ReplicationJobCallback callback;
    private final OpenSearchIndexMappingUpdater indexMappingUpdater;
    private final ShadowCopy shadowCopy;
    private final TailSync tailSync;
    private final ConsistencyCheck consistencyCheck;
    private final LookupJoins lookupJoins;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker = null;
    private BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker = null;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker = null;
    private BpcServicesTracker<ReplicationJobsLogService> replicationJobsLogServiceTracker = null;

    public ReplicationJob(BundleContext bundleContext, String moduleInstanceId, ModuleConfiguration jobConfig) {
        this.id = moduleInstanceId;
        this.name = ConfigurationEndpoint.getModuleInstanceName(jobConfig);
        this.enabled = jobConfig.getSettingValue(REPLICATION_ENABLED_FIELD).asBoolean(true);
        this.stats = new ReplicationJobStats();
        this.settings = new ReplicationJobSettings(jobConfig);
        this.source = new ReplicationSource(jobConfig);
        this.target = new ReplicationTarget(jobConfig);
        this.callback = null;
        this.indexMappingUpdater = new OpenSearchIndexMappingUpdater(this.id, this.target);
        this.lastUpdateTimestamp = new Timestamp(this.settings.getReplicationStartDateAsDate().getTime());
        this.lastUpdateTimestampOnRestart = null;
        this.forcedLastUpdateTimestampOnRestartReset = false;
        this.shadowCopy = new ShadowCopy(jobConfig);
        this.tailSync = new TailSync(jobConfig);
        this.consistencyCheck = new ConsistencyCheck(jobConfig);
        this.lookupJoins = new LookupJoins(jobConfig.getSetting("join"));
        this.initialize(bundleContext);
    }

    public void initialize(BundleContext bundleContext) {
        LOG.info("initialize bundleContext=" + bundleContext);
        BpcServicesTracker.stopAll(this);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.replicationJobsLogServiceTracker = new BpcServicesTracker<ReplicationJobsLogService>(bundleContext, ReplicationJobsLogService.class);
    }

    public void destroy() {
        LOG.info(this.id + ": destroy");
        BpcServicesTracker.stopAll(this);
        this.callback = null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ReplicationJobStats getStats() {
        return this.stats;
    }

    public ReplicationJobSettings getSettings() {
        return this.settings;
    }

    public Timestamp getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public Timestamp getLastUpdateTimestampOnRestart() {
        return this.lastUpdateTimestampOnRestart;
    }

    public void resetLastUpdateTimestampOnRestart() throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("resetLastUpdateTimestampOnRestart");
        if (!this.stats.isRunning()) {
            LastUpdateTimestampOnRestartHandler lastUpdateTimestampOnRestartHandler = new LastUpdateTimestampOnRestartHandler(this.id, this.openSearchServiceTracker.getService(), this.target.getIndex());
            lastUpdateTimestampOnRestartHandler.deleteFromIndex();
            this.lastUpdateTimestampOnRestart = null;
        }
        this.forcedLastUpdateTimestampOnRestartReset = true;
    }

    public ReplicationSource getSource() {
        return this.source;
    }

    public ReplicationTarget getTarget() {
        return this.target;
    }

    public Date getLastDataRecordTimestamp() {
        return this.lastDataRecordTimestamp;
    }

    public void setCallback(ReplicationJobCallback callback) {
        this.callback = callback;
    }

    public ShadowCopy getShadowCopy() {
        return this.shadowCopy;
    }

    public TailSync getTailSync() {
        return this.tailSync;
    }

    public ConsistencyCheck getConsistencyCheck() {
        return this.consistencyCheck;
    }

    public LookupJoins getLookupJoins() {
        return this.lookupJoins;
    }

    public DbResultSetToJsonConverter createDbResultSetToJsonConverter(OpenSearchService oss) {
        DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter = this.target.getDbColumnNamesToOpenSearchFieldNamesConverter();
        VamSpecificXmlTypeProcessor vamSpecificXmlTypeProcessor = null;
        if (this.settings.getVamOrganizationId() != null) {
            vamSpecificXmlTypeProcessor = new VamSpecificXmlTypeProcessor(oss, this.target.getIndex(), dbColumnNamesToOpenSearchFieldNamesConverter);
        }
        return new DbResultSetToJsonConverter(oss, dbColumnNamesToOpenSearchFieldNamesConverter, this.lookupJoins, vamSpecificXmlTypeProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.enabled) {
            LOG.fine(this.id + ": Replication job is disabled");
            return;
        }
        if (this.shadowCopy != null && this.shadowCopy.isEnabled() && this.shadowCopy.isRunning()) {
            LOG.warning(this.id + ": Replication job is suspended while a shadow copy task is running");
            return;
        }
        if (this.stats.isRunning()) {
            LOG.info(this.id + ": Replication job is already running");
            return;
        }
        this.stats.start();
        ReplicationJobLogData logData = new ReplicationJobLogData(this);
        ResultSet rs = null;
        Connection connection = null;
        Statement preparedStatement = null;
        int overallCounter = 0;
        try {
            LOG.info(this.id + ": Started replication " + this.stats.getJobCount() + " - " + this.stats.getLastRunStartDate());
            LOG.info(this.id + ": Block size: " + this.settings.getBlockSize());
            LOG.info(this.id + ": Sync files: " + this.settings.isSyncFiles());
            LOG.info(this.id + ": Unzip synced files: " + this.settings.isUnzipSyncedFiles());
            LOG.info(this.id + ": Restart replication where left off: " + this.settings.isRestartReplicationWhereLeftOff());
            LOG.info(this.id + ": Adjust upper date limit in seconds: " + this.settings.getAdjustUpperDateLimitInSeconds());
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            PercolatorsManager percolatorsManager = this.percolatorsManagerTracker.getService();
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            LastUpdateTimestampOnRestartHandler lastUpdateTimestampOnRestartHandler = new LastUpdateTimestampOnRestartHandler(this.id, oss, this.target.getIndex());
            if (this.forcedLastUpdateTimestampOnRestartReset) {
                this.forcedLastUpdateTimestampOnRestartReset = false;
                lastUpdateTimestampOnRestartHandler.deleteFromIndex();
                this.lastUpdateTimestampOnRestart = null;
                this.lastUpdateTimestamp = new Timestamp(this.settings.getReplicationStartDateAsDate().getTime());
                this.stats.reset();
            }
            BpcIndexState indexState = oss.getIndexState(this.target.getIndex());
            indexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    String indexName = oss.createIndex(ReplicationJob.this.target.getIndex(), ReplicationJob.this.target.hasIndexCreationSettings() ? ReplicationJob.this.target.getIndexCreationSettings() : oss.getDefaultIndexCreationSettings(), ReplicationJob.this.target.hasIndexMappings() ? ReplicationJob.this.target.getIndexMappings() : null);
                    ReplicationJob.this.indexMappingUpdater.reset();
                    ReplicationJob.this.lastUpdateTimestampOnRestart = null;
                    ReplicationJob.this.lastUpdateTimestamp = new Timestamp(ReplicationJob.this.settings.getReplicationStartDateAsDate().getTime());
                    ReplicationJob.this.stats.reset();
                    return indexName;
                }
            });
            if (this.stats.isFirstRun()) {
                this.lastUpdateTimestampOnRestart = lastUpdateTimestampOnRestartHandler.readFromIndex();
                if (this.lastUpdateTimestampOnRestart != null && this.lastUpdateTimestampOnRestart.before(this.lastUpdateTimestamp)) {
                    this.lastUpdateTimestampOnRestart = null;
                }
            }
            if (this.stats.isFirstRun()) {
                long t1 = System.currentTimeMillis();
                try {
                    if (!oss.waitForOpenSearch(60, new String[]{this.target.getIndex()})) {
                        indexState.reset();
                        throw new Exception("Replication job '" + this.id + "' failed. The target index '" + this.target.getIndex() + "' is not in an useable state.");
                    }
                }
                finally {
                    LOG.info(this.id + ": Waiting for ES index '" + this.target.getIndex() + "' took " + (System.currentTimeMillis() - t1) + "ms");
                }
            }
            connection = databaseManager.getDataSource(this.source.getDataSourceName()).getConnection();
            connection.setAutoCommit(false);
            if (this.stats.isFirstRun()) {
                LOG.info(this.id + ": firstRun - detecting lower date limit");
                if (this.settings.isRestartReplicationWhereLeftOff() && this.lastUpdateTimestampOnRestart != null) {
                    this.lastUpdateTimestamp = new Timestamp(this.lastUpdateTimestampOnRestart.getTime());
                    LOG.info(this.id + ": Using the restart timestamp: " + this.lastUpdateTimestamp);
                } else {
                    Timestamp lowerLimitTimestamp = DbLowerLimitTimestampEvaluator.getLowerLimitTimestamp(connection, this.source.getQueryTimeoutInSeconds(), this.source.getTable(), this.source.getLastUpdateTimestampColumn(), this.lastUpdateTimestamp);
                    if (lowerLimitTimestamp != null && lowerLimitTimestamp.after(this.lastUpdateTimestamp)) {
                        LOG.info(this.id + ": Fittet start date to oldest record found in range. Old limit: " + this.lastUpdateTimestamp.toLocalDateTime() + " new limit: " + lowerLimitTimestamp.toLocalDateTime());
                        this.lastUpdateTimestamp = lowerLimitTimestamp;
                    } else {
                        LOG.info(this.id + ": No lower limit fitting needed");
                    }
                }
                this.stats.setFirstRun(false);
            }
            Timestamp lowerDateLimit = DateUtil.cloneTimestampWithNanos(this.lastUpdateTimestamp);
            Timestamp upperDateLimit = DateUtil.addDaysToTimestamp(this.settings.getBlockDayRange(), this.lastUpdateTimestamp);
            boolean replicatingLatestRecords = upperDateLimit.getTime() >= this.stats.getLastRunStartDate().getTime();
            Calendar generalDateFieldColumnCalendar = DateUtil.getCalendar(this.source.getTimeZoneId());
            Calendar lastUpdateTimestampColumnCalendar = DateUtil.getCalendar(this.source.getLastUpdateTimestampColumnTimeZoneId());
            String query = "SELECT * FROM " + this.source.getTable() + " WHERE " + this.source.getLastUpdateTimestampColumn() + " > ? AND " + this.source.getLastUpdateTimestampColumn() + " < ? ORDER BY " + this.source.getLastUpdateTimestampColumn() + " ASC";
            preparedStatement = connection.prepareStatement(query, 1003, 1007);
            preparedStatement.setTimestamp(1, lowerDateLimit);
            logData.setQueryFromDate(lowerDateLimit);
            if (replicatingLatestRecords && this.settings.getAdjustUpperDateLimitInSeconds() > 0) {
                Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis() - (long)(this.settings.getAdjustUpperDateLimitInSeconds() * 1000));
                if (lastUpdateTimestampColumnCalendar != null) {
                    LOG.info(this.id + ": upper date limit query with " + this.settings.getAdjustUpperDateLimitInSeconds() + " seconds adjustment in '" + this.source.getLastUpdateTimestampColumnTimeZoneId() + "' timezone - " + query + " (from:" + lowerDateLimit.toLocalDateTime() + ", to: " + currentTimestamp.toLocalDateTime() + ")");
                    preparedStatement.setTimestamp(2, currentTimestamp, lastUpdateTimestampColumnCalendar);
                    logData.setQueryToDate(currentTimestamp);
                } else {
                    LOG.info(this.id + ": upper date limit query with " + this.settings.getAdjustUpperDateLimitInSeconds() + " seconds adjustment - " + query + " (from:" + lowerDateLimit.toLocalDateTime() + ", to: " + currentTimestamp.toLocalDateTime() + ")");
                    preparedStatement.setTimestamp(2, currentTimestamp);
                    logData.setQueryToDate(currentTimestamp);
                }
            } else {
                preparedStatement.setTimestamp(2, upperDateLimit);
                logData.setQueryToDate(upperDateLimit);
                LOG.info(this.id + ": regular query - " + query + " (from:" + lowerDateLimit.toLocalDateTime() + ", to: " + upperDateLimit.toLocalDateTime() + ")");
            }
            preparedStatement.setFetchSize(this.settings.getBlockSize());
            if (this.source.getQueryTimeoutInSeconds() >= 0) {
                preparedStatement.setQueryTimeout(this.source.getQueryTimeoutInSeconds());
            }
            long beforeQueryTimestamp = System.currentTimeMillis();
            rs = preparedStatement.executeQuery();
            LOG.info(this.id + ": Query executed in " + (System.currentTimeMillis() - beforeQueryTimestamp) + "ms");
            if (!indexState.isValid()) {
                throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
            }
            this.indexMappingUpdater.using(oss, rs);
            RestHighLevelClient osClient = oss.getClient();
            Set<Percolator> percolatorsFromIndex = percolatorsManager.getAllValidPercolatorsFromIndex(oss, this.target.getIndex());
            PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(oss, this.target.getIndex(), percolatorsFromIndex);
            percolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            DbResultSetToJsonConverter dbResultSetToJsonConverter = this.createDbResultSetToJsonConverter(oss);
            Timestamp lastDate = new Timestamp(this.stats.getLastRunStartDate().getTime());
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            while (rs.next()) {
                if (this.settings.getVamOrganizationId() != null && (!"0".equals(rs.getString("DELETED")) || !this.settings.getVamOrganizationId().equals(rs.getString("ORGANIZATIONID")))) continue;
                lastDate = rs.getTimestamp(this.source.getLastUpdateTimestampColumn());
                this.lastDataRecordTimestamp = lastDate;
                String recordId = OpenSearchRecordID.create(rs, this.source.getIdColumns());
                XContentBuilder jdbcResultSetContentBuilder = dbResultSetToJsonConverter.resultToJsonObject(rs, this.settings.isSyncFiles(), this.settings.isUnzipSyncedFiles(), generalDateFieldColumnCalendar, this.source.getLastUpdateTimestampColumn(), lastUpdateTimestampColumnCalendar);
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(this.target.getIndex())).id(recordId).source(jdbcResultSetContentBuilder);
                if (this.settings.isSyncFiles()) {
                    indexRequest.setPipeline(oss.getAttachmentsPipelineName(this.target.getIndex()));
                }
                bulkRequest.add(indexRequest);
                if (bulkRequest.numberOfActions() == this.settings.getBlockSize()) {
                    LOG.fine(this.id + ": Blocksize reached. Send data to OpenSearch.");
                    if (!indexState.isValid()) {
                        throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
                    }
                    BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                    LOG.fine(this.id + ": OpenSearch call done");
                    overallCounter += this.getNumberOfSuccessfullyIndexedDocuments(bulkResponse);
                    if (bulkResponse.hasFailures()) {
                        throw new Exception(bulkResponse.buildFailureMessage());
                    }
                    this.lastUpdateTimestamp = lastDate;
                    percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
                    bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                }
                if (!this.forcedLastUpdateTimestampOnRestartReset) continue;
                LOG.info(this.id + ": Cancelling running replication job due to user request.");
                break;
            }
            if (bulkRequest.numberOfActions() > 0) {
                if (!indexState.isValid()) {
                    throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
                }
                BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                LOG.fine(this.id + ": OpenSearch call done");
                overallCounter += this.getNumberOfSuccessfullyIndexedDocuments(bulkResponse);
                if (bulkResponse.hasFailures()) {
                    throw new Exception(bulkResponse.buildFailureMessage());
                }
                this.lastUpdateTimestamp = lastDate;
                percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
            }
            LOG.info(this.id + ": call percolator");
            percolatorsProcessor.process();
            if (overallCounter == 0 && !replicatingLatestRecords) {
                this.lastUpdateTimestamp = DateUtil.cloneTimestampWithNanos(upperDateLimit);
                LOG.info(this.id + ": Shift fetch date lower limit to " + upperDateLimit);
            }
            LOG.info(this.id + ": Stop replication number " + this.stats.getJobCount() + " - " + new Date());
            LOG.info(this.id + ": Replicated " + overallCounter + " records in " + this.stats.runningTimeInMillis() + "ms");
            if (this.lastUpdateTimestamp != null && (this.lastUpdateTimestampOnRestart == null || this.lastUpdateTimestampOnRestart.getTime() != this.lastUpdateTimestamp.getTime())) {
                this.lastUpdateTimestampOnRestart = DateUtil.cloneTimestampWithNanos(this.lastUpdateTimestamp);
                lastUpdateTimestampOnRestartHandler.saveToIndex(this.lastUpdateTimestampOnRestart);
            }
            if (this.callback != null) {
                this.callback.onFinished("replication", this, percolatorsProcessor);
            }
            this.stats.resetLastOccurredException();
        }
        catch (ServiceNotFoundException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Failed to start the replication job. " + ex.getMessage(), ex);
        }
        catch (SQLRecoverableException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Could be that setting the pool properties like pool.testOnBorrow, ... can solve this error (Timeout, BPC-1893): " + ex.getMessage(), ex);
        }
        catch (SQLException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": SQL error: " + ex.getLocalizedMessage(), ex);
        }
        catch (IOException | OpenSearchException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": OpenSearch error: " + ex.getLocalizedMessage(), ex);
        }
        catch (Exception ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Unexpected Exception!", ex);
        }
        catch (Throwable ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Unexpected Throwable!", ex);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, this.id + ": Closing prepared statement failed.", ex);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, this.id + ": Closing ResultSet failed.", ex);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, this.id + ": Closing database connection failed.", ex);
                }
            }
            this.stats.stop(overallCounter);
            logData.setValues(this.stats);
            this.persistLogData(logData);
        }
    }

    private int getNumberOfSuccessfullyIndexedDocuments(BulkResponse bulkResponse) {
        int result = 0;
        if (bulkResponse != null) {
            for (BulkItemResponse response : bulkResponse.getItems()) {
                if (response.isFailed()) continue;
                ++result;
            }
        }
        return result;
    }

    private void persistLogData(ReplicationJobLogData replicationJobLogData) {
        LOG.fine("persistLogData replicationJobsLogData=...");
        if (this.settings.isLoggingEnabled()) {
            try {
                ReplicationJobsLogService replicationJobsLogService = this.replicationJobsLogServiceTracker.getService();
                replicationJobsLogService.log(replicationJobLogData);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Failed to persist the replication job log data.", ex);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationJob)) {
            return false;
        }
        ReplicationJob that = (ReplicationJob)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ReplicationJob{id=" + this.id + ", enabled=" + this.enabled + ", settings=" + this.settings + ", source=" + this.source + ", target=" + this.target + ", lastUpdateTimestamp=" + this.lastUpdateTimestamp + ", shadowCopy=" + this.shadowCopy + ", tailSync=" + this.tailSync + ", consistencyCheck=" + this.consistencyCheck + ", lookupJoins=" + this.lookupJoins + "}";
    }
}

