/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.DatabaseProduct;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.SourceTableNameExtractor;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.quartz.CronExpression;

public class ReplicationModuleInstanceSettingValidator
implements SettingValidator {
    private static final Logger LOG = Logger.getLogger(ReplicationModuleInstanceSettingValidator.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public ReplicationModuleInstanceSettingValidator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "replication".equalsIgnoreCase(moduleId) && !ModuleConfiguration.isNoModuleInstanceId(moduleInstanceId);
    }

    @Override
    public boolean canValidate(Setting setting) {
        List<String> settingsToValidate = Arrays.asList("sourceTimeZone", "lastUpdateColumnTimeZone");
        return settingsToValidate.contains(setting.getName());
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOG.info("validate setting:" + setting);
        if ("sourceTimeZone".equals(setting.getName())) {
            try {
                String sourceTimeZone = (String)setting.getValue();
                if (!StringUtil.isNullOrEmpty(sourceTimeZone)) {
                    ZoneId.of(sourceTimeZone);
                }
            }
            catch (Exception ex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "The time zone (${field}) is invalid", MapUtil.mapOf("field", "sourceTimeZone"));
            }
        }
        if ("lastUpdateColumnTimeZone".equals(setting.getName())) {
            try {
                String lastUpdateTimestampColumnTimeZone = (String)setting.getValue();
                if (!StringUtil.isNullOrEmpty(lastUpdateTimestampColumnTimeZone)) {
                    ZoneId.of(lastUpdateTimestampColumnTimeZone);
                }
            }
            catch (Exception ex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "The time zone (${field}) is invalid", MapUtil.mapOf("field", "lastUpdateColumnTimeZone"));
            }
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOG.info("validate moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", settings:...");
        List<FrontendWarningException> frontendWarnings = null;
        ReplicationJob replicationJob = null;
        try {
            replicationJob = new ReplicationJob(this.bundleContext, moduleInstanceId, new SimpleModuleConfig(settings));
            frontendWarnings = this.validateReplicationJob(replicationJob);
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, cause.getMessage(), cause);
            }
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, ex.getMessage(), ex);
        }
        finally {
            if (replicationJob != null) {
                replicationJob.destroy();
            }
        }
        return frontendWarnings;
    }

    private List<FrontendWarningException> validateReplicationJob(ReplicationJob replicationJob) throws ValidationException {
        LOG.info("validateReplicationJob replicationJob:" + replicationJob);
        if (replicationJob == null) {
            return null;
        }
        if (!replicationJob.isEnabled()) {
            LOG.info("Skipping validation of disabled replication job: " + replicationJob);
            return null;
        }
        ArrayList<FrontendWarningException> frontendWarnings = new ArrayList<FrontendWarningException>();
        HashMap<String, Integer> databaseTableColumns = new HashMap<String, Integer>();
        ReplicationSource source = replicationJob.getSource();
        Connection databaseConnection = null;
        try {
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            LOG.info("Database manager service: " + (databaseManager != null));
            DataSource dataSource = databaseManager.getDataSource(source.getDataSourceName());
            LOG.info("Data source: " + (dataSource != null));
            databaseConnection = dataSource.getConnection();
            LOG.info("Database connection: " + (databaseConnection != null));
            if (databaseConnection == null || !databaseConnection.isValid(10)) {
                throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_INVALID_CONNECTION, "Database connection of replication job id '${subFieldValue}' is invalid", MapUtil.mapOf("subFieldValue", replicationJob.getId()));
            }
            LOG.info("Validating database table: " + source.getTable());
            DatabaseMetaData databaseMetaData = databaseConnection.getMetaData();
            SourceTableNameExtractor extractor = new SourceTableNameExtractor(databaseMetaData, source.getTable());
            if (!extractor.isParsed()) {
                throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_TABLE_NOT_FOUND, "Could not access the database table '${tableName}' of replication job id '${subFieldValue}'", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable()));
            }
            LOG.info("Source table name extractor: " + extractor);
            try (ResultSet tablesResultSet = databaseMetaData.getTables(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), null);){
                if (!tablesResultSet.next()) {
                    throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_TABLE_NOT_FOUND, "The database table '${tableName}' of replication job id '${subFieldValue}' does not exist", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable()));
                }
            }
            try (ResultSet lastUpdateColumnResultSet = databaseMetaData.getColumns(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), source.getLastUpdateTimestampColumn());){
                if (!lastUpdateColumnResultSet.next()) {
                    throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_COLUMN_NOT_FOUND, "The last update timestamp column '${column}' of replication job id '${subFieldValue}' does not exist in the database table '${tableName}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable(), "column", source.getLastUpdateTimestampColumn()));
                }
            }
            if (DatabaseProduct.getIdentifierFromConnection(databaseConnection) != DatabaseProduct.Identifier.ORACLE) {
                try {
                    if (!this.isColumnWithIndex(databaseConnection, extractor, source.getLastUpdateTimestampColumn())) {
                        frontendWarnings.add(new FrontendWarningException("Serious performance warning! There seems to be no index on the last update column '${column}' of the database table '${tableName}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable(), "column", source.getLastUpdateTimestampColumn())));
                    }
                }
                catch (SQLException e) {
                    LOG.log(Level.INFO, "Database exception while checking the table '" + source.getTable() + "' if an index exists for the last update timestamp column: '" + source.getLastUpdateTimestampColumn() + "'. Happens for example by database views.", e);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Unexpected exception occurred while checking the table '" + source.getTable() + "' if an index exists for the last update timestamp column: '" + source.getLastUpdateTimestampColumn() + "'.", e);
                }
            }
            for (String idColumn : source.getIdColumns()) {
                try (ResultSet idColumnResultSet = databaseMetaData.getColumns(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), idColumn);){
                    if (idColumnResultSet.next()) continue;
                    throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_COLUMN_NOT_FOUND, "The ID column '${column}' of replication job id '${subFieldValue}' does not exist in the database table '${tableName}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "tableName", source.getTable(), "column", idColumn));
                }
            }
            try (ResultSet allColumnsResultSet = databaseMetaData.getColumns(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), null);){
                while (allColumnsResultSet.next()) {
                    String columnName = allColumnsResultSet.getString("COLUMN_NAME");
                    int columnType = allColumnsResultSet.getInt("DATA_TYPE");
                    LOG.info("Database column:" + columnName + ", type:" + columnType);
                    databaseTableColumns.put(columnName, columnType);
                }
            }
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (ServiceNotFoundException ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, "No DatabaseManager service registered");
        }
        catch (DataSourceNotFoundException ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, "Data source '${dataSourceName}' not found while validating settings of replication job id '${subFieldValue}'", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "dataSourceName", ex.getProperties().get("dataSourceName")), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new ValidationException((ErrorCode)CoreErrorCode.DATABASE_EXCEPTION, "Database exception while validating settings of replication job id '${subFieldValue}'", MapUtil.mapOf("subFieldValue", replicationJob.getId()), (Throwable)ex);
        }
        finally {
            if (databaseConnection != null) {
                try {
                    databaseConnection.close();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Closing database connection failed.", ex);
                }
            }
        }
        if (replicationJob.getSettings().isSyncFiles()) {
            ReplicationTarget target = replicationJob.getTarget();
            try {
                OpenSearchService oss = this.openSearchServiceTracker.getService();
                if (oss.existsIndex(target.getIndex())) {
                    Map<String, String> typeMapping = oss.getFieldsTypeMapping(target.getIndex());
                    for (String databaseTableColumnName : databaseTableColumns.keySet()) {
                        int dbType = (Integer)databaseTableColumns.get(databaseTableColumnName);
                        if (dbType != 2004) continue;
                        String esType = typeMapping.get(databaseTableColumnName);
                        if (esType == null) {
                            throw new ValidationException((ErrorCode)CoreErrorCode.OPENSEARCH_MAPPING, "OpenSearch mapping of replication job id '${subFieldValue}' missing for database column '${column}'. Should be 'attachment' for BLOB types.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "column", databaseTableColumnName));
                        }
                        if (esType.equalsIgnoreCase("binary")) continue;
                        throw new ValidationException((ErrorCode)CoreErrorCode.OPENSEARCH_MAPPING, "Wrong OpenSearch mapping for database column '${column}' of replication job id '${subFieldValue}'. Expected 'attachment', is '${esType}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "column", databaseTableColumnName, "esType", esType));
                    }
                }
            }
            catch (ValidationException ex) {
                throw ex;
            }
            catch (ServiceNotFoundException ex) {
                throw new ValidationException((ErrorCode)CoreErrorCode.OPENSEARCH_EXCEPTION, "Failed to get the OpenSearch service.");
            }
            catch (Exception ex) {
                throw new ValidationException((ErrorCode)CoreErrorCode.OPENSEARCH_EXCEPTION, "OpenSearch exception while validating replication settings of replication job id '${subFieldValue}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId()), (Throwable)ex);
            }
        }
        try {
            replicationJob.getSettings().getDateFormatter().parse(replicationJob.getSettings().getReplicationStartDate());
        }
        catch (ParseException pex) {
            try {
                DateUtil.getDateForRelativeValue(replicationJob.getSettings().getReplicationStartDate());
            }
            catch (IllegalArgumentException iaex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Wrong replication start date '${startDate}' used in replication job id '${subFieldValue}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "startDate", replicationJob.getSettings().getReplicationStartDate()));
            }
        }
        if (replicationJob.getShadowCopy().isEnabled()) {
            String shadowCopyCronPattern = replicationJob.getShadowCopy().getCronPattern();
            try {
                CronExpression iaex = new CronExpression(shadowCopyCronPattern);
            }
            catch (ParseException ex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Invalid shadow copy cron pattern '${pattern}' used in replication job id '${subFieldValue}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "pattern", shadowCopyCronPattern), (Throwable)ex);
            }
        }
        if (replicationJob.getTailSync().isEnabled()) {
            String tailSyncCronPattern = replicationJob.getTailSync().getCronPattern();
            try {
                CronExpression ex = new CronExpression(tailSyncCronPattern);
            }
            catch (ParseException ex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Invalid tail sync cron pattern '${pattern}' used in replication job id '${subFieldValue}'.", MapUtil.mapOf("subFieldValue", replicationJob.getId(), "pattern", tailSyncCronPattern), (Throwable)ex);
            }
        }
        return frontendWarnings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isColumnWithIndex(Connection conn, SourceTableNameExtractor extractor, String columnNameToCheck) throws SQLException {
        LOG.info("isColumnWithIndex conn=..., extractor=" + extractor + ", columnNameToCheck=" + columnNameToCheck);
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        try (ResultSet rs = databaseMetaData.getIndexInfo(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), false, false);){
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                if (!columnNameToCheck.equalsIgnoreCase(columnName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        if (DatabaseProduct.getIdentifierFromConnection(conn) != DatabaseProduct.Identifier.ORACLE) return false;
        try (PreparedStatement pstmt = conn.prepareStatement("SELECT COLUMN_EXPRESSION FROM user_ind_expressions WHERE INDEX_NAME=?");
             ResultSet oracleIndexInfoRS = databaseMetaData.getIndexInfo(extractor.getCatalogName(), extractor.getSchemaName(), extractor.getTableName(), false, false);){
            block25: while (oracleIndexInfoRS.next()) {
                String indexName = oracleIndexInfoRS.getString("INDEX_NAME");
                String columnName = oracleIndexInfoRS.getString("COLUMN_NAME");
                if (columnName == null || !columnName.startsWith("SYS_")) continue;
                pstmt.setString(1, indexName);
                ResultSet oracleSearchRS = pstmt.executeQuery();
                try {
                    String colExpr;
                    do {
                        if (!oracleSearchRS.next()) continue block25;
                        colExpr = oracleSearchRS.getString("COLUMN_EXPRESSION");
                        LOG.info(extractor.getTableName() + "/" + columnName + "/" + indexName + ": Found the column expression: " + colExpr);
                    } while (!colExpr.toUpperCase().contains("\"" + columnNameToCheck.toUpperCase() + "\""));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (oracleSearchRS == null) continue;
                    oracleSearchRS.close();
                }
            }
            return false;
        }
    }
}

