/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.ModuleConfiguration;
import java.util.Date;

public class ConsistencyCheck {
    public static final String REPLICATION_CONSISTENCY_CHECK_FREQUENCY_FIELD = "replicationConsistencyCheckFrequency";
    public static final int DEFAULT_REPLICATION_CONSISTENCY_CHECK_FREQUENCY = 0;
    private boolean sourceAndTargetConsistent = true;
    private int consistencyCheckFrequency;
    private boolean running;
    private long runCount;
    private long errorCount;
    private Date lastRunStart;
    private Date lastRunEnd;
    private long LastRunSourceDocsCount;
    private long lastRunTargetDocsCount;

    public ConsistencyCheck(ModuleConfiguration jobConfig) {
        this.consistencyCheckFrequency = jobConfig.getSettingValue(REPLICATION_CONSISTENCY_CHECK_FREQUENCY_FIELD).asInt(0);
    }

    public boolean isSourceAndTargetConsistent() {
        return this.sourceAndTargetConsistent;
    }

    public void setSourceAndTargetConsistent(boolean sourceAndTargetConsistent) {
        this.sourceAndTargetConsistent = sourceAndTargetConsistent;
    }

    public int getConsistencyCheckFrequency() {
        return this.consistencyCheckFrequency;
    }

    public boolean isEnabled() {
        return this.consistencyCheckFrequency > 0;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public long getRunCount() {
        return this.runCount;
    }

    public void increaseRunCount() {
        ++this.runCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void increaseErrorCount() {
        ++this.errorCount;
    }

    public Date getLastRunStart() {
        return this.lastRunStart;
    }

    public void setLastRunStart(Date lastRunStart) {
        this.lastRunStart = lastRunStart;
    }

    public Date getLastRunEnd() {
        return this.lastRunEnd;
    }

    public void setLastRunEnd(Date lastRunEnd) {
        this.lastRunEnd = lastRunEnd;
    }

    public long getLastRunSourceDocsCount() {
        return this.LastRunSourceDocsCount;
    }

    public void setLastRunSourceDocsCount(long lastRunSourceDocsCount) {
        this.LastRunSourceDocsCount = lastRunSourceDocsCount;
    }

    public long getLastRunTargetDocsCount() {
        return this.lastRunTargetDocsCount;
    }

    public void setLastRunTargetDocsCount(long lastRunTargetDocsCount) {
        this.lastRunTargetDocsCount = lastRunTargetDocsCount;
    }

    public String toString() {
        return "ConsistencyCheck{sourceAndTargetConsistent=" + this.sourceAndTargetConsistent + ", consistencyCheckFrequency=" + this.consistencyCheckFrequency + "}";
    }
}

