/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConsistencyCheckDatabaseHandler {
    private static final Logger LOG = Logger.getLogger(ConsistencyCheckDatabaseHandler.class.getName());
    private final DatabaseManager databaseManager;
    private final String dataSourceName;
    private final String tableName;
    private final String lastUpdateTimestampColumn;
    private final String loggingPrefix;

    ConsistencyCheckDatabaseHandler(DatabaseManager databaseManager, String dataSourceName, String tableName, String lastUpdateTimestampColumn, String loggingPrefix) {
        this.databaseManager = databaseManager;
        this.dataSourceName = dataSourceName;
        this.tableName = tableName;
        this.lastUpdateTimestampColumn = lastUpdateTimestampColumn;
        this.loggingPrefix = loggingPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long countRecords(Timestamp lowerDateLimit, Timestamp upperDateLimit) throws DataSourceNotFoundException, SQLException {
        LOG.info(this.loggingPrefix + ": countRecords lowerDateLimit:" + lowerDateLimit + ", upperDateLimit:" + upperDateLimit);
        long start = System.currentTimeMillis();
        try {
            long result = -1L;
            Connection connection = null;
            Statement countPreparedStatement = null;
            ResultSet rs = null;
            try {
                connection = this.databaseManager.getDataSource(this.dataSourceName).getConnection();
                String sqlTemplate = "SELECT count(*) AS COUNT FROM " + this.tableName + " WHERE " + this.lastUpdateTimestampColumn + " >= ? AND " + this.lastUpdateTimestampColumn + " <= ?";
                countPreparedStatement = connection.prepareStatement(sqlTemplate, 1003, 1007);
                countPreparedStatement.setTimestamp(1, lowerDateLimit);
                countPreparedStatement.setTimestamp(2, upperDateLimit);
                LOG.fine(this.loggingPrefix + ": " + sqlTemplate + " (from: " + lowerDateLimit + ", to: " + upperDateLimit + ")");
                rs = countPreparedStatement.executeQuery();
                result = rs.next() ? rs.getLong("COUNT") : 0L;
            }
            finally {
                if (countPreparedStatement != null) {
                    try {
                        countPreparedStatement.close();
                    }
                    catch (SQLException ex) {
                        LOG.log(Level.SEVERE, this.loggingPrefix + ": Closing count prepared statement failed.", ex);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        LOG.log(Level.SEVERE, this.loggingPrefix + ": Closing ResultSet failed.", ex);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException ex) {
                        LOG.log(Level.SEVERE, this.loggingPrefix + ": Closing database connection failed.", ex);
                    }
                }
            }
            long l = result;
            return l;
        }
        finally {
            LOG.fine(this.loggingPrefix + ": countRecords time: " + (System.currentTimeMillis() - start) + "ms");
        }
    }
}

