/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import java.io.IOException;
import java.time.Instant;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.metrics.Max;
import org.opensearch.search.builder.SearchSourceBuilder;

class ConsistencyCheckOpenSearchHandler {
    private static final Logger LOG = Logger.getLogger(ConsistencyCheckOpenSearchHandler.class.getName());
    private final OpenSearchService oss;
    private final String index;
    private final String lastUpdateTimestampColumn;
    private final String loggingPrefix;

    ConsistencyCheckOpenSearchHandler(OpenSearchService oss, String index, String lastUpdateTimestampColumn, String loggingPrefix) {
        this.oss = oss;
        this.index = index;
        this.lastUpdateTimestampColumn = lastUpdateTimestampColumn;
        this.loggingPrefix = loggingPrefix;
    }

    Instant getUpperTargetDate() throws OpenSearchRelatedException {
        LOG.info(this.loggingPrefix + ": getUpperTargetDate");
        long start = System.currentTimeMillis();
        try {
            SearchRequest searchReq = new SearchRequest().indices(this.index).source(new SearchSourceBuilder().size(0).query(QueryBuilders.matchAllQuery()).aggregation((AggregationBuilder)AggregationBuilders.max("max_lastupdate").field(this.lastUpdateTimestampColumn)));
            SearchResponse maxLastupdateDateResponse = this.oss.getClient().search(searchReq, RequestOptions.DEFAULT);
            if (maxLastupdateDateResponse.getHits().getTotalHits().value == 0L) {
                LOG.info(this.loggingPrefix + ": No documents found to get the upper target date");
                Instant instant = null;
                return instant;
            }
            Max maxAgg = (Max)maxLastupdateDateResponse.getAggregations().get("max_lastupdate");
            LOG.info(this.loggingPrefix + ": maxAgg = " + maxAgg.getValueAsString());
            double maxAggValue = maxAgg.getValue();
            LOG.info(this.loggingPrefix + ": maxAggValue = " + maxAggValue);
            if (maxAggValue == Double.NEGATIVE_INFINITY) {
                LOG.info(this.loggingPrefix + ": Aggregation value not found to get the upper target date. Is '" + this.lastUpdateTimestampColumn + "' the correct aggregation field?");
                Instant instant = null;
                return instant;
            }
            Instant maxDate = Instant.ofEpochMilli((long)maxAggValue);
            LOG.fine(this.loggingPrefix + ": maxDate = " + maxDate);
            Instant instant = maxDate;
            return instant;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        finally {
            LOG.fine(this.loggingPrefix + ": getUpperTargetDate time: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    long countDocuments(Instant lowerDateLimit, Instant upperDateLimit) throws OpenSearchRelatedException {
        LOG.info(this.loggingPrefix + ": countDocuments lowerDateLimit=" + lowerDateLimit + ", upperDateLimit=" + upperDateLimit);
        long start = System.currentTimeMillis();
        try {
            SearchRequest countReq = new SearchRequest().indices(this.index).source(new SearchSourceBuilder().size(0).query(QueryBuilders.rangeQuery(this.lastUpdateTimestampColumn).gte(lowerDateLimit.toEpochMilli()).lte(upperDateLimit.toEpochMilli())));
            SearchResponse countResponse = this.oss.getClient().search(countReq, RequestOptions.DEFAULT);
            long l = countResponse.getHits().getTotalHits().value;
            return l;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        finally {
            LOG.fine(this.loggingPrefix + ": countDocuments time: " + (System.currentTimeMillis() - start) + "ms");
        }
    }
}

