/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckDatabaseHandler;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckOpenSearchHandler;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.logging.Logger;

public class ConsistencyCheckTask {
    private static final Logger LOG = Logger.getLogger(ConsistencyCheckTask.class.getName());
    private ReplicationJob replicationJob;
    private DatabaseManager databaseManager;
    private OpenSearchService oss;
    private String loggingPrefix;
    private ReplicationSource source;
    private ReplicationTarget target;
    private long numberOfSourceRows;
    private long numberOfTargetDocuments;

    private ConsistencyCheckTask() {
    }

    public ConsistencyCheckTask(ReplicationJob replicationJob, DatabaseManager databaseManager, OpenSearchService oss) {
        this.replicationJob = replicationJob;
        this.databaseManager = databaseManager;
        this.oss = oss;
        this.loggingPrefix = replicationJob.getId();
        this.source = replicationJob.getSource();
        this.target = replicationJob.getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws DataSourceNotFoundException, SQLException, OpenSearchRelatedException {
        LOG.info(this.loggingPrefix + ": process");
        long start = System.currentTimeMillis();
        try {
            ConsistencyCheckOpenSearchHandler esHandler = new ConsistencyCheckOpenSearchHandler(this.oss, this.target.getIndex(), this.source.getLastUpdateTimestampColumn(), this.loggingPrefix);
            ConsistencyCheckDatabaseHandler dbHandler = new ConsistencyCheckDatabaseHandler(this.databaseManager, this.source.getDataSourceName(), this.source.getTable(), this.source.getLastUpdateTimestampColumn(), this.loggingPrefix);
            Instant lowerDateLimit = this.replicationJob.getSettings().getReplicationStartDateAsDate().toInstant();
            LOG.info(this.loggingPrefix + ": lower date limit: " + lowerDateLimit);
            Instant upperDateLimit = esHandler.getUpperTargetDate();
            LOG.info(this.loggingPrefix + ": upper date limit: " + upperDateLimit);
            if (upperDateLimit == null) {
                LOG.info(this.loggingPrefix + ": Could not perform the consistency check without an upper date limit from the OpenSearch documents");
                this.numberOfSourceRows = -1L;
                this.numberOfTargetDocuments = -1L;
            } else {
                upperDateLimit = upperDateLimit.plus(1L, ChronoUnit.MILLIS);
                LOG.fine(this.loggingPrefix + ": adjusted upper date limit: " + upperDateLimit);
                this.numberOfSourceRows = dbHandler.countRecords(Timestamp.from(lowerDateLimit), Timestamp.from(upperDateLimit));
                LOG.info(this.loggingPrefix + ": numberOfSourceRows ......: " + this.numberOfSourceRows);
                this.numberOfTargetDocuments = esHandler.countDocuments(lowerDateLimit, upperDateLimit);
                LOG.info(this.loggingPrefix + ": numberOfTargetDocuments .: " + this.numberOfTargetDocuments);
            }
        }
        finally {
            LOG.fine(this.loggingPrefix + ": process time: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public boolean areSourceAndTargetConsistent() {
        return this.numberOfSourceRows >= 0L && this.numberOfTargetDocuments >= 0L && this.numberOfSourceRows == this.numberOfTargetDocuments;
    }

    public long getNumberOfSourceRows() {
        return this.numberOfSourceRows;
    }

    public long getNumberOfTargetDocuments() {
        return this.numberOfTargetDocuments;
    }
}

