/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.logger;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.AbstractSettingsUpdatedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobLogData;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogException;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogService;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class ReplicationJobsLogServiceImpl
implements ReplicationJobsLogService,
BpcService {
    private static final Logger LOG = Logger.getLogger(ReplicationJobsLogServiceImpl.class.getName());
    public static final String INDEX_NAME = "bpc-replicationjobs-log";
    private static final String ENABLED_SETTING_NAME = "replicationJobsLogEnabled";
    private static final String BULK_WRITE_PERIOD_IN_SECONDS_SETTING_NAME = "replicationJobsLogBulkWritePeriodInSeconds";
    private static final String CLEANUP_PERIOD_IN_MINUTES_SETTING_NAME = "replicationJobsLogCleanupPeriodInMinutes";
    private static final String DELETE_ENTRIES_OLDER_THAN_SETTING_NAME = "replicationJobsLogDeleteEntriesOlderThan";
    private static final AtomicInteger SEQ_COUNTER = new AtomicInteger(1);
    private BlockingQueue<Map<String, Object>> replicationJobLogEntriesQueue = new LinkedBlockingDeque<Map<String, Object>>();
    private ScheduledExecutorService writerExecutorService;
    private ScheduledFuture<?> replicationJobsLogIndexWriterTaskHandle = null;
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private final EventRegistration eventRegistration;
    private ReplicationModule replicationModule;

    public ReplicationJobsLogServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.writerExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-replicationjobslog-writer"));
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("replication", new ReplicationModuleLoadedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("replication", ENABLED_SETTING_NAME, new EnabledSettingUpdatedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("replication", BULK_WRITE_PERIOD_IN_SECONDS_SETTING_NAME, new BulkWritePeriodInSecondsSettingUpdatedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("replication", new IndexCleanupSettingsUpdatedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.stopReplicationJobsLogWriter();
        if (this.writerExecutorService != null) {
            try {
                this.writerExecutorService.shutdownNow();
                this.writerExecutorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.writerExecutorService = null;
            }
            catch (InterruptedException | RuntimeException ex) {
                LOG.log(Level.SEVERE, "Failed to shutdown the replication jobs log index writer task");
            }
        }
        this.stopReplicationJobsLogIndexCleanupTask();
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
        this.replicationModule = null;
    }

    private synchronized OpenSearchService getOpenSearchServiceWithPreparedReplicationJobLogIndex() throws ReplicationJobsLogException {
        LOG.info("getOpenSearchServiceWithPreparedReplicationJobLogIndex");
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            BpcIndexState replicationJobsLogIndexState = oss.getIndexState(INDEX_NAME);
            replicationJobsLogIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return oss.getManagedIndicesHandler().createManagedIndex(ReplicationJobsLogServiceImpl.INDEX_NAME);
                }
            });
            return oss;
        }
        catch (ServiceNotFoundException ex) {
            throw new ReplicationJobsLogException((ErrorCode)CoreErrorCode.REPLICATION_JOBS_LOGGING_FAILED, "OpenSearch service is not registered.");
        }
        catch (Exception ex) {
            throw new ReplicationJobsLogException((ErrorCode)CoreErrorCode.REPLICATION_JOBS_LOGGING_FAILED, (Throwable)ex);
        }
    }

    private Map<String, Object> convertToLogEntry(ReplicationJobLogData replicationJobLogData) throws ServiceNotFoundException {
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        String now = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        int seq = SEQ_COUNTER.getAndIncrement();
        if (seq == Integer.MAX_VALUE) {
            SEQ_COUNTER.set(1);
        }
        HashMap<String, Object> logEntry = new HashMap<String, Object>();
        logEntry.put("jobId", replicationJobLogData.getJobId());
        logEntry.put("dataSource", replicationJobLogData.getDataSource());
        logEntry.put("sourceTable", replicationJobLogData.getSourceTable());
        logEntry.put("targetIndex", replicationJobLogData.getTargetIndex());
        logEntry.put("startDate", oss.formatForOpenSearch(replicationJobLogData.getStartDate()));
        logEntry.put("endDate", oss.formatForOpenSearch(replicationJobLogData.getEndDate()));
        logEntry.put("durationInMilliseconds", replicationJobLogData.getDurationInMilliseconds());
        logEntry.put("numberOfReplicatedRecords", replicationJobLogData.getNumberOfReplicatedRecords());
        logEntry.put("queryFromDate", oss.formatForOpenSearch(replicationJobLogData.getQueryFromDate()));
        logEntry.put("queryToDate", oss.formatForOpenSearch(replicationJobLogData.getQueryToDate()));
        logEntry.put("usedIntervalInSeconds", replicationJobLogData.getUsedIntervalInSeconds());
        logEntry.put("usedDayRange", replicationJobLogData.getUsedDayRange());
        logEntry.put("usedBlockSize", replicationJobLogData.getUsedBlockSize());
        logEntry.put("error", replicationJobLogData.getError());
        logEntry.put("timestamp", now);
        logEntry.put("timestamp_seq", seq);
        return logEntry;
    }

    @Override
    public void log(ReplicationJobLogData replicationJobLogData) throws ReplicationJobsLogException {
        LOG.finest("log logData=...");
        if (this.replicationJobsLogIndexWriterTaskHandle == null) {
            LOG.finest("log - skip because replication jobs logging is not active");
            return;
        }
        try {
            Map<String, Object> logEntry = this.convertToLogEntry(replicationJobLogData);
            this.replicationJobLogEntriesQueue.add(logEntry);
        }
        catch (Exception ex) {
            throw new ReplicationJobsLogException((ErrorCode)CoreErrorCode.REPLICATION_JOBS_LOGGING_FAILED, "Replication jobs log indexing failed: ${error}", MapUtil.mapOf("error", ex.getMessage()));
        }
    }

    private void stopReplicationJobsLogWriter() {
        LOG.info("stopReplicationJobsLogWriter");
        if (this.replicationJobsLogIndexWriterTaskHandle != null) {
            if (this.replicationJobsLogIndexWriterTaskHandle.cancel(false)) {
                LOG.info("Running replication jobs log writer cancelled");
            } else {
                LOG.warning("Failed to stop/cancel the running replication jobs log writer");
            }
            this.replicationJobsLogIndexWriterTaskHandle = null;
        } else {
            LOG.info("There is no replication jobs log writer to stop/cancel");
        }
    }

    private boolean canStartWriter() {
        LOG.fine("canStartWriter");
        if (this.replicationModule == null) {
            return false;
        }
        boolean enabled = this.replicationModule.getConfiguration().getSettingValue(ENABLED_SETTING_NAME).asBoolean(false);
        return enabled;
    }

    private void rescheduleReplicationJobsLogWriter() {
        LOG.info("rescheduleReplicationJobsLogWriter");
        this.stopReplicationJobsLogWriter();
        if (this.canStartWriter()) {
            int batchWritePeriodInSeconds = this.replicationModule.getConfiguration().getSettingValue(BULK_WRITE_PERIOD_IN_SECONDS_SETTING_NAME).asInt(5);
            this.replicationJobsLogIndexWriterTaskHandle = this.writerExecutorService.scheduleWithFixedDelay(new ReplicationJobsLogWriterRunnable(), 0L, batchWritePeriodInSeconds, TimeUnit.SECONDS);
        }
    }

    private void stopReplicationJobsLogIndexCleanupTask() {
        LOG.info("stopReplicationJobsLogIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_NAME);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to stop/cancel the running cleanup task for the index 'bpc-replicationjobs-log'.", ex);
        }
    }

    private boolean canStartCleanupTask() {
        LOG.fine("canStartCleanupTask");
        if (this.replicationModule == null) {
            return false;
        }
        boolean enabled = this.replicationModule.getConfiguration().getSettingValue(ENABLED_SETTING_NAME).asBoolean(false);
        return enabled;
    }

    private void restartReplicationJobsLogIndexCleanupTask() {
        LOG.info("restartReplicationJobsLogIndexCleanupTask");
        this.stopReplicationJobsLogIndexCleanupTask();
        if (this.canStartCleanupTask()) {
            try {
                int cleanupPeriodInMinutes = this.replicationModule.getConfiguration().getSettingValue(CLEANUP_PERIOD_IN_MINUTES_SETTING_NAME).asInt(60);
                String deleteEntriesOlderThanSettingValue = this.replicationModule.getConfiguration().getSettingValue(DELETE_ENTRIES_OLDER_THAN_SETTING_NAME).asString("4 weeks ago");
                this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_NAME, "timestamp", deleteEntriesOlderThanSettingValue, cleanupPeriodInMinutes, TimeUnit.MINUTES);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to schedule the index cleanup task for the index 'bpc-replicationjobs-log'.", ex);
            }
        }
    }

    private class ReplicationModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private ReplicationModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            ReplicationJobsLogServiceImpl.this.replicationModule = (ReplicationModule)module;
            ReplicationJobsLogServiceImpl.this.rescheduleReplicationJobsLogWriter();
            ReplicationJobsLogServiceImpl.this.restartReplicationJobsLogIndexCleanupTask();
        }
    }

    class EnabledSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        EnabledSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting setting=...");
            ReplicationJobsLogServiceImpl.this.rescheduleReplicationJobsLogWriter();
            ReplicationJobsLogServiceImpl.this.restartReplicationJobsLogIndexCleanupTask();
        }
    }

    class BulkWritePeriodInSecondsSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        BulkWritePeriodInSecondsSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting setting=...");
            if (ReplicationJobsLogServiceImpl.this.replicationJobsLogIndexWriterTaskHandle != null) {
                ReplicationJobsLogServiceImpl.this.rescheduleReplicationJobsLogWriter();
            }
        }
    }

    class IndexCleanupSettingsUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        IndexCleanupSettingsUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList(ReplicationJobsLogServiceImpl.CLEANUP_PERIOD_IN_MINUTES_SETTING_NAME, ReplicationJobsLogServiceImpl.DELETE_ENTRIES_OLDER_THAN_SETTING_NAME));
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            ReplicationJobsLogServiceImpl.this.restartReplicationJobsLogIndexCleanupTask();
        }
    }

    class ReplicationJobsLogWriterRunnable
    implements Runnable {
        ReplicationJobsLogWriterRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                LOG.info(this.getClass().getSimpleName() + ": Starting ...");
                long startTime = System.currentTimeMillis();
                try {
                    Map logEntry;
                    ZonedDateTime now = ZonedDateTime.now().minus(500L, ChronoUnit.MILLIS);
                    ArrayList<Map> logEntriesToWrite = new ArrayList<Map>();
                    while ((logEntry = (Map)ReplicationJobsLogServiceImpl.this.replicationJobLogEntriesQueue.poll()) != null) {
                        logEntriesToWrite.add(logEntry);
                        ZonedDateTime logEntryDateTime = ZonedDateTime.parse((String)logEntry.get("timestamp"), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                        if (!logEntryDateTime.isAfter(now)) continue;
                        break;
                    }
                    LOG.info(this.getClass().getSimpleName() + ": " + logEntriesToWrite.size() + " entries to index (" + ReplicationJobsLogServiceImpl.this.replicationJobLogEntriesQueue.size() + " entries still in the queue)");
                    if (logEntriesToWrite.isEmpty()) break block13;
                    OpenSearchService oss = ReplicationJobsLogServiceImpl.this.getOpenSearchServiceWithPreparedReplicationJobLogIndex();
                    try {
                        RestHighLevelClient osClient = oss.getClient();
                        BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        for (Map logEntry2 : logEntriesToWrite) {
                            bulkRequest.add(((IndexRequest)new IndexRequest().index(ReplicationJobsLogServiceImpl.INDEX_NAME)).source(logEntry2, XContentType.JSON));
                        }
                        BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                        if (bulkResponse.hasFailures()) {
                            throw new ReplicationJobsLogException((ErrorCode)CoreErrorCode.REPLICATION_JOBS_LOGGING_FAILED, "Replication job log indexing failed.", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
                        }
                        ReplicationJobsLogServiceImpl.this.percolatorsManagerTracker.getService().informClientsAboutReplicatedData(oss, ReplicationJobsLogServiceImpl.INDEX_NAME, bulkResponse);
                    }
                    catch (IOException ex) {
                        throw new OpenSearchRelatedException(ex);
                    }
                    catch (OpenSearchException ex) {
                        throw new OpenSearchRelatedException(ex);
                    }
                }
                catch (ReplicationJobsLogException ex) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ": " + ex.getMessage(), ex);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed to write the replication job logs in batch.", ex);
                }
                finally {
                    LOG.info(this.getClass().getSimpleName() + ": Finished after " + (System.currentTimeMillis() - startTime) + " milliseconds");
                }
            }
        }
    }
}

