/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.shadowcopy;

import de.virtimo.bpc.api.ModuleConfiguration;
import java.util.Date;

public class ShadowCopy {
    public static final String SHADOWCOPY_ENABLED_FIELD = "replicationShadowCopyEnabled";
    public static final String SHADOWCOPY_CRON_PATTERN_FIELD = "replicationShadowCopyCronPattern";
    public static final String SHADOWCOPY_KEEP_COPIES_COUNT_FIELD = "replicationShadowCopyKeepCopiesCount";
    public static final boolean DEFAULT_SHADOWCOPY_ENABLED = false;
    public static final String DEFAULT_SHADOWCOPY_CRON_PATTERN = "0 0 16 ? * Sun";
    public static final int DEFAULT_SHADOWCOPY_KEEP_COPIES_COUNT = 3;
    private final boolean enabled;
    private final String cronPattern;
    private final int keepCopiesCount;
    private boolean running;
    private Date lastRunStart;
    private Date lastRunEnd;

    public ShadowCopy(ModuleConfiguration jobConfig) {
        this.enabled = jobConfig.getSettingValue(SHADOWCOPY_ENABLED_FIELD).asBoolean(false);
        this.cronPattern = jobConfig.getSettingValue(SHADOWCOPY_CRON_PATTERN_FIELD).asString(DEFAULT_SHADOWCOPY_CRON_PATTERN);
        this.keepCopiesCount = jobConfig.getSettingValue(SHADOWCOPY_KEEP_COPIES_COUNT_FIELD).asInt(3);
        this.running = false;
        this.lastRunEnd = null;
        this.lastRunStart = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getCronPattern() {
        return this.cronPattern;
    }

    public int getKeepCopiesCount() {
        return this.keepCopiesCount;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Date getLastRunStart() {
        return this.lastRunStart;
    }

    public void setLastRunStart(Date lastRunStart) {
        this.lastRunStart = lastRunStart;
    }

    public Date getLastRunEnd() {
        return this.lastRunEnd;
    }

    public void setLastRunEnd(Date lastRunEnd) {
        this.lastRunEnd = lastRunEnd;
    }

    public String toString() {
        return "ShadowCopy{enabled=" + this.enabled + ", cronPattern='" + this.cronPattern + "', keepCopiesCount=" + this.keepCopiesCount + "}";
    }
}

