/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.shadowcopy;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopy;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopyException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.tasks.CancelTasksRequest;
import org.opensearch.client.tasks.CancelTasksResponse;
import org.opensearch.client.tasks.TaskId;
import org.opensearch.client.tasks.TaskSubmissionResponse;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.reindex.ReindexRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class ShadowCopyTask
implements InterruptableJob {
    private static final Logger LOG = Logger.getLogger(ShadowCopyTask.class.getName());
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private ReplicationJob replicationJob;
    private String replicationJobId;
    private TaskId reindexTaskId;
    private boolean cancelled = false;

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void interrupt() throws UnableToInterruptJobException {
        LOG.info(this.replicationJobId + ": interrupt");
        if (!this.cancelled) {
            this.cancelled = true;
            if (this.reindexTaskId != null) {
                try {
                    this.cancelTask(this.reindexTaskId);
                }
                catch (ServiceNotFoundException ex) {
                    LOG.log(Level.WARNING, this.replicationJobId + ": Failed to cancel a running reindex task due to missing OpenSearch service.", ex);
                }
                catch (OpenSearchRelatedException ex) {
                    LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to cancel a running reindex task due to an OpenSearch problem.", ex);
                }
            }
        }
    }

    private boolean cancelTask(TaskId taskId) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info(this.replicationJobId + ": cancelTask taskId=" + taskId);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            CancelTasksRequest cancelTasksRequest = new CancelTasksRequest.Builder().withTaskId(taskId).build();
            CancelTasksResponse response = oss.getClient().tasks().cancel(cancelTasksRequest, RequestOptions.DEFAULT);
            if (response == null) {
                return false;
            }
            if (response.getNodeFailures() != null && !response.getNodeFailures().isEmpty()) {
                return false;
            }
            return response.getTaskFailures() == null || response.getTaskFailures().isEmpty();
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        OpenSearchService oss;
        String targetIndexName;
        boolean targetIndexMustBeDeletedOnProblems;
        ShadowCopy shadowCopy;
        block99: {
            block100: {
                block97: {
                    block98: {
                        block95: {
                            block96: {
                                block93: {
                                    block94: {
                                        block91: {
                                            block92: {
                                                block89: {
                                                    block90: {
                                                        block87: {
                                                            block88: {
                                                                block85: {
                                                                    block86: {
                                                                        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
                                                                        this.replicationJob = (ReplicationJob)jobDataMap.get((Object)"replicationJob");
                                                                        this.replicationJobId = this.replicationJob.getId();
                                                                        this.reindexTaskId = null;
                                                                        LOG.info(this.replicationJobId + ": execute context=" + context);
                                                                        BundleContext bundleContext = FrameworkUtil.getBundle(ShadowCopyTask.class).getBundleContext();
                                                                        shadowCopy = this.replicationJob.getShadowCopy();
                                                                        if (shadowCopy.isRunning()) {
                                                                            LOG.warning(this.replicationJobId + ": Skipping the shadow copy task execution. There is already a running task for the source index/alias: " + this.replicationJob.getTarget().getIndex());
                                                                            return;
                                                                        }
                                                                        if (!this.replicationJob.isEnabled()) {
                                                                            LOG.warning(this.replicationJobId + ": Skipping the shadow copy task execution. The related replication job is disabled.");
                                                                            return;
                                                                        }
                                                                        if (!shadowCopy.isEnabled()) {
                                                                            LOG.warning(this.replicationJobId + ": Skipping the shadow copy task execution. It is disabled.");
                                                                            return;
                                                                        }
                                                                        shadowCopy.setRunning(true);
                                                                        shadowCopy.setLastRunStart(new Date());
                                                                        shadowCopy.setLastRunEnd(null);
                                                                        targetIndexMustBeDeletedOnProblems = false;
                                                                        targetIndexName = null;
                                                                        oss = null;
                                                                        try {
                                                                            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
                                                                            oss = this.openSearchServiceTracker.getService();
                                                                            String sourceAliasName = this.replicationJob.getTarget().getIndex();
                                                                            LOG.info(this.replicationJobId + ": Source alias name to create a shadow copy from: " + sourceAliasName);
                                                                            if (this.isCancelled()) {
                                                                                LOG.warning(this.replicationJobId + ": Forced stop/termination of shadow copy task: " + sourceAliasName);
                                                                                return;
                                                                            }
                                                                            if (!oss.existsIndex(sourceAliasName)) {
                                                                                LOG.log(Level.SEVERE, this.replicationJobId + ": Source index/alias does not exist: " + sourceAliasName);
                                                                                throw new ShadowCopyException("Source index/alias does not exist: " + sourceAliasName);
                                                                            }
                                                                            Set<String> sourceIndices = oss.getIndexNamesWithAlias(sourceAliasName);
                                                                            if (sourceIndices.size() != 1) {
                                                                                LOG.log(Level.SEVERE, this.replicationJobId + ": Source alias '" + sourceAliasName + "' with multiple physical indices '" + sourceIndices + "' is not supported.");
                                                                                throw new ShadowCopyException("Source alias '" + sourceAliasName + "' with multiple physical indices '" + sourceIndices + "' is not supported.");
                                                                            }
                                                                            String sourceIndexName = sourceIndices.iterator().next();
                                                                            LOG.info(this.replicationJobId + ": Source index name to create a shadow copy from: " + sourceIndexName);
                                                                            this.deleteNoLongerUsedSourceIndices(oss, sourceAliasName, sourceIndexName, shadowCopy.getKeepCopiesCount() + 1);
                                                                            targetIndexName = oss.newIndexNameForAlias(sourceAliasName);
                                                                            LOG.info(this.replicationJobId + ": Target index name: " + targetIndexName);
                                                                            if (oss.existsIndex(targetIndexName)) {
                                                                                throw new ShadowCopyException("The target index '" + targetIndexName + "' exists already.");
                                                                            }
                                                                            if (this.isCancelled()) {
                                                                                LOG.warning(this.replicationJobId + ": Forced stop/termination of shadow copy task: " + sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems || targetIndexName == null) break block85;
                                                                                break block86;
                                                                            }
                                                                            try {
                                                                                Map<String, ?> defaultIndexCreationSettings = oss.getDefaultIndexCreationSettings();
                                                                                oss.createIndex(targetIndexName, defaultIndexCreationSettings);
                                                                            }
                                                                            catch (Exception ex) {
                                                                                throw new ShadowCopyException("Failed to create the target index '" + targetIndexName + "'.", ex);
                                                                            }
                                                                            targetIndexMustBeDeletedOnProblems = true;
                                                                            if (this.isCancelled()) {
                                                                                LOG.warning(this.replicationJobId + ": Forced stop of shadow copy task: " + sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block87;
                                                                                break block88;
                                                                            }
                                                                            try {
                                                                                oss.copyIndexMapping(sourceIndexName, targetIndexName);
                                                                            }
                                                                            catch (OpenSearchRelatedException ex) {
                                                                                throw new ShadowCopyException("Failed to set the source index mapping to the target index: " + targetIndexName);
                                                                            }
                                                                            if (this.isCancelled()) {
                                                                                LOG.warning(this.replicationJobId + ": Forced stop/termination of shadow copy task: " + sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block89;
                                                                                break block90;
                                                                            }
                                                                            Map<String, Object> sourceIndexTypeMetaData = oss.getMetaDataValues(sourceIndexName);
                                                                            if (sourceIndexTypeMetaData != null) {
                                                                                try {
                                                                                    oss.setMetaDataValues(targetIndexName, sourceIndexTypeMetaData);
                                                                                }
                                                                                catch (Exception ex) {
                                                                                    throw new ShadowCopyException("Failed to set the meta data values of the source index '" + sourceIndexName + "' to the target index '" + targetIndexName + "'.", ex);
                                                                                }
                                                                            }
                                                                            if (this.isCancelled()) {
                                                                                LOG.warning(this.replicationJobId + ": Forced stop/termination of shadow copy task: " + sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block91;
                                                                                break block92;
                                                                            }
                                                                            oss.flushIndices(sourceIndexName);
                                                                            LOG.info(this.replicationJobId + ": Reindex in progress ...");
                                                                            String lastUpdateTimestampColumn = this.replicationJob.getSource().getLastUpdateTimestampColumn();
                                                                            LOG.info(this.replicationJobId + ": Last update timestamp column name: " + lastUpdateTimestampColumn);
                                                                            Date replicationStartDate = this.replicationJob.getSettings().getReplicationStartDateAsDate();
                                                                            LOG.info(this.replicationJobId + ": Replication start date: " + replicationStartDate + " = " + replicationStartDate.getTime());
                                                                            RangeQueryBuilder filterQuery = QueryBuilders.rangeQuery(lastUpdateTimestampColumn).gte(replicationStartDate.getTime());
                                                                            LOG.info(this.replicationJobId + ": Filter query: " + filterQuery);
                                                                            ReindexRequest reindexRequest = new ReindexRequest();
                                                                            reindexRequest.setSourceIndices(sourceIndexName);
                                                                            reindexRequest.setDestIndex(targetIndexName);
                                                                            reindexRequest.setSourceQuery(filterQuery);
                                                                            reindexRequest.setRefresh(true);
                                                                            TaskSubmissionResponse reindexTaskResponse = oss.getClient().submitReindexTask(reindexRequest, RequestOptions.DEFAULT);
                                                                            LOG.fine(this.replicationJobId + ": Reindex task response = " + reindexTaskResponse);
                                                                            this.reindexTaskId = new TaskId(reindexTaskResponse.getTask());
                                                                            if (this.isCancelled()) {
                                                                                LOG.warning(this.replicationJobId + ": Forced stop/termination of shadow copy task: " + sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block93;
                                                                                break block94;
                                                                            }
                                                                            long reindexTaskStartTime = System.currentTimeMillis();
                                                                            try {
                                                                                oss.waitForTaskCompletionByPollingStatus(this.reindexTaskId, 3000L);
                                                                            }
                                                                            catch (OpenSearchRelatedException ex) {
                                                                                throw new ShadowCopyException("Reindex failed due to not completed reindex task. Source index:" + sourceIndexName + ", target index:" + targetIndexName, ex);
                                                                            }
                                                                            LOG.info(this.replicationJobId + ": Waited for reindex task completion: " + (System.currentTimeMillis() - reindexTaskStartTime) + " ms");
                                                                            this.reindexTaskId = null;
                                                                            if (this.isCancelled()) {
                                                                                LOG.warning(this.replicationJobId + ": Forced stop/termination of shadow copy task: " + sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block95;
                                                                                break block96;
                                                                            }
                                                                            LOG.info(this.replicationJobId + ": Alias switching from source to target index.");
                                                                            try {
                                                                                oss.moveAlias(sourceIndexName, targetIndexName);
                                                                            }
                                                                            catch (Exception ex) {
                                                                                throw new ShadowCopyException("Alias modifications failed. Source index:" + sourceIndexName + ", target index:" + targetIndexName, ex);
                                                                            }
                                                                            targetIndexMustBeDeletedOnProblems = false;
                                                                            oss.closeIndex(sourceIndexName);
                                                                            if (this.isCancelled()) {
                                                                                LOG.warning(this.replicationJobId + ": Forced stop/termination of shadow copy task: " + sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block97;
                                                                                break block98;
                                                                            }
                                                                            this.deleteNoLongerUsedSourceIndices(oss, sourceAliasName, targetIndexName, shadowCopy.getKeepCopiesCount());
                                                                            if (!targetIndexMustBeDeletedOnProblems) break block99;
                                                                            break block100;
                                                                        }
                                                                        catch (ShadowCopyException ex) {
                                                                            LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to perform the shadow copy task.", ex);
                                                                            throw ex;
                                                                        }
                                                                        catch (CancellationException ex) {
                                                                            LOG.info(this.replicationJobId + ": Shadow copy task terminated.");
                                                                            return;
                                                                        }
                                                                        catch (IllegalStateException ex) {
                                                                            if (ex.getCause() instanceof InterruptedException) {
                                                                                LOG.info(this.replicationJobId + ": Shadow copy task interrupted.");
                                                                                return;
                                                                            }
                                                                            LOG.log(Level.SEVERE, this.replicationJobId + ": Unexpectactly failed to perform the shadow copy task.", ex);
                                                                            throw new ShadowCopyException("Failed to perform the shadow copy task: " + ex.getMessage());
                                                                        }
                                                                        catch (Throwable ex) {
                                                                            LOG.log(Level.SEVERE, this.replicationJobId + ": Unexpectactly failed to perform the shadow copy task.", ex);
                                                                            throw new ShadowCopyException("Failed to perform the shadow copy task: " + ex.getMessage());
                                                                        }
                                                                    }
                                                                    LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                                                                    try {
                                                                        if (oss != null) {
                                                                            oss.deleteIndex(targetIndexName);
                                                                        }
                                                                    }
                                                                    catch (Throwable ex) {
                                                                        LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                                                                    }
                                                                }
                                                                shadowCopy.setRunning(false);
                                                                shadowCopy.setLastRunEnd(new Date());
                                                                BpcServicesTracker.stopAll(this);
                                                                return;
                                                            }
                                                            if (targetIndexName != null) {
                                                                LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                                                                try {
                                                                    if (oss != null) {
                                                                        oss.deleteIndex(targetIndexName);
                                                                    }
                                                                }
                                                                catch (Throwable ex) {
                                                                    LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                                                                }
                                                            }
                                                        }
                                                        shadowCopy.setRunning(false);
                                                        shadowCopy.setLastRunEnd(new Date());
                                                        BpcServicesTracker.stopAll(this);
                                                        return;
                                                    }
                                                    if (targetIndexName != null) {
                                                        LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                                                        try {
                                                            if (oss != null) {
                                                                oss.deleteIndex(targetIndexName);
                                                            }
                                                        }
                                                        catch (Throwable ex) {
                                                            LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                                                        }
                                                    }
                                                }
                                                shadowCopy.setRunning(false);
                                                shadowCopy.setLastRunEnd(new Date());
                                                BpcServicesTracker.stopAll(this);
                                                return;
                                            }
                                            if (targetIndexName != null) {
                                                LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                                                try {
                                                    if (oss != null) {
                                                        oss.deleteIndex(targetIndexName);
                                                    }
                                                }
                                                catch (Throwable ex) {
                                                    LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                                                }
                                            }
                                        }
                                        shadowCopy.setRunning(false);
                                        shadowCopy.setLastRunEnd(new Date());
                                        BpcServicesTracker.stopAll(this);
                                        return;
                                    }
                                    if (targetIndexName != null) {
                                        LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                                        try {
                                            if (oss != null) {
                                                oss.deleteIndex(targetIndexName);
                                            }
                                        }
                                        catch (Throwable ex) {
                                            LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                                        }
                                    }
                                }
                                shadowCopy.setRunning(false);
                                shadowCopy.setLastRunEnd(new Date());
                                BpcServicesTracker.stopAll(this);
                                return;
                            }
                            if (targetIndexName != null) {
                                LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                                try {
                                    if (oss != null) {
                                        oss.deleteIndex(targetIndexName);
                                    }
                                }
                                catch (Throwable ex) {
                                    LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                                }
                            }
                        }
                        shadowCopy.setRunning(false);
                        shadowCopy.setLastRunEnd(new Date());
                        BpcServicesTracker.stopAll(this);
                        return;
                    }
                    if (targetIndexName != null) {
                        LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                        try {
                            if (oss != null) {
                                oss.deleteIndex(targetIndexName);
                            }
                        }
                        catch (Throwable ex) {
                            LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                        }
                    }
                }
                shadowCopy.setRunning(false);
                shadowCopy.setLastRunEnd(new Date());
                BpcServicesTracker.stopAll(this);
                return;
            }
            if (targetIndexName != null) {
                LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                try {
                    if (oss != null) {
                        oss.deleteIndex(targetIndexName);
                    }
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                }
            }
        }
        shadowCopy.setRunning(false);
        shadowCopy.setLastRunEnd(new Date());
        BpcServicesTracker.stopAll(this);
        return;
        finally {
            if (targetIndexMustBeDeletedOnProblems && targetIndexName != null) {
                LOG.info(this.replicationJobId + ": Problem occurred ... deleting the temporary target index: " + targetIndexName);
                try {
                    if (oss != null) {
                        oss.deleteIndex(targetIndexName);
                    }
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, this.replicationJobId + ": Failed to delete the temporary target index: " + targetIndexName, ex);
                }
            }
            shadowCopy.setRunning(false);
            shadowCopy.setLastRunEnd(new Date());
            BpcServicesTracker.stopAll(this);
        }
    }

    private void deleteNoLongerUsedSourceIndices(OpenSearchService oss, String sourceAliasName, String indexToIgnore, int numberOfInstancesToKeep) throws OpenSearchRelatedException {
        LOG.info(this.replicationJobId + ": deleteNoLongerUsedSourceIndices oss=..., sourceAliasName=" + sourceAliasName + ", indexToIgnore=" + indexToIgnore + ", numberOfInstancesToKeep=" + numberOfInstancesToKeep);
        List<String> allIndices = oss.getAllBpcIndexNamesWithAlias(sourceAliasName);
        LOG.info(this.replicationJobId + ": All indices with prefix '" + sourceAliasName + "': " + allIndices);
        allIndices.remove(indexToIgnore);
        LOG.info(this.replicationJobId + ": Updated all indices with prefix '" + sourceAliasName + "': " + allIndices);
        List<String> indicesToDelete = ShadowCopyTask.getOpenSearchIndiceNamesToDelete(allIndices, numberOfInstancesToKeep);
        LOG.info(this.replicationJobId + ": Indices to delete: " + indicesToDelete);
        if (indicesToDelete.isEmpty()) {
            LOG.info(this.replicationJobId + ": No source indices to delete.");
        } else {
            for (String indiceToDelete : indicesToDelete) {
                try {
                    oss.deleteIndex(indiceToDelete);
                    LOG.info(this.replicationJobId + ": No longer used source index '" + indiceToDelete + "' deleted.");
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, this.replicationJobId + ": Could not delete the source index: '" + indiceToDelete + "'.");
                    throw new ShadowCopyException("Could not delete the source index: '" + indiceToDelete + "'.", ex);
                }
            }
        }
    }

    public static List<String> getOpenSearchIndiceNamesToDelete(List<String> indiceNames, int numberOfInstancesToKeep) {
        ArrayList<String> result = new ArrayList<String>();
        if (numberOfInstancesToKeep == 0) {
            result.addAll(indiceNames);
        } else if (numberOfInstancesToKeep < indiceNames.size()) {
            Collections.sort(indiceNames);
            Collections.reverse(indiceNames);
            for (int i = numberOfInstancesToKeep; i < indiceNames.size(); ++i) {
                result.add(indiceNames.get(i));
            }
        }
        return result;
    }
}

