/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.core.replicator.DbLowerLimitTimestampEvaluator;
import de.virtimo.bpc.core.replicator.OpenSearchRecordID;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.tailsync.GetDataResult;
import de.virtimo.bpc.core.replicator.tailsync.RecordData;
import de.virtimo.bpc.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class TailSyncDatabaseHandler {
    private static final Logger LOG = Logger.getLogger(TailSyncDatabaseHandler.class.getName());
    private final String replicationJobId;
    private Connection dbConnection = null;
    private PreparedStatement selectByRangePreparedStatement = null;
    private PreparedStatement selectByIdPreparedStatement = null;
    private boolean vamWorkaroundActive = false;
    private String vamOrganizationId = null;

    TailSyncDatabaseHandler(DatabaseManager databaseManager, String dataSourceName, String replicationJobId) throws DataSourceNotFoundException, SQLException {
        this.replicationJobId = replicationJobId;
        this.dbConnection = databaseManager.getDataSource(dataSourceName).getConnection();
        this.dbConnection.setAutoCommit(false);
    }

    void destroy() {
        LOG.info(this.replicationJobId + ": destroy");
        if (this.selectByRangePreparedStatement != null) {
            try {
                this.selectByRangePreparedStatement.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, this.replicationJobId + ": Closing 'select by range' prepared statement failed.", ex);
            }
        }
        if (this.selectByIdPreparedStatement != null) {
            try {
                this.selectByIdPreparedStatement.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, this.replicationJobId + ": Closing 'select by id' prepared statement failed.", ex);
            }
        }
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, this.replicationJobId + ": Closing database connection failed.", ex);
            }
        }
    }

    void initVamWorkaround(String vamOrganizationId) {
        this.vamWorkaroundActive = vamOrganizationId != null;
        this.vamOrganizationId = vamOrganizationId;
    }

    void initSelectByIdPreparedStatement(String dbSourceTable, String[] dbIdColumnNames) throws SQLException {
        this.selectByIdPreparedStatement = this.createSelectByIdPreparedStatement(dbSourceTable, dbIdColumnNames);
    }

    void initSelectByRangePreparedStatements(String dbSourceTable, int blockSize, String[] dbIdColumnNames, String dbLastUpdateColumnName) throws SQLException {
        this.selectByRangePreparedStatement = this.createSelectByRangePreparedStatement(dbSourceTable, dbIdColumnNames, dbLastUpdateColumnName);
        this.selectByRangePreparedStatement.setFetchSize(blockSize);
    }

    private PreparedStatement createSelectByIdPreparedStatement(String dbSourceTable, String[] dbIdColumnNames) throws SQLException {
        LOG.fine("createSelectByIdPreparedStatement dbSourceTable=" + dbSourceTable + ", dbIdColumnNames=...");
        ArrayList<String> idColumnConditions = new ArrayList<String>();
        for (String dbIdColumnName : dbIdColumnNames) {
            idColumnConditions.add(dbIdColumnName + "=?");
        }
        StringBuilder preparedStatement = new StringBuilder();
        preparedStatement.append("SELECT").append(" *").append(" FROM ").append(dbSourceTable).append(" WHERE ").append(StringUtil.implode(" AND ", idColumnConditions));
        LOG.info(this.replicationJobId + ": Prepared 'select by id' statement: " + preparedStatement);
        return this.dbConnection.prepareStatement(preparedStatement.toString(), 1003, 1007);
    }

    private PreparedStatement createSelectByRangePreparedStatement(String dbSourceTable, String[] dbIdColumnNames, String dbLastUpdateTimestampColumnName) throws SQLException {
        LOG.fine("createSelectByRangePreparedStatement dbSourceTable=" + dbSourceTable + ", dbIdColumnNames=..., dbLastUpdateTimestampColumnName=" + dbLastUpdateTimestampColumnName);
        StringBuilder preparedStatement = new StringBuilder();
        preparedStatement.append("SELECT ").append(StringUtil.implode(", ", dbIdColumnNames)).append(", ").append(dbLastUpdateTimestampColumnName).append(" FROM ").append(dbSourceTable).append(" WHERE ").append(dbLastUpdateTimestampColumnName).append(" > ?").append(" AND ").append(dbLastUpdateTimestampColumnName).append(" <= ?");
        if (this.vamWorkaroundActive) {
            preparedStatement.append(" AND (DELETED = '0' AND ORGANIZATIONID = ?)");
        }
        preparedStatement.append(" ORDER BY ").append(dbLastUpdateTimestampColumnName).append(" ASC");
        LOG.info(this.replicationJobId + ": Prepared 'select by lastupdate date' statement: " + preparedStatement);
        return this.dbConnection.prepareStatement(preparedStatement.toString(), 1003, 1007);
    }

    Timestamp evaluateStartTimestamp(String dbSourceTable, String dbLastUpdateColumnName, ReplicationJob replicationJob) throws SQLException {
        LOG.fine(this.replicationJobId + ": evaluateStartTimestamp dbSourceTable=" + dbSourceTable + ", dbLastUpdateColumnName=" + dbLastUpdateColumnName + ", replicationJob=" + replicationJob);
        Timestamp startTimestamp = new Timestamp(replicationJob.getSettings().getReplicationStartDateAsDate().getTime());
        Timestamp lowerLimitTimestamp = DbLowerLimitTimestampEvaluator.getLowerLimitTimestamp(this.dbConnection, replicationJob.getSource().getQueryTimeoutInSeconds(), dbSourceTable, dbLastUpdateColumnName, startTimestamp);
        if (lowerLimitTimestamp != null && lowerLimitTimestamp.after(startTimestamp)) {
            LOG.info(this.replicationJobId + ": Fittet start date to oldest record found in range. Old limit: " + startTimestamp + " new limit: " + lowerLimitTimestamp);
            return lowerLimitTimestamp;
        }
        LOG.info(this.replicationJobId + ": No lower limit fitting needed");
        return startTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GetDataResult getRecordData(String[] dbIdColumnNames, String dbLastUpdateColumnName, Timestamp lowerDateLimit, Timestamp upperDateLimit) {
        LOG.info(this.replicationJobId + ": getRecordData dbIdColumnNames=..., dbLastUpdateColumnName=" + dbLastUpdateColumnName + ", lowerDateLimit=" + lowerDateLimit + ", upperDateLimit=" + upperDateLimit);
        long startTimestamp = System.currentTimeMillis();
        try {
            HashMap<String, RecordData> result = new HashMap<String, RecordData>();
            this.selectByRangePreparedStatement.setTimestamp(1, lowerDateLimit);
            this.selectByRangePreparedStatement.setTimestamp(2, upperDateLimit);
            if (this.vamWorkaroundActive) {
                this.selectByRangePreparedStatement.setString(3, this.vamOrganizationId);
            }
            try (ResultSet rs = this.selectByRangePreparedStatement.executeQuery();){
                while (rs.next()) {
                    RecordData recordData = new RecordData(OpenSearchRecordID.getColumnNamesWithValues(rs, dbIdColumnNames), rs.getTimestamp(dbLastUpdateColumnName));
                    result.put(recordData.getRecordId(), recordData);
                }
            }
            GetDataResult getDataResult = new GetDataResult(result);
            return getDataResult;
        }
        catch (Throwable throwable) {
            GetDataResult getDataResult = new GetDataResult(throwable);
            return getDataResult;
        }
        finally {
            LOG.info(this.replicationJobId + ": getRecordData time: " + (System.currentTimeMillis() - startTimestamp) + "ms");
        }
    }

    ResultSet getDatabaseRecordByID(String[] idColumnNames, RecordData recordData) throws SQLException {
        LinkedHashMap<String, Object> idColumnNamesAndValues = recordData.getIdColumnNamesAndValues();
        for (int i = 0; i < idColumnNames.length; ++i) {
            this.selectByIdPreparedStatement.setObject(1 + i, idColumnNamesAndValues.get(idColumnNames[i]));
        }
        return this.selectByIdPreparedStatement.executeQuery();
    }
}

