/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.tailsync.GetDataResult;
import de.virtimo.bpc.core.replicator.tailsync.RecordData;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

class TailSyncOpenSearchHandler {
    private static final Logger LOG = Logger.getLogger(TailSyncOpenSearchHandler.class.getName());
    private final OpenSearchService oss;
    private final String osIndex;
    private final String replicationJobId;

    TailSyncOpenSearchHandler(OpenSearchService oss, String osIndex, String replicationJobId) {
        this.oss = oss;
        this.osIndex = osIndex;
        this.replicationJobId = replicationJobId;
    }

    void destroy() {
        LOG.info(this.replicationJobId + ": destroy");
    }

    void deleteDocumentsOlderThan(String lastUpdateField, Timestamp startTimestamp) throws OpenSearchRelatedException {
        LOG.info(this.replicationJobId + ": deleteDocumentsOlderThan lastUpdateField=" + lastUpdateField + ", startTimestamp=" + startTimestamp);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(this.osIndex).setQuery(QueryBuilders.rangeQuery(lastUpdateField).lt(startTimestamp.getTime()));
            BulkByScrollResponse dbqrsp = osClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            LOG.info(this.replicationJobId + ": Deleted " + dbqrsp.getDeleted() + " documents older than " + startTimestamp + " from '" + this.osIndex + "'");
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GetDataResult getRecordData(String[] dbIdColumnNames, String dbLastUpdateColumnName, Timestamp lowerDateLimit, Timestamp upperDateLimit) {
        LOG.info(this.replicationJobId + ": getRecordData dbIdColumnNames=..., dbLastUpdateColumnName=" + dbLastUpdateColumnName + ", lowerDateLimit=" + lowerDateLimit + ", upperDateLimit=" + upperDateLimit);
        long startTimestamp = System.currentTimeMillis();
        try {
            HashMap<String, RecordData> result = new HashMap<String, RecordData>();
            RestHighLevelClient osClient = this.oss.getClient();
            ArrayList<String> fieldNamesToFetch = new ArrayList<String>();
            fieldNamesToFetch.addAll(Arrays.asList(dbIdColumnNames));
            fieldNamesToFetch.add(dbLastUpdateColumnName);
            SearchRequest searchRequest = new SearchRequest().indices(this.osIndex).source(new SearchSourceBuilder().fetchSource(fieldNamesToFetch.toArray(new String[0]), null).size(10000).query(QueryBuilders.rangeQuery(dbLastUpdateColumnName).gt(lowerDateLimit.getTime()).lte(upperDateLimit.getTime()))).scroll(new TimeValue(60000L));
            SearchResponse searchResponse = osClient.search(searchRequest, RequestOptions.DEFAULT);
            do {
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    Map<String, Object> source = hit.getSourceAsMap();
                    LinkedHashMap<String, Object> idColumnNamesAndValues = new LinkedHashMap<String, Object>();
                    for (String columnName : dbIdColumnNames) {
                        idColumnNamesAndValues.put(columnName, source.get(columnName));
                    }
                    Object lastUpdateColumnValueObject = source.get(dbLastUpdateColumnName);
                    if (lastUpdateColumnValueObject instanceof String) {
                        Calendar calendar = DatatypeConverter.parseDateTime((String)((String)lastUpdateColumnValueObject));
                        RecordData recordData = new RecordData(idColumnNamesAndValues, calendar.getTime());
                        result.put(recordData.getRecordId(), recordData);
                        continue;
                    }
                    LOG.log(Level.SEVERE, this.replicationJobId + ": Unhandled type of lastUpdateColumnValueObject (" + lastUpdateColumnValueObject + "):" + lastUpdateColumnValueObject.getClass().getName());
                }
            } while ((searchResponse = osClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            this.oss.releaseScrollId(searchResponse);
            GetDataResult getDataResult = new GetDataResult(result);
            return getDataResult;
        }
        catch (IOException | OpenSearchException ex) {
            GetDataResult getDataResult = new GetDataResult(ex);
            return getDataResult;
        }
        catch (Throwable throwable) {
            GetDataResult getDataResult = new GetDataResult(throwable);
            return getDataResult;
        }
        finally {
            LOG.info(this.replicationJobId + ": getRecordData time: " + (System.currentTimeMillis() - startTimestamp) + "ms");
        }
    }
}

