/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="configuration")
public class ConfigurationLookupJoinsEndpoint {
    private static final Logger LOG = Logger.getLogger(ConfigurationLookupJoinsEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<LookupJoinsManager> lookupJoinsManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public ConfigurationLookupJoinsEndpoint(BundleContext bundleContext) {
        LOG.info("ConfigurationLookupJoinsEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.lookupJoinsManagerTracker = new BpcServicesTracker<LookupJoinsManager>(this.bundleContext, LookupJoinsManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @POST
    @Path(value="/lookupjoins/refresh")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOOKUP_JOINS_ADMIN", right="LOOKUP_JOINS_REFRESH_ALL", message="Not allowed to refresh all lookup joins")
    public Response refreshLookupJoinsOfAllReplicationJobs() {
        LOG.info("refreshLookupJoinsOfAllReplicationJobs");
        try {
            LookupJoinsManager lookupJoinsManager = this.lookupJoinsManagerTracker.getService();
            lookupJoinsManager.refreshAllLookupJoins();
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not refresh the lookup joins of all replication jobs.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/lookupjoins/refresh/replicationjob/{replicationJobId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOOKUP_JOINS_ADMIN", right="LOOKUP_JOINS_REFRESH", message="Not allowed to refresh lookup joins")
    public Response refreshLookupJoinsOfReplicationJob(@PathParam(value="replicationJobId") String replicationJobId) {
        LOG.info("refreshLookupJoinsOfReplicationJob");
        try {
            LookupJoinsManager lookupJoinsManager = this.lookupJoinsManagerTracker.getService();
            lookupJoinsManager.refreshLookupJoinsOfReplicationJob(replicationJobId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not refresh the lookup joins of the replication job with the id: " + replicationJobId, ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/lookupjoins/refresh/logservice/{logServiceId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOOKUP_JOINS_ADMIN", right="LOOKUP_JOINS_REFRESH", message="Not allowed to refresh lookup joins")
    public Response refreshLookupJoinsOfLogService(@PathParam(value="logServiceId") String logServiceId) {
        LOG.info("refreshLookupJoinsOfLogService");
        try {
            LookupJoinsManager lookupJoinsManager = this.lookupJoinsManagerTracker.getService();
            lookupJoinsManager.refreshLookupJoinsOfLogService(logServiceId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not refresh the lookup joins of the log service with the id: " + logServiceId, ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/lookupjoins/clearcaches")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOOKUP_JOINS_ADMIN", right="LOOKUP_JOINS_CLEAR_CACHE", message="Not allowed to clear the lookup join caches")
    public Response clearLookupJoinsCache() {
        LOG.info("clearLookupJoinsCache");
        try {
            LookupJoinsManager lookupJoinsManager = this.lookupJoinsManagerTracker.getService();
            lookupJoinsManager.clearLookupJoinCaches();
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not clear the lookup join caches.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

