/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.resource.response.ActiveWebsocketSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jetty.websocket.api.Session;

public class ActiveSession {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
    private final String sessionId;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String loginName;
    private final Date expirationDate;
    private final List<ActiveWebsocketSession> activeWebsocketSessions;

    public ActiveSession(ClientSession clientSession) {
        this.sessionId = clientSession.getNonHijackableSessionId();
        UserSession userSession = clientSession.getUserSession();
        if (userSession != null) {
            this.firstName = userSession.getFirstName();
            this.lastName = userSession.getLastName();
            this.email = userSession.getEmail();
            this.loginName = userSession.getLoginName();
            this.expirationDate = userSession.getExpirationDate();
        } else {
            this.firstName = null;
            this.lastName = null;
            this.email = null;
            this.loginName = null;
            this.expirationDate = null;
        }
        this.activeWebsocketSessions = new ArrayList<ActiveWebsocketSession>();
        for (Session websocketSession : clientSession.getWebsocketSessions()) {
            if (websocketSession == null) continue;
            this.activeWebsocketSessions.add(new ActiveWebsocketSession(websocketSession));
        }
    }

    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="loginName")
    public String getLoginName() {
        return this.loginName;
    }

    @JsonIgnore
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty(value="expirationTimestamp")
    public long getExpirationTimestamp() {
        return this.expirationDate == null ? 0L : this.expirationDate.getTime();
    }

    @JsonProperty(value="expirationDate")
    public String getFormattedExpirationDate() {
        return this.expirationDate == null ? null : this.dateFormat.format(this.expirationDate);
    }

    @JsonProperty(value="websocketSessions")
    public List<ActiveWebsocketSession> getActiveWebsocketSessions() {
        return this.activeWebsocketSessions;
    }
}

