/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.core.resource.response.MaskPasswords;
import de.virtimo.bpc.core.resource.response.SettingsBasedModuleInstanceConfigImpl;
import de.virtimo.bpc.module.DefaultModuleConfigurations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingsBasedModuleConfigImpl
implements ModuleConfig {
    private final String moduleId;
    private final Module module;
    private final List<Setting> allSettingsOfModule;

    public SettingsBasedModuleConfigImpl(String moduleId, Module module, List<Setting> allSettingsOfModule) {
        this.moduleId = moduleId;
        this.module = module;
        this.allSettingsOfModule = allSettingsOfModule;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public String getModuleName() {
        return this.module != null ? this.module.getModuleName() : this.moduleId;
    }

    @Override
    public List<Setting> getSettings() {
        ArrayList<Setting> result = new ArrayList<Setting>();
        for (Setting setting : this.allSettingsOfModule) {
            if (!ModuleConfiguration.isNoModuleInstanceId(setting.getInstanceId())) continue;
            result.add(setting);
        }
        return new MaskPasswords().maskPasswords(result);
    }

    private static Map<String, List<Setting>> getAsGroupedModuleInstanceSettings(List<Setting> allSettingsOfModule) {
        HashMap<String, ArrayList<Setting>> result = null;
        for (Setting setting : allSettingsOfModule) {
            ArrayList<Setting> instanceSettings;
            if (ModuleConfiguration.isNoModuleInstanceId(setting.getInstanceId())) continue;
            if (result == null) {
                result = new HashMap<String, ArrayList<Setting>>();
            }
            if ((instanceSettings = (ArrayList<Setting>)result.get(setting.getInstanceId())) == null) {
                instanceSettings = new ArrayList<Setting>();
                result.put(setting.getInstanceId(), instanceSettings);
            }
            instanceSettings.add(setting);
        }
        return result;
    }

    @Override
    public List<ModuleConfig> getInstances() {
        ArrayList<SettingsBasedModuleInstanceConfigImpl> result = null;
        Map<String, List<Setting>> groupedModuleInstanceSettings = SettingsBasedModuleConfigImpl.getAsGroupedModuleInstanceSettings(this.allSettingsOfModule);
        if (groupedModuleInstanceSettings != null) {
            result = new ArrayList<SettingsBasedModuleInstanceConfigImpl>();
            for (String instanceId : groupedModuleInstanceSettings.keySet()) {
                List<Setting> instanceSettings = groupedModuleInstanceSettings.get(instanceId);
                SettingsBasedModuleInstanceConfigImpl moduleInstanceConfig = new SettingsBasedModuleInstanceConfigImpl(this.getModuleName(), instanceId, instanceSettings);
                result.add(moduleInstanceConfig);
            }
        }
        return result;
    }

    @Override
    public Object getDefaultConfiguration() throws SettingException {
        if (this.module == null) {
            return null;
        }
        ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModule(this.module);
        return new ArrayList<Setting>(defaultConfig.getSettings().values());
    }

    @Override
    public Object getInstancesDefaultConfiguration() throws SettingException {
        if (this.module == null) {
            return null;
        }
        if (this.module instanceof InstantiableModule) {
            InstantiableModule instantiableModule = (InstantiableModule)this.module;
            if (!instantiableModule.usesInstanceTypes()) {
                ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModuleInstance(instantiableModule, "none");
                return new ArrayList<Setting>(defaultConfig.getSettings().values());
            }
            HashMap<String, ArrayList<Setting>> result = new HashMap<String, ArrayList<Setting>>();
            for (String supportedInstanceType : instantiableModule.getSupportedInstanceTypes()) {
                ModuleConfiguration defaultConfig = DefaultModuleConfigurations.getInstance().getForModuleInstance(instantiableModule, supportedInstanceType);
                result.put(supportedInstanceType, new ArrayList<Setting>(defaultConfig.getSettings().values()));
            }
            return result;
        }
        return null;
    }
}

