/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.core.resource.response.SettingValueFilter;
import de.virtimo.bpc.core.resource.response.SimpleModuleInstanceConfigImpl;
import java.util.ArrayList;
import java.util.List;

public class UserSessionBasedModuleInstanceConfigImpl
extends SimpleModuleInstanceConfigImpl {
    protected UserSession userSession;
    protected SettingValueFilter settingValueFilter;
    protected boolean onlySettingsMandatoryForFrontend;

    public UserSessionBasedModuleInstanceConfigImpl(ModuleInstance moduleInstance, UserSession userSession, boolean onlySettingsMandatoryForFrontend) {
        super(moduleInstance);
        this.userSession = userSession;
        this.settingValueFilter = new SettingValueFilter(userSession);
        this.onlySettingsMandatoryForFrontend = onlySettingsMandatoryForFrontend;
    }

    @Override
    public List<Setting> getSettings() {
        ArrayList<Setting> result = new ArrayList<Setting>();
        List<Setting> settings = this.settingValueFilter.filter(super.getSettings());
        if (settings != null) {
            for (Setting setting : settings) {
                if (!this.userSession.hasReadAccessToSetting(this.moduleInstance, setting)) continue;
                if (this.onlySettingsMandatoryForFrontend) {
                    if (!setting.getCustomFields().getBooleanValue("_mandatoryForFrontend", false)) continue;
                    result.add(setting);
                    continue;
                }
                result.add(setting);
            }
        }
        return result;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getDefaultConfiguration() throws SettingException {
        return super.getDefaultConfiguration();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getInstancesDefaultConfiguration() throws SettingException {
        return super.getInstancesDefaultConfiguration();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ModuleConfig> getInstances() {
        return null;
    }
}

