/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.WebErrorCode;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.JsonUtil;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

public class ErrorResponseServiceImpl
implements ErrorResponseService,
BpcService {
    private static final Logger LOG = Logger.getLogger(ErrorResponseServiceImpl.class.getName());
    private final BundleContext bundleContext;

    public ErrorResponseServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public Response responseForException(Exception ex) {
        return this.responseForException((String)null, ex);
    }

    @Override
    public Response responseForException(HttpHeaders headers, Exception ex) {
        return this.responseForException(ErrorResponseService.getBpcLanguage(headers), ex);
    }

    @Override
    public Response responseForException(String language, Exception ex) {
        if (ex instanceof SystemException) {
            ErrorCode errorCode;
            SystemException sex = (SystemException)ex;
            sex.setLanguage(language);
            if (sex.get("error") == null && sex.getCause() != null) {
                sex.set("error", sex.getCause().getLocalizedMessage());
            }
            if ((errorCode = sex.getErrorCode()) instanceof WebErrorCode) {
                return Response.status((Response.Status)((WebErrorCode)errorCode).getResponseStatus()).type("application/json").entity(sex.asErrorResponseMap()).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity(sex.asErrorResponseMap()).build();
        }
        if (ex instanceof UnsupportedOperationException) {
            return Response.status((Response.Status)CoreErrorCode.UNSUPPORTED_OPERATION.getResponseStatus()).type("application/json").entity(SystemException.wrap(ex, CoreErrorCode.UNSUPPORTED_OPERATION).asErrorResponseMap()).build();
        }
        return Response.status((Response.Status)CoreErrorCode.UNEXPECTED.getResponseStatus()).type("application/json").entity(SystemException.wrap(ex, CoreErrorCode.UNEXPECTED).asErrorResponseMap()).build();
    }

    @Override
    public <T extends Enum<T>> SystemException reconstructSystemException(Response r, Class<T> usingErrorCodeEnum) {
        try {
            String respString = (String)r.readEntity(String.class);
            Map respMap = JsonUtil.getInstance().convertJsonStringToPojo(respString, Map.class);
            if (respMap != null && respMap.containsKey("error")) {
                return this.createSystemExceptionFromErrorResponse(respMap, usingErrorCodeEnum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private <T extends Enum<T>> SystemException createSystemExceptionFromErrorResponse(Map<String, Object> errorRespMap, Class<T> usingErrorCodeEnum) {
        Map errorMap;
        if (errorRespMap != null && (errorMap = (Map)errorRespMap.get("error")) != null) {
            String name = (String)errorMap.get("name");
            ErrorCode errorCode = (ErrorCode)Enum.valueOf(usingErrorCodeEnum, name);
            String message = (String)errorMap.get("message");
            String messagePrefixKey = (String)errorMap.get("messagePrefixKey");
            String messageKey = (String)errorMap.get("messageKey");
            Map properties = (Map)errorMap.get("properties");
            if (messageKey != null) {
                return new SystemException(errorCode, messagePrefixKey, messageKey, properties);
            }
            return new SystemException(errorCode, messagePrefixKey, message, properties);
        }
        return null;
    }
}

