/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.storage;

import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilter;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataSort;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcSortBuilder;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.api.storage.StoreItems;
import de.virtimo.bpc.api.storage.exception.StoreIndexPreparationException;
import de.virtimo.bpc.api.storage.exception.StoreItemJsonException;
import de.virtimo.bpc.api.storage.exception.StoreItemNotFoundException;
import de.virtimo.bpc.api.storage.exception.StoreNotFoundException;
import de.virtimo.bpc.core.storage.IfIndexWasMissingCallable;
import de.virtimo.bpc.core.storage.StoreItemFactory;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;

class StoragePersistenceHandler {
    private static final Logger LOG = Logger.getLogger(StoragePersistenceHandler.class.getName());
    private final OpenSearchService oss;

    StoragePersistenceHandler(OpenSearchService oss) {
        this.oss = oss;
    }

    void createIndexIfMissing(final String indexName, final IfIndexWasMissingCallable ifIndexWasMissingCallable) throws StoreIndexPreparationException {
        LOG.info("createIndexIfMissing indexName=" + indexName);
        try {
            BpcIndexState indexState = this.oss.getIndexState(indexName);
            indexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    String managedIndexName = oss.getManagedIndicesHandler().createManagedIndex(indexName);
                    ifIndexWasMissingCallable.doSomethingWithTheMissingIndex(indexName);
                    return managedIndexName;
                }
            });
        }
        catch (Exception ex) {
            throw new StoreIndexPreparationException(indexName, ex);
        }
    }

    void saveStoreItem(String indexName, String storeId, StoreItem storeItem) throws StoreNotFoundException, StoreItemJsonException, OpenSearchRelatedException {
        LOG.info("saveStoreItem indexName=" + indexName + ", storeId=" + storeId + ", storeItem=...");
        String content = null;
        try {
            String itemId = storeItem.getId();
            content = storeItem.asJsonString();
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(indexName)).id(itemId).source(content, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.oss.getClient().index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (MapperParsingException ex) {
            LOG.warning(indexName + ": OpenSearch mapping mismatch while indexing the store item content: " + content);
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new StoreNotFoundException(storeId, indexName);
            }
            LOG.log(Level.SEVERE, "Unhandled exception in saveStoreItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    StoreItem loadStoreItem(String indexName, String storeId, String itemId) throws StoreNotFoundException, StoreItemNotFoundException, OpenSearchRelatedException {
        LOG.info("loadStoreItem indexName=" + indexName + ", storeId=" + storeId + ", itemId=" + itemId);
        try {
            GetRequest getRequest = ((GetRequest)new GetRequest().index(indexName)).id(itemId);
            GetResponse response = this.oss.getClient().get(getRequest, RequestOptions.DEFAULT);
            if (!response.isExists()) {
                throw new StoreItemNotFoundException(storeId, itemId, indexName);
            }
            return StoreItemFactory.create(response.getId(), response.getSourceAsMap());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new StoreNotFoundException(storeId, indexName);
            }
            LOG.log(Level.SEVERE, "Unhandled exception in loadStoreItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    StoreItems loadStoreItems(String indexName, String storeId, Integer start, Integer limit, String query, List<BpcDataFilter> filters, List<BpcDataSort> sorts, String timeZoneId, UserSession userSession) throws OpenSearchRelatedException, StoreNotFoundException {
        LOG.info("loadStoreItems indexName=" + indexName + ", storeId=" + storeId + ", start=" + start + ", limit=" + limit + ", query=" + query + ", filters=" + filters + ", sorts=" + sorts + ", timeZoneId=" + timeZoneId + ", userSession=...");
        try {
            BpcIndexMapping indexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(indexName));
            SearchSourceBuilder ssb = new SearchSourceBuilder().from(start).size(limit).version(true).trackTotalHitsUpTo(Integer.MAX_VALUE);
            QueryBuilder esQuery = new BpcQueryBuilder(indexName).addSkipPercolatorDocumentsQuery().addStringBasedQuery(query).addQueriesForFilters(filters, indexMapping, timeZoneId).addQueryBuilder(this.getQueryBuilderForSession(userSession)).buildAsBoolFilterQuery();
            ssb.query(esQuery);
            List<SortBuilder> sortBuilders = BpcSortBuilder.init(indexMapping).addSort(sorts).build();
            for (SortBuilder sortBuilder : sortBuilders) {
                ssb.sort(sortBuilder);
            }
            SearchRequest searchRequest = new SearchRequest().indices(indexName).source(ssb);
            SearchResponse searchResponse = this.oss.getClient().search(searchRequest, RequestOptions.DEFAULT);
            StoreItems storeItems = new StoreItems(start, limit);
            storeItems.setTotal(searchResponse.getHits().getTotalHits().value);
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                StoreItem storeItem = StoreItemFactory.create(hit.getId(), hit.getSourceAsMap());
                storeItems.add(storeItem);
            }
            return storeItems;
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException ex) {
            throw new StoreNotFoundException(storeId, indexName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new StoreNotFoundException(storeId, indexName);
            }
            LOG.log(Level.SEVERE, "Unhandled exception in loadStoreItems(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    void deleteStoreItem(String indexName, String storeId, String itemId) throws StoreNotFoundException, StoreItemNotFoundException, OpenSearchRelatedException {
        LOG.info("deleteStoreItem indexName=" + indexName + ", storeId=" + storeId + ", itemId=" + itemId);
        try {
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(indexName)).id(itemId);
            DeleteResponse deleteResponse = this.oss.getClient().delete(deleteRequest, RequestOptions.DEFAULT);
            if (deleteResponse.status() == RestStatus.NOT_FOUND) {
                throw new StoreItemNotFoundException(storeId, itemId, indexName);
            }
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new StoreNotFoundException(storeId, indexName);
            }
            LOG.log(Level.SEVERE, "Unhandled exception in deleteStoreItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    private QueryBuilder getQueryBuilderForSession(UserSession userSession) {
        LOG.info("getQueryBuilderForSession userSession=...");
        BoolQueryBuilder sessionQuery = QueryBuilders.boolQuery();
        if (userSession.hasRole("bpcadmin")) {
            BoolQueryBuilder userQuery = QueryBuilders.boolQuery();
            userQuery.must(QueryBuilders.termQuery("readRestriction.user", userSession.getLoginName()));
            sessionQuery.should(userQuery);
            BoolQueryBuilder notExistingUserQuery = QueryBuilders.boolQuery();
            notExistingUserQuery.mustNot(QueryBuilders.existsQuery("readRestriction.user"));
            sessionQuery.should(notExistingUserQuery);
        } else {
            List<Right> rights;
            List<Role> roles;
            BoolQueryBuilder userQuery = QueryBuilders.boolQuery();
            userQuery.must(QueryBuilders.termQuery("readRestriction.user", userSession.getLoginName()));
            sessionQuery.should(userQuery);
            List<Organisation> organisations = userSession.getOrganisations();
            if (!organisations.isEmpty()) {
                BoolQueryBuilder organisationsQuery = QueryBuilders.boolQuery();
                for (Organisation organisation : organisations) {
                    organisationsQuery.should(QueryBuilders.termQuery("readRestriction.organisations", organisation.getName()));
                }
                sessionQuery.should(organisationsQuery);
            }
            if (!(roles = userSession.getRoles()).isEmpty()) {
                BoolQueryBuilder rolesQuery = QueryBuilders.boolQuery();
                for (Role role : roles) {
                    rolesQuery.should(QueryBuilders.termQuery("readRestriction.roles", role.getName()));
                }
                sessionQuery.should(rolesQuery);
            }
            if (!(rights = userSession.getRights()).isEmpty()) {
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                for (Right right : rights) {
                    boolQueryBuilder.should(QueryBuilders.termQuery("readRestriction.rights", right.getName()));
                }
                sessionQuery.should(boolQueryBuilder);
            }
        }
        return sessionQuery;
    }
}

