/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.storage;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilter;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataSort;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.api.service.StorageService;
import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.api.storage.StoreItems;
import de.virtimo.bpc.api.storage.exception.StorageGeneralException;
import de.virtimo.bpc.api.storage.exception.StoreIndexPreparationException;
import de.virtimo.bpc.api.storage.exception.StoreItemExistsAlreadyException;
import de.virtimo.bpc.api.storage.exception.StoreItemJsonException;
import de.virtimo.bpc.api.storage.exception.StoreItemNotFoundException;
import de.virtimo.bpc.api.storage.exception.StoreItemRightsException;
import de.virtimo.bpc.api.storage.exception.StoreItemValidationException;
import de.virtimo.bpc.api.storage.exception.StoreNotFoundException;
import de.virtimo.bpc.core.storage.IfIndexWasMissingCallable;
import de.virtimo.bpc.core.storage.StoragePersistenceHandler;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class StorageServiceImpl
implements StorageService,
BpcService {
    private static final Logger LOG = Logger.getLogger(StorageServiceImpl.class.getName());
    private static final String INDEX_PREFIX = "bpc-store-";
    private static final String BACKUP_JOB_PREFIX = "core:storageservice:";
    public static final String DEFAULT_STORAGE_SERVICE_INDICES_BACKUP_SETTING_NAME = "defaultStorageServiceIndicesBackup";
    private final BundleContext bundleContext;
    private Setting defaultStorageServiceIndicesBackupSetting;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker = null;
    private BpcServicesTracker<BackupManager> backupManagerTracker = null;
    private final EventRegistration eventRegistration;

    public StorageServiceImpl(BundleContext bundleContext, Setting defaultStorageServiceIndicesBackupSetting) {
        this.bundleContext = bundleContext;
        this.defaultStorageServiceIndicesBackupSetting = defaultStorageServiceIndicesBackupSetting;
        if (bundleContext != null) {
            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
            this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
        } else {
            LOG.warning("BundleContext is null? Hopefully this is just an integration test.");
        }
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forModuleUpdatedEvents("_core", DEFAULT_STORAGE_SERVICE_INDICES_BACKUP_SETTING_NAME, new DefaultStorageServiceIndicesBackupSettingUpdatedEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new IndexDeletedEventHandler());
        if (bundleContext != null) {
            this.restartBackupJobs();
        } else {
            LOG.warning("BundleContext is null? Hopefully this is just an integration test.");
        }
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public synchronized void restartBackupJobs() {
        LOG.info("restartBackupJobs");
        try {
            Map<String, IndexInfo> allIndices = this.getOpenSearchService().getIndexInfos();
            for (IndexInfo indexInfo : allIndices.values()) {
                if (!indexInfo.getIndex().startsWith(INDEX_PREFIX)) continue;
                this.scheduleBackupJobForIndexAliases(indexInfo.getAliases());
            }
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Cannot schedule a storage service backup job without the BackupManager");
        }
        catch (OpenSearchRelatedException e) {
            LOG.log(Level.WARNING, "Ignoring storage service backup exception.", e);
        }
    }

    private void scheduleBackupJobForIndexAliases(Set<String> aliases) throws ServiceNotFoundException {
        LOG.info("scheduleBackupJobForIndexAliases aliases=" + aliases);
        if (this.defaultStorageServiceIndicesBackupSetting != null) {
            BackupSetting backupSetting = BackupSettingFactory.createFrom(this.defaultStorageServiceIndicesBackupSetting, aliases);
            this.backupManagerTracker.getService().scheduleBackupJobWithSettings(BACKUP_JOB_PREFIX + backupSetting.getIndicesToBackupNamesAsKey(), backupSetting);
        }
    }

    private void scheduleBackupJobForIndexAlias(String alias) {
        LOG.info("scheduleBackupJobForIndexAlias alias=" + alias);
        try {
            this.scheduleBackupJobForIndexAliases(SetUtil.setOf(alias));
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to schedule a backup job for the index alias: " + alias + " due to a missing service.", ex);
        }
    }

    private String getIndexName(String storeId) {
        return (INDEX_PREFIX + storeId).toLowerCase();
    }

    public OpenSearchService getOpenSearchService() throws ServiceNotFoundException {
        return this.openSearchServiceTracker.getService();
    }

    @Override
    public StoreItems getItems(String storeId, Integer start, Integer limit, String query, String filtersAsJsonArray, String sort, String timeZoneId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StorageGeneralException, StoreNotFoundException {
        LOG.info("getItems storeId=" + storeId + ", start=" + start + ", limit=" + limit + ", query=" + query + ", filtersAsJsonArray=" + filtersAsJsonArray + ", sort=" + sort + ", timeZoneId=" + timeZoneId + ", userSession=...");
        List<BpcDataFilter> filters = null;
        if (!StringUtil.isNullOrEmpty(filtersAsJsonArray)) {
            try {
                filters = BpcDataFilter.fromJsonArray(filtersAsJsonArray);
            }
            catch (Exception ex) {
                throw new StorageGeneralException((ErrorCode)BpcErrorCode.STORAGE_JSON_PARSE_EXCEPTION, "Parsing a JSON filters string to a EsDataFilter list failed.", ex);
            }
        }
        List<BpcDataSort> sorts = null;
        if (!StringUtil.isNullOrEmpty(sort)) {
            try {
                sorts = BpcDataSort.fromJsonArray(sort);
            }
            catch (Exception ex) {
                sorts = BpcDataSort.fromCompactFormat(sort);
            }
        }
        return this.getItems(storeId, start, limit, query, filters, sorts, timeZoneId, userSession);
    }

    @Override
    public StoreItems getItems(String storeId, Integer start, Integer limit, String query, List<BpcDataFilter> filters, List<BpcDataSort> sorts, String timeZoneId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreNotFoundException {
        LOG.info("getItems storeId=" + storeId + ", start=" + start + ", limit=" + limit + ", query=" + query + ", filters=" + filters + ", sorts=" + sorts + ", timeZoneId=" + timeZoneId + ", userSession=...");
        if (start == null || start < 0) {
            start = 0;
            LOG.finest("Not start parameter or out of range. Set start to " + start);
        }
        if (limit == null || limit < 0 || limit > 10000) {
            limit = 1000;
            LOG.finest("Not limit parameter or out of range. Set limit to " + limit);
        }
        String indexName = this.getIndexName(storeId);
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        return persistenceHandler.loadStoreItems(indexName, storeId, start, limit, query, filters, sorts, timeZoneId, userSession);
    }

    @Override
    public StoreItem getItem(String storeId, String itemId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreNotFoundException, StoreItemNotFoundException, StoreItemRightsException {
        LOG.info("getItem storeId=" + storeId + ", itemId=" + itemId + ", userSession=...");
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        String indexName = this.getIndexName(storeId);
        StoreItem storeItem = persistenceHandler.loadStoreItem(indexName, storeId, itemId);
        if (!storeItem.isReadableBy(userSession)) {
            throw new StoreItemRightsException(storeId, itemId);
        }
        return storeItem;
    }

    @Override
    public void createItem(String storeId, StoreItem storeItem, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreItemExistsAlreadyException, StoreIndexPreparationException, StoreItemJsonException, StoreNotFoundException, StoreItemValidationException {
        LOG.info("createItem storeId=" + storeId + ", storeItem=" + storeItem + ", userSession=...");
        this.validateStoreItem(storeItem);
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        String indexName = this.getIndexName(storeId);
        try {
            StoreItem existingStoreItem = persistenceHandler.loadStoreItem(indexName, storeId, storeItem.getId());
            if (existingStoreItem != null) {
                throw new StoreItemExistsAlreadyException(storeId, storeItem.getId());
            }
        }
        catch (StoreItemNotFoundException | StoreNotFoundException storageException) {
            // empty catch block
        }
        persistenceHandler.createIndexIfMissing(indexName, new IfIndexWasMissingCallable(){

            @Override
            public void doSomethingWithTheMissingIndex(String indexName) {
                StorageServiceImpl.this.scheduleBackupJobForIndexAlias(indexName);
            }
        });
        persistenceHandler.saveStoreItem(indexName, storeId, storeItem);
    }

    @Override
    public void updateOrCreateItem(String storeId, StoreItem storeItem, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreItemRightsException, StoreIndexPreparationException, StoreNotFoundException, StoreItemJsonException, StoreItemValidationException {
        LOG.info("updateOrCreateItem storeId=" + storeId + ", storeItem=" + storeItem + ", userSession=...");
        this.validateStoreItem(storeItem);
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        String indexName = this.getIndexName(storeId);
        try {
            StoreItem existingStoreItem = persistenceHandler.loadStoreItem(indexName, storeId, storeItem.getId());
            if (!existingStoreItem.isWriteableBy(userSession)) {
                throw new StoreItemRightsException(storeId, storeItem.getId());
            }
        }
        catch (StoreItemNotFoundException | StoreNotFoundException storageException) {
            // empty catch block
        }
        persistenceHandler.createIndexIfMissing(indexName, new IfIndexWasMissingCallable(){

            @Override
            public void doSomethingWithTheMissingIndex(String indexName) {
                StorageServiceImpl.this.scheduleBackupJobForIndexAlias(indexName);
            }
        });
        persistenceHandler.saveStoreItem(indexName, storeId, storeItem);
    }

    @Override
    public void deleteItem(String storeId, String itemId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreNotFoundException, StoreItemNotFoundException, StoreItemRightsException {
        LOG.info("deleteItem storeId=" + storeId + ", itemId=" + itemId + ", userSession=...");
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        String indexName = this.getIndexName(storeId);
        StoreItem storeItem = persistenceHandler.loadStoreItem(indexName, storeId, itemId);
        if (!storeItem.isDeletableBy(userSession)) {
            throw new StoreItemRightsException(storeId, itemId);
        }
        persistenceHandler.deleteStoreItem(indexName, storeId, itemId);
    }

    private void validateStoreItem(StoreItem storeItem) throws StoreItemValidationException {
        LOG.info("validateStoreItem storeItem=...");
        if (StringUtil.isNullOrEmpty(storeItem.getId())) {
            throw new StoreItemValidationException("id");
        }
        if (storeItem.getValue() == null) {
            throw new StoreItemValidationException("value");
        }
        if (storeItem.getReadRestriction() == null || !storeItem.getReadRestriction().isValid()) {
            throw new StoreItemValidationException("readRestriction");
        }
        if (storeItem.getWriteRestriction() == null || !storeItem.getWriteRestriction().isValid()) {
            throw new StoreItemValidationException("writeRestriction");
        }
    }

    private class DefaultStorageServiceIndicesBackupSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private DefaultStorageServiceIndicesBackupSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting setting=...");
            StorageServiceImpl.this.defaultStorageServiceIndicesBackupSetting = setting;
        }
    }

    private class IndexDeletedEventHandler
    extends AbstractEventHandler {
        private IndexDeletedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("IndexDeleted");
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Map msg = (Map)event.getProperty("IndexDeleted");
            String aliasOfDeletedIndex = (String)msg.get("alias");
            if (aliasOfDeletedIndex.startsWith(StorageServiceImpl.INDEX_PREFIX)) {
                try {
                    StorageServiceImpl.this.backupManagerTracker.getService().deleteBackupJob(StorageServiceImpl.BACKUP_JOB_PREFIX + aliasOfDeletedIndex);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to process the index deleted event: " + event, ex);
                }
            }
        }
    }
}

