/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.storage;

import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.core.storage.StoreItemRestrictionFactory;
import de.virtimo.bpc.util.MapUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class StoreItemFactory {
    private static final Logger LOG = Logger.getLogger(StoreItemFactory.class.getName());
    static final String FIELD_ID = "id";
    static final String FIELD_MODULE_ID = "moduleId";
    static final String FIELD_MODULE_INSTANCE_ID = "moduleInstanceId";
    static final String FIELD_NAME = "name";
    static final String FIELD_VALUE = "value";
    static final String FIELD_FAVORITE = "favorite";
    static final String FIELD_READ_RESTRICTION = "readRestriction";
    static final String FIELD_WRITE_RESTRICTION = "writeRestriction";
    static final String FIELD_CUSTOM_FIELDS = "customFields";

    public static StoreItem create(String id, Map<String, Object> esSource) {
        return StoreItem.withId(id).withModuleId(MapUtil.getValueAsString(esSource, FIELD_MODULE_ID, null)).withModuleInstanceId(MapUtil.getValueAsString(esSource, FIELD_MODULE_INSTANCE_ID, null)).withName(MapUtil.getValueAsString(esSource, FIELD_NAME, null)).withValue(MapUtil.getValueAsObject(esSource, FIELD_VALUE, null)).withFavorite(MapUtil.getValueAsBoolean(esSource, FIELD_FAVORITE, false)).withReadRestriction(StoreItemRestrictionFactory.create(MapUtil.getValueAsMap(esSource, FIELD_READ_RESTRICTION, null))).withWriteRestriction(StoreItemRestrictionFactory.create(MapUtil.getValueAsMap(esSource, FIELD_WRITE_RESTRICTION, null))).withCustomFields(StoreItemFactory.extractAndMergeCustomFields(esSource)).build();
    }

    private static Map<String, Object> extractAndMergeCustomFields(Map<String, Object> esSource) {
        HashMap oldCustomFields = new HashMap();
        if (esSource.containsKey(FIELD_CUSTOM_FIELDS)) {
            oldCustomFields.putAll(MapUtil.getValueAsMap(esSource, FIELD_CUSTOM_FIELDS, Map.of()));
        }
        HashMap<String, Object> newCustomFields = new HashMap<String, Object>(esSource);
        newCustomFields.remove(FIELD_ID);
        newCustomFields.remove(FIELD_MODULE_ID);
        newCustomFields.remove(FIELD_MODULE_INSTANCE_ID);
        newCustomFields.remove(FIELD_NAME);
        newCustomFields.remove(FIELD_VALUE);
        newCustomFields.remove(FIELD_FAVORITE);
        newCustomFields.remove(FIELD_READ_RESTRICTION);
        newCustomFields.remove(FIELD_WRITE_RESTRICTION);
        newCustomFields.remove(FIELD_CUSTOM_FIELDS);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(oldCustomFields);
        result.putAll(newCustomFields);
        return result;
    }
}

