/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.storage.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.StorageService;
import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.api.storage.StoreItems;
import de.virtimo.bpc.core.storage.StoreItemFactory;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.util.TimeZoneUtil;
import de.virtimo.bpc.util.UUIDGenerator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="storage")
public class StorageEndpoints {
    private static final Logger LOG = Logger.getLogger(StorageEndpoints.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<StorageService> storageServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public StorageEndpoints(BundleContext bundleContext) {
        LOG.info("StorageEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.storageServiceTracker = new BpcServicesTracker<StorageService>(this.bundleContext, StorageService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/store/{storeId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getItems(@PathParam(value="storeId") String storeId, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit, @QueryParam(value="query") String query, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getItems storeId=" + storeId + ", timezoneOffset=" + timezoneOffset + ", timezoneName=" + timezoneName + ", start=" + start + ", limit=" + limit + ", query=" + query + ", filter=" + filter + ", sort=" + sort);
        try {
            String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
            StoreItems storeItems = this.storageServiceTracker.getService().getItems(storeId, start, limit, query, filter, sort, timeZoneId, userSession);
            return Response.ok((Object)storeItems, (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "get store items failed", e);
            return ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/store/{storeId}/{itemId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getItem(@PathParam(value="storeId") String storeId, @PathParam(value="itemId") String itemId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getItem storeId=" + storeId + ", itemId=" + itemId);
        try {
            StoreItem storeItem = this.storageServiceTracker.getService().getItem(storeId, itemId, userSession);
            return Response.ok((Object)storeItem, (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "get store item failed", e);
            return ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/store/{storeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response createItem(@PathParam(value="storeId") String storeId, Map<String, Object> jsonObject, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("createItem storeId=" + storeId);
        try {
            String itemId = UUIDGenerator.randomUUID();
            StoreItem storeItem = StoreItemFactory.create(itemId, jsonObject);
            this.storageServiceTracker.getService().createItem(storeId, storeItem, userSession);
            return Response.ok((Object)itemId).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Creating store item failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @PUT
    @Path(value="/store/{storeId}/{itemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response updateOrCreateItem(@PathParam(value="storeId") String storeId, @PathParam(value="itemId") String itemId, Map<String, Object> jsonObject, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("updateOrCreateItem storeId=" + storeId + ", itemId=" + itemId);
        try {
            StoreItem storeItem = StoreItemFactory.create(itemId, jsonObject);
            this.storageServiceTracker.getService().updateOrCreateItem(storeId, storeItem, userSession);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "updating or creating store item failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/store/{storeId}/{itemId}")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response deleteItem(@PathParam(value="storeId") String storeId, @PathParam(value="itemId") String itemId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteItem storeId=" + storeId + ", itemId=" + itemId);
        try {
            this.storageServiceTracker.getService().deleteItem(storeId, itemId, userSession);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "delete store item failed", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

