/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.apikey.APIKeyException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;

@WebSocket
public class BpcWebsocket {
    private static final Logger LOG = Logger.getLogger(BpcWebsocket.class.getName());
    public static final String CLIENT_EVENT_DOMAIN = "de/virtimo/bpc/client/";
    private final ClientSessionManager clientSessionManager;
    private final EventManager eventManager;
    private final IpPinningService ipPinningService;

    public BpcWebsocket(ClientSessionManager clientSessionManager, EventManager eventManager, IpPinningService ipPinningService) {
        LOG.info("BpcWebsocket clientSessionManager=..., eventManager=..., ipPinningService=...");
        this.clientSessionManager = clientSessionManager;
        this.eventManager = eventManager;
        this.ipPinningService = ipPinningService;
    }

    private boolean allowedToOpen(Session websocketSession) {
        try {
            HttpCookie sessionCookie = this.getSessionCookie(websocketSession);
            if (sessionCookie == null) {
                return false;
            }
            String sessionId = sessionCookie.getValue();
            if (!this.clientSessionManager.existsSession(sessionId)) {
                return false;
            }
            HttpServletRequest httpServletRequest = this.getHttpServletRequest(websocketSession);
            if (httpServletRequest == null) {
                LOG.log(Level.SEVERE, "Skipping the IP pinning check. Was not able to get the http servlet request from the websocket session. Please inform the BPC developers that there is something broken, maybe due to a Karaf update. Thanks!");
                return true;
            }
            UserSession userSession = this.clientSessionManager.getUserSession(httpServletRequest);
            return this.ipPinningService.isValidRequest(httpServletRequest, userSession);
        }
        catch (APIKeyException ex) {
            LOG.log(Level.SEVERE, "Failed to get the API key related user session.", ex);
            return false;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to check if it is allowed to open a websocket connection.", ex);
            return false;
        }
    }

    @OnWebSocketConnect
    public void onOpen(Session session) {
        LOG.info("onOpen session=" + session);
        if (this.allowedToOpen(session)) {
            HttpCookie sessionCookie = this.getSessionCookie(session);
            this.clientSessionManager.addSession(sessionCookie.getValue(), session);
        } else {
            session.close(1008, "No valid session found");
        }
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        LOG.info("onClose session=" + session);
        HttpCookie sessionCookie = this.getSessionCookie(session);
        if (sessionCookie != null) {
            this.clientSessionManager.removeSession(sessionCookie.getValue(), session);
        }
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable cause) {
        LOG.log(Level.INFO, "onError (can be correct when the websocket connection timed out)", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onText(Session session, String message) {
        LOG.info("onText: " + message);
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Map eventData = (Map)mapper.readValue(message, Map.class);
            if (this.isPingEventFromFrontend(eventData)) {
                LOG.info("Ignoring the websocket 'ping' event from frontend. Gets not broad casted to other frontends and not to other active/active servers.");
                return;
            }
            if (eventData.containsKey("event")) {
                this.eventManager.fireEvent(CLIENT_EVENT_DOMAIN + eventData.get("event"), DictionaryUtil.dictionaryOf("data", eventData.get("data")));
                this.eventManager.broadcast().clientEvent(eventData);
            }
        }
        catch (ServiceNotFoundException e) {
            LOG.log(Level.SEVERE, "Failed to broadcast the received message due to missing service.", e);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to parse the JSON message.", e);
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    private HttpCookie getSessionCookie(Session session) {
        for (HttpCookie cookie : session.getUpgradeRequest().getCookies()) {
            if (!cookie.getName().equals("BPC_J_S")) continue;
            return cookie;
        }
        return null;
    }

    private HttpServletRequest getHttpServletRequest(Session session) {
        UpgradeRequest upgradeRequest = session.getUpgradeRequest();
        if (upgradeRequest instanceof ServletUpgradeRequest) {
            ServletUpgradeRequest servletUpgradeRequest = (ServletUpgradeRequest)upgradeRequest;
            return servletUpgradeRequest.getHttpServletRequest();
        }
        return null;
    }

    private boolean isPingEventFromFrontend(Map<String, Object> eventData) {
        Object eventNameObject;
        LOG.info("isPingEventFromFrontend eventData=" + eventData);
        if (eventData != null && eventData.containsKey("event") && (eventNameObject = eventData.get("event")) instanceof String) {
            String eventName = (String)eventNameObject;
            return "ping".equalsIgnoreCase(eventName);
        }
        return false;
    }
}

