/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.doclet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.util.DocTrees;
import de.virtimo.bpc.doclet.ApiInfo;
import de.virtimo.bpc.doclet.AsciiDocGenerator;
import de.virtimo.bpc.doclet.EndpointInfo;
import de.virtimo.bpc.doclet.OSGiBlueprintExtractor;
import de.virtimo.bpc.doclet.ParamInfo;
import de.virtimo.bpc.doclet.annotations.AsciiDocFilename;
import de.virtimo.bpc.doclet.annotations.AsciiDocTitle;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRightRequired;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcRoleRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

public class BlueprintEndpointsToAsciiDocDoclet
implements Doclet {
    private Reporter log;
    private String osgiBlueprintFile;
    private File destDir;

    @Override
    public void init(Locale locale, Reporter log) {
        log.print(Diagnostic.Kind.NOTE, "Doclet using locale: " + locale);
        this.log = log;
    }

    @Override
    public String getName() {
        return "OSGi Blueprint endpoints to AsciiDoc";
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        Doclet.Option[] options = new Doclet.Option[]{new Doclet.Option(){

            @Override
            public List<String> getNames() {
                return Arrays.asList("-osgiblueprintfile", "--osgi-blueprint-file");
            }

            @Override
            public String getDescription() {
                return "Path to the OSGI blueprint xml file";
            }

            @Override
            public int getArgumentCount() {
                return 1;
            }

            @Override
            public Doclet.Option.Kind getKind() {
                return Doclet.Option.Kind.STANDARD;
            }

            @Override
            public String getParameters() {
                return "filepath";
            }

            @Override
            public boolean process(String opt, List<String> arguments) {
                BlueprintEndpointsToAsciiDocDoclet.this.osgiBlueprintFile = arguments.get(0);
                return true;
            }
        }, new Doclet.Option(){

            @Override
            public List<String> getNames() {
                return Arrays.asList("-destdir", "--dest-dir");
            }

            @Override
            public String getDescription() {
                return "Path to the destination directory";
            }

            @Override
            public int getArgumentCount() {
                return 1;
            }

            @Override
            public Doclet.Option.Kind getKind() {
                return Doclet.Option.Kind.STANDARD;
            }

            @Override
            public String getParameters() {
                return "directory";
            }

            @Override
            public boolean process(String option, List<String> arguments) {
                BlueprintEndpointsToAsciiDocDoclet.this.destDir = new File(arguments.get(0));
                return true;
            }
        }};
        return new HashSet<Doclet.Option>(Arrays.asList(options));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_11;
    }

    @Override
    public boolean run(DocletEnvironment docEnv) {
        if (this.osgiBlueprintFile == null) {
            this.log.print(Diagnostic.Kind.ERROR, "Path to OSGi blueprint file not set");
            return false;
        }
        this.log.print(Diagnostic.Kind.NOTE, "osgi-blueprint-file: " + this.osgiBlueprintFile);
        if (this.destDir == null) {
            this.log.print(Diagnostic.Kind.ERROR, "Destination directory not set");
            return false;
        }
        this.log.print(Diagnostic.Kind.NOTE, "Using destination dir: " + this.destDir);
        OSGiBlueprintExtractor osgiBlueprintExtractor = new OSGiBlueprintExtractor(new File(this.osgiBlueprintFile));
        Map<String, String> registeredOSGiBlueprintAPIs = osgiBlueprintExtractor.getAPIs();
        for (String osgiBlueprintApiClass : registeredOSGiBlueprintAPIs.keySet()) {
            this.log.print(Diagnostic.Kind.NOTE, "Found OSGi blueprint API: " + osgiBlueprintApiClass + " = " + registeredOSGiBlueprintAPIs.get(osgiBlueprintApiClass));
        }
        List<ApiInfo> apiInfos = this.getApiInfos(docEnv, registeredOSGiBlueprintAPIs);
        for (ApiInfo apiInfo : apiInfos) {
            this.writeApiInfoToFile(apiInfo);
        }
        this.writeApisOverviewFile(apiInfos);
        return true;
    }

    private List<ApiInfo> getApiInfos(DocletEnvironment docEnv, Map<String, String> registeredOSGiBlueprintEndpoints) {
        ArrayList<ApiInfo> apiInfos = new ArrayList<ApiInfo>();
        DocTrees docTrees = docEnv.getDocTrees();
        for (TypeElement t : ElementFilter.typesIn(docEnv.getIncludedElements())) {
            String className;
            if (!t.getKind().isClass() || !registeredOSGiBlueprintEndpoints.containsKey(className = t.getQualifiedName().toString())) continue;
            this.log.print(Diagnostic.Kind.NOTE, "Creating AsciiDoc for " + t.getKind() + ":" + className);
            String jaxrsServerAddress = registeredOSGiBlueprintEndpoints.get(className);
            ApiInfo apiInfo = this.getApiInfo(docTrees, className, "/cxf", jaxrsServerAddress, t);
            if (apiInfo == null) continue;
            apiInfos.add(apiInfo);
        }
        return apiInfos;
    }

    public ApiInfo getApiInfo(DocTrees docTrees, String className, String pathPrefix, String jaxrsServerAddress, TypeElement classTypeElement) {
        AsciiDocFilename asciiDocFilename;
        ApiInfo apiInfo = new ApiInfo(className);
        AsciiDocTitle asciiDocTitleAnnotation = classTypeElement.getAnnotation(AsciiDocTitle.class);
        if (asciiDocTitleAnnotation != null) {
            apiInfo.setTitle(asciiDocTitleAnnotation.value());
        }
        if ((asciiDocFilename = classTypeElement.getAnnotation(AsciiDocFilename.class)) != null) {
            apiInfo.setFileName(asciiDocFilename.value());
        }
        apiInfo.setDescription(this.getClassComment(docTrees, classTypeElement));
        String pathAnnotationValueOfJavaClass = this.getPathAnnotationValue(classTypeElement);
        for (Element element : classTypeElement.getEnclosedElements()) {
            BpcRoleOrRightRequired bpcRoleOrRightAnnotation;
            BpcRightRequired bpcRightRequiredAnnotation;
            BpcRoleRequired bpcRoleRequired;
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement methodElement = (ExecutableElement)element;
            String httpMethod = this.getHttpMethod(element);
            if (httpMethod == null) continue;
            EndpointInfo endpointInfo = new EndpointInfo();
            endpointInfo.setJavaMethodSignature(this.getJavaMethodSignature(methodElement));
            endpointInfo.setHasBpcAnnotations(this.hasBpcAnnotation(methodElement));
            endpointInfo.setHttpMethod(httpMethod);
            String pathAnnotationValueOfJavaMethod = this.getPathAnnotationValue(element);
            String fullEndpointPath = StringUtil.glue(StringUtil.glue(pathPrefix, jaxrsServerAddress, '/'), StringUtil.glue(pathAnnotationValueOfJavaClass, pathAnnotationValueOfJavaMethod, '/'), '/');
            this.log.print(Diagnostic.Kind.NOTE, httpMethod + " ".repeat(8 - httpMethod.length()) + fullEndpointPath);
            endpointInfo.setEndpointPath(fullEndpointPath);
            endpointInfo.setConsumes(this.getConsumesAnnotationValue(element));
            endpointInfo.setProduces(this.getProducesAnnotationValue(element));
            DocCommentTree methodElementDocCommentTree = docTrees.getDocCommentTree(element);
            if (methodElementDocCommentTree != null) {
                endpointInfo.setDescription(methodElementDocCommentTree.getFullBody().toString());
            }
            List<? extends VariableElement> methodParameters = methodElement.getParameters();
            for (VariableElement variableElement : methodParameters) {
                FormParam formParamAnnotation;
                QueryParam queryParamAnnotation;
                PathParam pathParamAnnotation = variableElement.getAnnotation(PathParam.class);
                if (pathParamAnnotation != null) {
                    String pathParamName = pathParamAnnotation.value();
                    String pathParamDescription = this.getMethodParameterComment(docTrees, methodElement, variableElement);
                    String pathParamDefaultValue = this.getMethodParameterDefaultValue(variableElement);
                    endpointInfo.addPathParam(new ParamInfo(pathParamName, pathParamDescription, pathParamDefaultValue));
                }
                if ((queryParamAnnotation = variableElement.getAnnotation(QueryParam.class)) != null) {
                    String queryParamName = queryParamAnnotation.value();
                    String queryParamDescription = this.getMethodParameterComment(docTrees, methodElement, variableElement);
                    String queryParamDefaultValue = this.getMethodParameterDefaultValue(variableElement);
                    endpointInfo.addQueryParam(new ParamInfo(queryParamName, queryParamDescription, queryParamDefaultValue));
                }
                if ((formParamAnnotation = variableElement.getAnnotation(FormParam.class)) == null) continue;
                String formParamName = formParamAnnotation.value();
                String formParamDescription = this.getMethodParameterComment(docTrees, methodElement, variableElement);
                String formParamDefaultValue = this.getMethodParameterDefaultValue(variableElement);
                endpointInfo.addFormParam(new ParamInfo(formParamName, formParamDescription, formParamDefaultValue));
            }
            BpcUserSessionRequired bpcUserSessionRequired = element.getAnnotation(BpcUserSessionRequired.class);
            if (bpcUserSessionRequired != null) {
                endpointInfo.setRequiresUserSession(true);
            }
            if ((bpcRoleRequired = element.getAnnotation(BpcRoleRequired.class)) != null) {
                endpointInfo.setRequiredRole(bpcRoleRequired.role());
            }
            if ((bpcRightRequiredAnnotation = element.getAnnotation(BpcRightRequired.class)) != null) {
                endpointInfo.setRequiredRight(bpcRightRequiredAnnotation.right());
            }
            if ((bpcRoleOrRightAnnotation = element.getAnnotation(BpcRoleOrRightRequired.class)) != null) {
                endpointInfo.setRequiredRole(bpcRoleOrRightAnnotation.role());
                endpointInfo.setRequiredRight(bpcRoleOrRightAnnotation.right());
            }
            endpointInfo.setReturns(this.getMethodReturnComment(docTrees, methodElement));
            apiInfo.addEndpointInfo(endpointInfo);
        }
        return apiInfo;
    }

    private boolean hasBpcAnnotation(ExecutableElement methodElement) {
        Set<Class> bpcAnnotationClasses = SetUtil.setOf(BpcEndpoint.class, BpcUserSessionRequired.class, BpcRoleRequired.class, BpcRightRequired.class, BpcRoleOrRightRequired.class);
        for (Class bpcAnnotationClass : bpcAnnotationClasses) {
            if (methodElement.getAnnotation(bpcAnnotationClass) == null) continue;
            return true;
        }
        return false;
    }

    private String getJavaMethodSignature(ExecutableElement methodElement) {
        ArrayList<String> methodParamTypes = new ArrayList<String>();
        List<? extends VariableElement> methodParameters = methodElement.getParameters();
        for (VariableElement variableElement : methodParameters) {
            methodParamTypes.add(variableElement.asType().toString());
        }
        return methodElement.getSimpleName().toString() + "(" + StringUtil.implode(", ", methodParamTypes) + ")";
    }

    private String getMethodParameterDefaultValue(VariableElement methodParameter) {
        DefaultValue defaultValueAnnotation;
        if (methodParameter != null && (defaultValueAnnotation = methodParameter.getAnnotation(DefaultValue.class)) != null) {
            return defaultValueAnnotation.value();
        }
        return null;
    }

    private String getClassComment(DocTrees docTrees, TypeElement typeElement) {
        DocCommentTree commentTree = docTrees.getDocCommentTree(typeElement);
        if (commentTree != null) {
            return commentTree.getFullBody().toString();
        }
        return "";
    }

    private String getMethodParameterComment(DocTrees docTrees, ExecutableElement methodElement, VariableElement methodParameter) {
        DocCommentTree commentTree = docTrees.getDocCommentTree(methodElement);
        if (commentTree != null) {
            for (DocTree docTree : commentTree.getBlockTags()) {
                ParamTree paramTree;
                if (!docTree.getKind().equals((Object)DocTree.Kind.PARAM) || !(paramTree = (ParamTree)docTree).getName().getName().equals(methodParameter.getSimpleName())) continue;
                return paramTree.getDescription().toString();
            }
        }
        return "";
    }

    private String getMethodReturnComment(DocTrees docTrees, ExecutableElement methodElement) {
        DocCommentTree commentTree = docTrees.getDocCommentTree(methodElement);
        if (commentTree != null) {
            for (DocTree docTree : commentTree.getBlockTags()) {
                if (!docTree.getKind().equals((Object)DocTree.Kind.RETURN)) continue;
                return ((ReturnTree)docTree).getDescription().toString();
            }
        }
        return "";
    }

    private String[] getConsumesAnnotationValue(Element e) {
        Consumes annotation = e.getAnnotation(Consumes.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    private String[] getProducesAnnotationValue(Element e) {
        Produces annotation = e.getAnnotation(Produces.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    private String getPathAnnotationValue(Element e) {
        Path annotation = e.getAnnotation(Path.class);
        if (annotation != null) {
            return annotation.value();
        }
        return "";
    }

    private String getHttpMethod(Element e) {
        GET getAnnotation = e.getAnnotation(GET.class);
        if (getAnnotation != null) {
            return "GET";
        }
        POST postAnnotation = e.getAnnotation(POST.class);
        if (postAnnotation != null) {
            return "POST";
        }
        PUT putAnnotation = e.getAnnotation(PUT.class);
        if (putAnnotation != null) {
            return "PUT";
        }
        DELETE deleteAnnotation = e.getAnnotation(DELETE.class);
        if (deleteAnnotation != null) {
            return "DELETE";
        }
        PATCH patchAnnotation = e.getAnnotation(PATCH.class);
        if (patchAnnotation != null) {
            return "PATCH";
        }
        return null;
    }

    private void writeApiInfoToFile(ApiInfo apiInfo) {
        File file = new File(this.destDir, apiInfo.getFileName());
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            writer.println(AsciiDocGenerator.generateApiFileContent(apiInfo));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeApisOverviewFile(List<ApiInfo> apiInfos) {
        File file = new File(this.destDir, "apis.adoc");
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            writer.println(AsciiDocGenerator.generateOverviewFileContent(apiInfos));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

