/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.doclet;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class OSGiBlueprintExtractor {
    private final File blueprintFile;

    public OSGiBlueprintExtractor(File blueprintFile) {
        this.blueprintFile = blueprintFile;
    }

    public Map<String, String> getAPIs() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder db = docBuilderFactory.newDocumentBuilder();
            Document doc = db.parse(this.blueprintFile);
            doc.getDocumentElement().normalize();
            String rootElementName = doc.getDocumentElement().getNodeName();
            if ("blueprint".equalsIgnoreCase(rootElementName)) {
                Map<String, String> beans = this.getAllBlueprintBeans(doc);
                NodeList serverList = doc.getElementsByTagNameNS("http://cxf.apache.org/blueprint/jaxrs", "server");
                for (int i = 0; i < serverList.getLength(); ++i) {
                    Element serverElement;
                    String serverAddress;
                    Node serverNode = serverList.item(i);
                    if (serverNode.getNodeType() != 1 || (serverAddress = (serverElement = (Element)serverNode).getAttribute("address")) == null) continue;
                    Map<String, String> serverAPIs = this.getAPIs(serverElement, serverAddress, beans);
                    result.putAll(serverAPIs);
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private Map<String, String> getAPIs(Element serverElement, String serverAddress, Map<String, String> beans) {
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList serverBeansList = serverElement.getElementsByTagNameNS("http://cxf.apache.org/blueprint/jaxrs", "serviceBeans");
        for (int i = 0; i < serverBeansList.getLength(); ++i) {
            Node serverBeansNode = serverBeansList.item(i);
            if (serverBeansNode.getNodeType() != 1) continue;
            Element serverBeansElement = (Element)serverBeansNode;
            NodeList refList = serverBeansElement.getElementsByTagName("ref");
            for (int j = 0; j < refList.getLength(); ++j) {
                Element refElement;
                String componentId;
                String componentClass;
                Node refNode = refList.item(j);
                if (refNode.getNodeType() != 1 || (componentClass = beans.get(componentId = (refElement = (Element)refNode).getAttribute("component-id"))) == null) continue;
                result.put(componentClass, serverAddress);
            }
        }
        return result;
    }

    private Map<String, String> getAllBlueprintBeans(Document doc) {
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList list = doc.getElementsByTagName("bean");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String idAttr = element.getAttribute("id");
            String classAttr = element.getAttribute("class");
            result.put(idAttr, classAttr);
        }
        return result;
    }
}

