/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.jaxrs;

import de.virtimo.bpc.util.StringUtil;
import java.net.PasswordAuthentication;
import java.util.Base64;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.message.Message;

public class BasicAuthCredentialsProvider
implements ContextProvider<PasswordAuthentication> {
    private static final Logger LOG = Logger.getLogger(BasicAuthCredentialsProvider.class.getName());

    public PasswordAuthentication createContext(Message message) {
        LOG.fine("createContext message=" + message);
        HttpHeadersImpl httpHeaders = new HttpHeadersImpl(message);
        return BasicAuthCredentialsProvider.getBasicAuthCredentials((HttpHeaders)httpHeaders);
    }

    public static PasswordAuthentication getBasicAuthCredentials(HttpHeaders httpHeaders) {
        LOG.fine("getBasicAuthCredentials");
        try {
            if (httpHeaders == null) {
                return null;
            }
            String authorizationHeader = httpHeaders.getHeaderString("Authorization");
            if (StringUtil.isNullOrEmpty(authorizationHeader)) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(authorizationHeader);
            if (!st.hasMoreTokens()) {
                return null;
            }
            String basicToken = st.nextToken();
            if (StringUtil.isNullOrEmpty(basicToken) || !basicToken.equalsIgnoreCase("Basic")) {
                return null;
            }
            String base64EncodedCredentialsToken = st.nextToken();
            if (StringUtil.isNullOrEmpty(base64EncodedCredentialsToken)) {
                return null;
            }
            String credentials = new String(Base64.getDecoder().decode(base64EncodedCredentialsToken));
            if (StringUtil.isNullOrEmpty(credentials)) {
                return null;
            }
            int colonIndex = credentials.indexOf(":");
            if (colonIndex == -1) {
                return null;
            }
            String username = credentials.substring(0, colonIndex).trim();
            String password = credentials.substring(colonIndex + 1).trim();
            return new PasswordAuthentication(username, password.toCharArray());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not get the basic auth credentials.", ex);
            return null;
        }
    }
}

