/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.jaxrs;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.jaxrs.BasicAuthCredentialsProvider;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcHardcodedBasicAuthentication;
import de.virtimo.bpc.jaxrs.BpcRightRequired;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcRoleRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.util.MapUtil;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.osgi.framework.BundleContext;

public class BpcJAXRSInvoker
extends JAXRSInvoker {
    private static final Logger LOG = Logger.getLogger(BpcJAXRSInvoker.class.getName());
    private BundleContext bundleContext = null;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<IpPinningService> ipPinningServiceTracker;
    private BpcServicesTracker<CsrfTokenService> csrfTokenServiceTracker;

    public BpcJAXRSInvoker(BundleContext bundleContext) {
        LOG.info("BpcJAXRSInvoker bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.ipPinningServiceTracker = new BpcServicesTracker<IpPinningService>(this.bundleContext, IpPinningService.class);
        this.csrfTokenServiceTracker = new BpcServicesTracker<CsrfTokenService>(this.bundleContext, CsrfTokenService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll((Object)this);
    }

    public Object invoke(Exchange exchange, Object requestParams, Object resourceObject) {
        UserSession userSession;
        String errorMessage;
        UserSession userSession2;
        HttpHeaders httpHeaders;
        LOG.info("invoke exchange=" + exchange + ", requestParams=..., resourceObject=" + resourceObject);
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        Method method = ori.getMethodToInvoke();
        boolean csrfTokenOk = false;
        boolean ipPinningOk = false;
        if (method.isAnnotationPresent(BpcEndpoint.class)) {
            httpHeaders = null;
            try {
                BpcEndpoint bpcEndpointAnnotation = method.getAnnotation(BpcEndpoint.class);
                boolean skipIpPinningCheck = bpcEndpointAnnotation.skipIpPinningCheck();
                httpHeaders = this.getHttpHeaders(exchange);
                if (httpHeaders != null && (userSession2 = this.clientSessionManagerTracker.getService().getUserSession(httpHeaders)) != null) {
                    ipPinningOk = !skipIpPinningCheck ? this.checkIpPinning(exchange, userSession2) : true;
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "BPC endpoint check failed.", ex);
                return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).build()});
            }
        }
        if (method.isAnnotationPresent(BpcUserSessionRequired.class)) {
            httpHeaders = null;
            try {
                BpcUserSessionRequired userSessionRequiredAnnotation = method.getAnnotation(BpcUserSessionRequired.class);
                String skipCsrfCheck = userSessionRequiredAnnotation.skipCsrfCheck();
                httpHeaders = this.getHttpHeaders(exchange);
                if (httpHeaders == null) {
                    throw new SystemException((ErrorCode)CoreErrorCode.UNEXPECTED, "Could not get the HttpHeaders to do the user session check.");
                }
                userSession2 = this.clientSessionManagerTracker.getService().getUserSession(httpHeaders);
                if (userSession2 == null) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Client session missing.");
                }
                csrfTokenOk = skipCsrfCheck.equalsIgnoreCase("false") ? this.checkCsrfToken(exchange, userSession2) : true;
                if (!ipPinningOk) {
                    ipPinningOk = this.checkIpPinning(exchange, userSession2);
                }
            }
            catch (Exception ex) {
                if (ex instanceof SystemException && ((SystemException)ex).isErrorCode(CoreErrorCode.AUTHENTICATION_UNAUTHORIZED)) {
                    LOG.warning("BPC user session check failed: " + ex.getLocalizedMessage());
                } else {
                    LOG.log(Level.SEVERE, "BPC user session check failed.", ex);
                }
                return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).build()});
            }
        }
        if (method.isAnnotationPresent(BpcRoleRequired.class)) {
            httpHeaders = null;
            try {
                BpcRoleRequired roleRequiredAnnotation = method.getAnnotation(BpcRoleRequired.class);
                String requiredRole = roleRequiredAnnotation.role();
                errorMessage = roleRequiredAnnotation.message();
                httpHeaders = this.getHttpHeaders(exchange);
                if (httpHeaders == null) {
                    throw new SystemException((ErrorCode)CoreErrorCode.UNEXPECTED, "Could not get the HttpHeaders to do the user role check.");
                }
                userSession = this.clientSessionManagerTracker.getService().getUserSession(httpHeaders);
                if (userSession == null) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Client session missing.");
                }
                if (!userSession.hasRole(requiredRole)) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_ROLE_CHECK_FAILED, errorMessage, MapUtil.mapOf("requiredRole", requiredRole));
                }
                if (!csrfTokenOk) {
                    csrfTokenOk = this.checkCsrfToken(exchange, userSession);
                }
                if (!ipPinningOk) {
                    ipPinningOk = this.checkIpPinning(exchange, userSession);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "BPC role check failed.", ex);
                return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).build()});
            }
        }
        if (method.isAnnotationPresent(BpcRightRequired.class)) {
            httpHeaders = null;
            try {
                BpcRightRequired rightRequiredAnnotation = method.getAnnotation(BpcRightRequired.class);
                String requiredRight = rightRequiredAnnotation.right();
                errorMessage = rightRequiredAnnotation.message();
                httpHeaders = this.getHttpHeaders(exchange);
                if (httpHeaders == null) {
                    throw new SystemException((ErrorCode)CoreErrorCode.UNEXPECTED, "Could not get the HttpHeaders to do the user right check.");
                }
                userSession = this.clientSessionManagerTracker.getService().getUserSession(httpHeaders);
                if (userSession == null) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Client session missing.");
                }
                if (!userSession.hasRight(requiredRight)) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_RIGHT_CHECK_FAILED, errorMessage, MapUtil.mapOf("requiredRight", requiredRight));
                }
                if (!csrfTokenOk) {
                    csrfTokenOk = this.checkCsrfToken(exchange, userSession);
                }
                if (!ipPinningOk) {
                    ipPinningOk = this.checkIpPinning(exchange, userSession);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "BPC right check failed.", ex);
                return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).build()});
            }
        }
        if (method.isAnnotationPresent(BpcRoleOrRightRequired.class)) {
            httpHeaders = null;
            try {
                BpcRoleOrRightRequired roleOrRightRequiredAnnotation = method.getAnnotation(BpcRoleOrRightRequired.class);
                String requiredRight = roleOrRightRequiredAnnotation.right();
                String requiredRole = roleOrRightRequiredAnnotation.role();
                String errorMessage2 = roleOrRightRequiredAnnotation.message();
                httpHeaders = this.getHttpHeaders(exchange);
                if (httpHeaders == null) {
                    throw new SystemException((ErrorCode)CoreErrorCode.UNEXPECTED, "Could not get the HttpHeaders to do the user role or right check.");
                }
                UserSession userSession3 = this.clientSessionManagerTracker.getService().getUserSession(httpHeaders);
                if (userSession3 == null) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "User session missing.");
                }
                if (!userSession3.hasRight(requiredRight) && !userSession3.hasRole(requiredRole)) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_RIGHT_CHECK_FAILED, errorMessage2, MapUtil.mapOf("requiredRight", requiredRight, "requiredRole", requiredRole));
                }
                if (!csrfTokenOk) {
                    csrfTokenOk = this.checkCsrfToken(exchange, userSession3);
                }
                if (!ipPinningOk) {
                    ipPinningOk = this.checkIpPinning(exchange, userSession3);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "BPC role or right check failed.", ex);
                return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).build()});
            }
        }
        if (method.isAnnotationPresent(BpcHardcodedBasicAuthentication.class)) {
            httpHeaders = null;
            try {
                BpcHardcodedBasicAuthentication hardcodedBasicAuthenticationAnnotation = method.getAnnotation(BpcHardcodedBasicAuthentication.class);
                String hardcodedUsername = hardcodedBasicAuthenticationAnnotation.username();
                String hardcodedPassword = hardcodedBasicAuthenticationAnnotation.password();
                httpHeaders = this.getHttpHeaders(exchange);
                PasswordAuthentication basicAuthCredentials = BasicAuthCredentialsProvider.getBasicAuthCredentials(httpHeaders);
                if (basicAuthCredentials == null || !hardcodedUsername.equals(basicAuthCredentials.getUserName()) || !hardcodedPassword.equals(new String(basicAuthCredentials.getPassword()))) {
                    throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Client session missing.");
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Basic auth check failed.", ex);
                return new MessageContentsList(new Object[]{ErrorResponse.forException(ex).languageFrom(httpHeaders).build()});
            }
        }
        return super.invoke(exchange, requestParams, resourceObject);
    }

    private boolean checkCsrfToken(Exchange exchange, UserSession userSession) throws SystemException {
        HttpServletRequest relatedServletRequest = this.getHttpServletRequest(exchange);
        if (relatedServletRequest == null) {
            LOG.log(Level.SEVERE, "Skipping the CSRF token check due to a missing http servlet request. Please inform the BPC developers. There must be a change due to a Karaf update.");
            return true;
        }
        if (!this.csrfTokenServiceTracker.getService().isValidRequest(relatedServletRequest, userSession)) {
            throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CSRF token failure");
        }
        return true;
    }

    private boolean checkIpPinning(Exchange exchange, UserSession userSession) throws SystemException {
        HttpServletRequest relatedServletRequest = this.getHttpServletRequest(exchange);
        if (relatedServletRequest == null) {
            LOG.log(Level.SEVERE, "Skipping the IP pinning check due to a missing http servlet request. Please inform the BPC developers. There must be a change due to a Karaf update.");
            return true;
        }
        if (!this.ipPinningServiceTracker.getService().isValidRequest(relatedServletRequest, userSession)) {
            throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "IP pinning failure");
        }
        return true;
    }

    private HttpHeaders getHttpHeaders(Exchange exchange) {
        LOG.info("getHttpHeaders exchange=" + exchange);
        Message inMessage = exchange.getInMessage();
        if (inMessage != null) {
            return new HttpHeadersImpl(inMessage);
        }
        return null;
    }

    private HttpServletRequest getHttpServletRequest(Exchange exchange) {
        LOG.info("getHttpServletRequest exchange=" + exchange);
        Message inMessage = exchange.getInMessage();
        if (inMessage != null) {
            return (HttpServletRequest)inMessage.get((Object)"HTTP.REQUEST");
        }
        return null;
    }
}

