/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.JsonSchemaSettingValidator;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;

public class LogServiceModuleInstanceSettingsValidator
extends JsonSchemaSettingValidator {
    private static final Logger LOG = Logger.getLogger(LogServiceModuleInstanceSettingsValidator.class.getName());
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;

    public LogServiceModuleInstanceSettingsValidator(BundleContext bundleContext) {
        super(bundleContext);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "logservice".equalsIgnoreCase(moduleId) && !ModuleConfiguration.isNoModuleInstanceId(moduleInstanceId);
    }

    @Override
    public boolean canValidate(Setting setting) {
        List<String> settingsToValidate = Arrays.asList("keys", "fields");
        return settingsToValidate.contains(setting.getName());
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOG.info("validate setting:" + setting);
        if ("keys".equalsIgnoreCase(setting.getName())) {
            this.validateJsonSchemaOfSetting(setting);
        }
        if ("fields".equalsIgnoreCase(setting.getName())) {
            this.validateJsonSchemaOfSetting(setting);
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        Setting rdmsLogginEnabledSetting;
        LOG.info("validate moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", settings:...");
        Setting esLoggingEnabledSetting = settings.get("openSearchLoggingEnabled");
        if (esLoggingEnabledSetting != null && ((Boolean)esLoggingEnabledSetting.getValue()).booleanValue()) {
            Setting esSetting = settings.get("openSearch");
            this.validateJsonSchemaOfSetting(esSetting);
        }
        if ((rdmsLogginEnabledSetting = settings.get("rdmsLoggingEnabled")) != null && ((Boolean)rdmsLogginEnabledSetting.getValue()).booleanValue()) {
            Setting rdmsSetting = settings.get("rdms");
            this.validateJsonSchemaOfSetting(rdmsSetting);
            if (rdmsSetting != null) {
                LogServiceModuleInstance.RdmsConfig rdms = JsonUtil.getInstance().convertJavaContainerToPojo(rdmsSetting.getValue(), LogServiceModuleInstance.RdmsConfig.class);
                try {
                    DatabaseManager databaseManager = this.databaseManagerTracker.getService();
                    Configuration dataSourceConfiguration = databaseManager.getDataSourceConfiguration(rdms.rdmsDataSourceName);
                    if (dataSourceConfiguration == null) {
                        throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "${field}: The data source '${subFieldValue}' does not exist", MapUtil.mapOf("field", "rdms", "subField", "rdmsDataSourceName", "subFieldValue", rdms.rdmsDataSourceName));
                    }
                }
                catch (ServiceNotFoundException ex) {
                    throw new ValidationException(ex.getErrorCode(), ex.getMessage(), ex);
                }
                catch (Exception ex) {
                    throw new ValidationException((ErrorCode)CoreErrorCode.UNEXPECTED, "${field}: Could not get the data source configuration of '${subFieldValue}'", MapUtil.mapOf("field", "rdms", "subField", "rdmsDataSourceName", "subFieldValue", rdms.rdmsDataSourceName), (Throwable)ex);
                }
            }
        }
        return null;
    }
}

