/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.db;

import de.virtimo.bpc.logservice.db.PreparedStatementData;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class PreparedStatementBuilder {
    private static final Logger LOG = Logger.getLogger(PreparedStatementBuilder.class.getName());

    public PreparedStatementData createInsertStatement(String tableName, Map<String, Object> columnData) {
        LOG.fine("createInsertStatement tableName=" + tableName + ", columnData=...");
        LinkedHashMap<String, Object> orderedColumnData = new LinkedHashMap<String, Object>();
        StringBuilder columns = new StringBuilder();
        StringBuilder placeholders = new StringBuilder();
        int columnsIdx = 0;
        int columnsCnt = columnData.size();
        for (String column : columnData.keySet()) {
            orderedColumnData.put(column, columnData.get(column));
            columns.append(column);
            placeholders.append("?");
            if (++columnsIdx >= columnsCnt) continue;
            columns.append(", ");
            placeholders.append(", ");
        }
        return new PreparedStatementData("INSERT INTO " + tableName + " (" + columns + ") VALUES (" + placeholders + ")", orderedColumnData);
    }

    public PreparedStatementData createUpdateStatement(String tableName, Map<String, Object> columnData, List<String> keys) {
        LOG.fine("createUpdateStatement tableName=" + tableName + ", columnData=..., keys=" + keys);
        LinkedHashMap<String, Object> orderedColumnData = new LinkedHashMap<String, Object>();
        HashSet<String> lowerCaseKeys = new HashSet<String>();
        for (String key : keys) {
            lowerCaseKeys.add(key.toLowerCase());
        }
        TreeMap<String, Object> columnDataWithCaseInsensitiveKeys = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        columnDataWithCaseInsensitiveKeys.putAll(columnData);
        StringBuilder sql = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        int columnsIdx = 0;
        int columnsCnt = columnData.size() - lowerCaseKeys.size();
        for (String column : columnData.keySet()) {
            if (lowerCaseKeys.contains(column.toLowerCase())) continue;
            orderedColumnData.put(column, columnData.get(column));
            sql.append(column).append("=").append("?");
            if (++columnsIdx >= columnsCnt) continue;
            sql.append(", ");
        }
        sql.append(" WHERE ");
        int keysIndex = 0;
        for (String key : keys) {
            orderedColumnData.put(key, columnDataWithCaseInsensitiveKeys.get(key));
            sql.append(key).append("=").append("?");
            if (++keysIndex >= keys.size()) continue;
            sql.append(" AND ");
        }
        return new PreparedStatementData(sql.toString(), orderedColumnData);
    }

    public PreparedStatementData createDeleteStatement(String tableName, Map<String, Object> columnData, List<String> keys) {
        LOG.fine("createUpdateStatement tableName=" + tableName + ", columnData=..., keys=" + keys);
        LinkedHashMap<String, Object> orderedColumnData = new LinkedHashMap<String, Object>();
        TreeMap<String, Object> columnDataWithCaseInsensitiveKeys = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        columnDataWithCaseInsensitiveKeys.putAll(columnData);
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(tableName).append(" WHERE ");
        int keysIndex = 0;
        for (String key : keys) {
            orderedColumnData.put(key, columnDataWithCaseInsensitiveKeys.get(key));
            sql.append(key).append("=").append("?");
            if (++keysIndex >= keys.size()) continue;
            sql.append(" AND ");
        }
        return new PreparedStatementData(sql.toString(), orderedColumnData);
    }
}

