/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.opensearch;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcSortBuilder;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.OpenSearchRecordID;
import de.virtimo.bpc.logservice.LogService;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;

public class OpenSearchLogService
implements LogService {
    private static final Logger LOG = Logger.getLogger(OpenSearchLogService.class.getName());
    private final OpenSearchService oss;
    private final PercolatorsManager percolatorsManager;
    private final Map<String, ?> defaultIndexCreationSettings;
    private final List defaultDynamicTemplates;
    private static final Object PARENT_INDEX_LOCK = new Object();
    private static final Object CHILD_INDEX_LOCK = new Object();

    public OpenSearchLogService(OpenSearchService oss, PercolatorsManager percolatorsManager, Map<String, ?> defaultIndexCreationSettings, List defaultDynamicTemplates) {
        this.oss = oss;
        this.percolatorsManager = percolatorsManager;
        this.defaultIndexCreationSettings = defaultIndexCreationSettings;
        this.defaultDynamicTemplates = defaultDynamicTemplates;
    }

    private String createRecordId(List<String> idColumns, Map<String, Object> data) throws LogServiceException {
        LOG.fine("createRecordId idColumns=" + idColumns + ", data=...");
        TreeMap<String, Object> caseInsensitiveMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveMap.putAll(data);
        ArrayList<Object> idColumnValues = new ArrayList<Object>();
        for (String idColumn : idColumns) {
            Object value = caseInsensitiveMap.get(idColumn);
            if (value == null) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FIELD_MISSING, "Did not find the key field '${keyField}' in the log data entry: ${data}", MapUtil.mapOf("keyField", idColumn, "data", "" + caseInsensitiveMap));
            }
            idColumnValues.add(value);
        }
        return OpenSearchRecordID.create(idColumnValues);
    }

    public Map<String, Object> createDataContainerWithLookupJoinData(Map<String, Object> data, LookupJoins lookupJoins) throws OpenSearchRelatedException {
        if (lookupJoins == null || !lookupJoins.hasEntries()) {
            return data;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(data);
        for (LookupJoin lookupJoin : lookupJoins.getEntries()) {
            Object value = result.get(lookupJoin.getKeyField());
            if (value == null) continue;
            Map<String, Object> alreadyPrefixedLookupData = lookupJoin.getAlreadyPrefixedLookupData(this.oss, value);
            for (Map.Entry<String, Object> alreadyPrefixedLookupDataEntry : alreadyPrefixedLookupData.entrySet()) {
                result.put(alreadyPrefixedLookupDataEntry.getKey(), alreadyPrefixedLookupDataEntry.getValue());
            }
        }
        return result;
    }

    private Set<String> getAllChildIDsOfParent(LogServiceModuleInstance.OpenSearchConfig openSearchSettings, String parentKeyField, String parentId) throws OpenSearchRelatedException {
        LOG.info("getAllChildIDsOfParent esSettings=" + openSearchSettings + ", parentKeyField=" + parentKeyField + ", parentId=" + parentId);
        try {
            boolean childProcessingEnabled = openSearchSettings.child != null;
            HashSet<String> result = new HashSet<String>();
            if (childProcessingEnabled) {
                RestHighLevelClient osClient = this.oss.getClient();
                SearchRequest searchRequest = new SearchRequest().indices(openSearchSettings.child.index).source(new SearchSourceBuilder().fetchSource(new String[]{parentKeyField}, null).size(100).query(QueryBuilders.constantScoreQuery(QueryBuilders.termQuery(parentKeyField, parentId)))).scroll(new TimeValue(60000L));
                SearchResponse searchResponse = osClient.search(searchRequest, RequestOptions.DEFAULT);
                do {
                    for (SearchHit hit : searchResponse.getHits().getHits()) {
                        result.add(hit.getId());
                    }
                } while ((searchResponse = osClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
                this.oss.releaseScrollId(searchResponse);
            }
            return result;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private List<Map<String, Object>> getAllChildDocumentsOfParent(LogServiceModuleInstance.OpenSearchConfig openSearchSettings, String parentKeyField, Object parentId, List<SortBuilder> childSortBuilders) throws OpenSearchRelatedException {
        LOG.info("getAllChildDocumentsOfParent esSettings=" + openSearchSettings + ", parentKeyField=" + parentKeyField + ", parentId=" + parentId + ", childSortBuilders=" + childSortBuilders);
        try {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            RestHighLevelClient osClient = this.oss.getClient();
            SearchSourceBuilder ssb = new SearchSourceBuilder().size(100).query(QueryBuilders.constantScoreQuery(QueryBuilders.termQuery(parentKeyField, parentId)));
            if (childSortBuilders != null) {
                for (SortBuilder childSortBuilder : childSortBuilders) {
                    ssb.sort(childSortBuilder);
                }
            }
            SearchRequest searchRequest = new SearchRequest().indices(openSearchSettings.child.index).source(ssb).scroll(new TimeValue(60000L));
            SearchResponse searchResponse = osClient.search(searchRequest, RequestOptions.DEFAULT);
            do {
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    result.add(hit.getSourceAsMap());
                }
            } while ((searchResponse = osClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            this.oss.releaseScrollId(searchResponse);
            return result;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private List<SortBuilder> createSortBuilders(String sortInstructions, List<String> keyFields, String keyFieldsDirection, BpcIndexMapping indexMapping) {
        if (!StringUtil.isNullOrEmpty(sortInstructions)) {
            return BpcSortBuilder.init(indexMapping).addSortFromCompactFormat(sortInstructions).build();
        }
        BpcSortBuilder bpcSortBuilder = BpcSortBuilder.init(indexMapping);
        if (keyFields != null) {
            for (String keyField : keyFields) {
                bpcSortBuilder.addSort(keyField, keyFieldsDirection);
            }
        }
        return bpcSortBuilder.build();
    }

    @Override
    public FutureTask<Exception> deleteData(LogServiceModuleInstance moduleInstance, List<String> parentIDs) throws LogServiceException {
        LOG.info("deleteData moduleInstance=" + moduleInstance + ", parentIDs=" + parentIDs);
        try {
            BulkResponse bulkResponse;
            RestHighLevelClient osClient = this.oss.getClient();
            final LogServiceModuleInstance.OpenSearchConfig openSearchConfig = moduleInstance.getOpenSearchConfig();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            final boolean childProcessingEnabled = openSearchConfig.child != null;
            HashSet<String> openSearchParentRecordIDs = new HashSet<String>();
            for (String parentId : parentIDs) {
                String parentRecordId = OpenSearchRecordID.create(Arrays.asList(parentId));
                openSearchParentRecordIDs.add(parentRecordId);
            }
            HashSet<String> openSearchChildRecordIDs = null;
            if (childProcessingEnabled) {
                String parentKeyField = keysConfig.child.getIdColumnsAsList().get(0);
                openSearchChildRecordIDs = new HashSet<String>();
                for (String parentId : parentIDs) {
                    openSearchChildRecordIDs.addAll(this.getAllChildIDsOfParent(openSearchConfig, parentKeyField, parentId));
                }
            }
            PercolatorsProcessorImpl parentPercolatorsProcessor = null;
            Set<Percolator> parentPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.oss, openSearchConfig.parent.index);
            parentPercolatorsProcessor = new PercolatorsProcessorImpl(this.oss, openSearchConfig.parent.index, parentPercolatorsFromIndex);
            parentPercolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            parentPercolatorsProcessor.keepDeletedDatabaseIDs(openSearchParentRecordIDs);
            parentPercolatorsProcessor.processForDeleted();
            PercolatorsProcessorImpl childPercolatorsProcessor = null;
            if (childProcessingEnabled) {
                Set<Percolator> childPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.oss, openSearchConfig.child.index);
                childPercolatorsProcessor = new PercolatorsProcessorImpl(this.oss, openSearchConfig.child.index, childPercolatorsFromIndex);
                childPercolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
                childPercolatorsProcessor.keepDeletedDatabaseIDs(openSearchChildRecordIDs);
                childPercolatorsProcessor.processForDeleted();
            }
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (String parentRecordId : openSearchParentRecordIDs) {
                bulkRequest.add(new DeleteRequest(openSearchConfig.parent.index).id(parentRecordId));
            }
            if (childProcessingEnabled) {
                for (String childRecordId : openSearchChildRecordIDs) {
                    bulkRequest.add(new DeleteRequest(openSearchConfig.child.index).id(childRecordId));
                }
            }
            if ((bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                LOG.log(Level.SEVERE, "Errors on bulk action: " + bulkResponse.buildFailureMessage());
                return null;
            }
            LOG.fine("ES call done");
            final PercolatorsProcessorImpl finalParentPercolatorsProcessor = parentPercolatorsProcessor;
            final PercolatorsProcessorImpl finalChildPercolatorsProcessor = childPercolatorsProcessor;
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, openSearchConfig.parent.index, finalParentPercolatorsProcessor);
                        if (childProcessingEnabled) {
                            OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, openSearchConfig.child.index, finalChildPercolatorsProcessor);
                        }
                        return null;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
        }
        catch (OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete OpenSearch data.", ex);
        }
    }

    @Override
    public FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, String parentId, List<String> childIDs) throws LogServiceException {
        LOG.info("deleteChildData moduleInstance=" + moduleInstance + ", parentId=" + parentId + ", childIDs=" + childIDs);
        try {
            boolean childProcessingEnabled;
            RestHighLevelClient osClient = this.oss.getClient();
            final LogServiceModuleInstance.OpenSearchConfig openSearchConfig = moduleInstance.getOpenSearchConfig();
            boolean bl = childProcessingEnabled = openSearchConfig.child != null;
            if (!childProcessingEnabled) {
                return null;
            }
            HashSet<String> openSearchChildRecordIDs = new HashSet<String>();
            for (String childId : childIDs) {
                String childRecordId = OpenSearchRecordID.create(Arrays.asList(parentId, childId));
                openSearchChildRecordIDs.add(childRecordId);
            }
            Set<Percolator> childPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.oss, openSearchConfig.child.index);
            final PercolatorsProcessorImpl childPercolatorsProcessor = new PercolatorsProcessorImpl(this.oss, openSearchConfig.child.index, childPercolatorsFromIndex);
            childPercolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            childPercolatorsProcessor.keepDeletedDatabaseIDs(openSearchChildRecordIDs);
            childPercolatorsProcessor.processForDeleted();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (String childRecordId : openSearchChildRecordIDs) {
                bulkRequest.add(new DeleteRequest(openSearchConfig.child.index).id(childRecordId));
            }
            BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_DELETE_FAILED, "Failed to delete log service data. OpenSearch error: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            LOG.fine("OpenSearch call done");
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, openSearchConfig.child.index, childPercolatorsProcessor);
                        return null;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
        }
        catch (OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete OpenSearch data.", ex);
        }
    }

    public static Map<String, Object> fieldsAsOpenSearchMappingProperties(Map<String, LogServiceModuleInstance.FieldsConfig.Field> fields) {
        LOG.fine("fieldsAsOpenSearchMappingProperties fields=" + fields);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (fields != null && !fields.isEmpty()) {
            for (String fieldName : fields.keySet()) {
                LogServiceModuleInstance.FieldsConfig.Field field = fields.get(fieldName);
                if (field.skipOS) continue;
                if ("binary".equalsIgnoreCase(field.type) || "attachment".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "binary"));
                }
                if ("integer".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "integer"));
                }
                if ("long".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "long"));
                }
                if ("float".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "float"));
                }
                if ("double".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "double"));
                }
                if ("boolean".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "boolean"));
                }
                if ("timestamp".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "date"));
                }
                if ("date:iso8601_millis".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "date", "format", "strict_date_optional_time||epoch_millis"));
                }
                if (!"text".equalsIgnoreCase(field.type)) continue;
                properties.put(fieldName, MapUtil.mapOf("type", "text", "fields", MapUtil.mapOf("raw", MapUtil.mapOf("type", "keyword"), "lowercase", MapUtil.mapOf("type", "keyword", "normalizer", "lowercaseNormalizer"))));
            }
        }
        properties.put("_percolator_query", MapUtil.mapOf("type", "percolator"));
        return properties;
    }

    private Map<String, Object> fieldsAsOpenSearchMapping(OpenSearchService oss, Map<String, LogServiceModuleInstance.FieldsConfig.Field> fields) {
        Map<String, Object> properties;
        LOG.fine("fieldsAsOpenSearchMapping oss=..., fields=" + fields);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        if (this.defaultDynamicTemplates != null && !this.defaultDynamicTemplates.isEmpty()) {
            mapping.put("dynamic_templates", this.defaultDynamicTemplates);
        }
        if ((properties = OpenSearchLogService.fieldsAsOpenSearchMappingProperties(fields)) != null && !properties.isEmpty()) {
            mapping.put("properties", properties);
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureTask<Exception> logData(LogServiceModuleInstance moduleInstance, ZonedDateTime currentDateTime, LogData logData) throws LogServiceException {
        LOG.info("logData moduleInstance=" + moduleInstance + ", logData=...");
        try {
            final LogServiceModuleInstance.OpenSearchConfig openSearchConfig = moduleInstance.getOpenSearchConfig();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            final LogServiceModuleInstance.FieldsConfig fieldsConfig = moduleInstance.getFieldsConfig();
            LookupJoins lookupJoins = moduleInstance.getLookupJoins();
            final boolean childProcessingEnabled = openSearchConfig.child != null;
            Object object = PARENT_INDEX_LOCK;
            synchronized (object) {
                try {
                    BpcIndexState parentIndexState = this.oss.getIndexState(openSearchConfig.parent.index);
                    parentIndexState.prepareUsing(new BpcIndexCreateCallable(){

                        @Override
                        public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                            return oss.createIndex(openSearchConfig.parent.index, OpenSearchLogService.this.defaultIndexCreationSettings, OpenSearchLogService.this.fieldsAsOpenSearchMapping(OpenSearchLogService.this.oss, fieldsConfig.parent));
                        }
                    });
                    if (!this.oss.existsAttachmentsPipeline(openSearchConfig.parent.index)) {
                        this.oss.prepareAttachmentsPipeline(openSearchConfig.parent.index);
                    }
                }
                catch (Exception ex) {
                    throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to prepare the parent index: ${error}", MapUtil.mapOf("index", openSearchConfig.parent.index, "error", ex.getLocalizedMessage()), (Throwable)ex);
                }
            }
            if (childProcessingEnabled) {
                object = CHILD_INDEX_LOCK;
                synchronized (object) {
                    try {
                        BpcIndexState childIndexState = this.oss.getIndexState(openSearchConfig.child.index);
                        childIndexState.prepareUsing(new BpcIndexCreateCallable(){

                            @Override
                            public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                                return oss.createIndex(openSearchConfig.child.index, OpenSearchLogService.this.defaultIndexCreationSettings, OpenSearchLogService.this.fieldsAsOpenSearchMapping(OpenSearchLogService.this.oss, fieldsConfig.child));
                            }
                        });
                        if (!this.oss.existsAttachmentsPipeline(openSearchConfig.child.index)) {
                            this.oss.prepareAttachmentsPipeline(openSearchConfig.child.index);
                        }
                    }
                    catch (Exception ex) {
                        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to prepare the child index: ${error}", MapUtil.mapOf("index", openSearchConfig.child.index, "error", ex.getLocalizedMessage()), (Throwable)ex);
                    }
                }
            }
            RestHighLevelClient osClient = this.oss.getClient();
            Set<String> parentFieldsToSkip = fieldsConfig.getOpenSearchParentFieldsToSkip();
            Set<String> childFieldsToSkip = fieldsConfig.getOpenSearchChildFieldsToSkip();
            Set<String> parentTimestampFieldsInLowerCase = fieldsConfig.getParentTimestampFieldsInLowerCase();
            Set<String> childTimestampFieldsInLowerCase = fieldsConfig.getChildTimestampFieldsInLowerCase();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (LogData.LogDataEntry logDataEntry : logData.entries) {
                if (logDataEntry.parent != null) {
                    Map<String, Object> parentData = this.createDataContainerWithLookupJoinData(logDataEntry.parent, lookupJoins);
                    parentData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithoutFieldsToSkip(parentData, parentFieldsToSkip);
                    parentData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithReplacedSysdatePlaceholders(parentData, parentTimestampFieldsInLowerCase, currentDateTime, null);
                    parentData = this.createDataContainerWithConvertedValuesLikeOpenSearchNeedsThem(parentData);
                    String parentRecordId = this.createRecordId(keysConfig.parent.getIdColumnsAsList(), parentData);
                    if (logDataEntry.partialUpdate) {
                        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(openSearchConfig.parent.index)).id(parentRecordId).doc(parentData, XContentType.JSON);
                        bulkRequest.add(updateRequest);
                    } else {
                        IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(openSearchConfig.parent.index)).id(parentRecordId).source(parentData, XContentType.JSON);
                        indexRequest.setPipeline(this.oss.getAttachmentsPipelineName(openSearchConfig.parent.index));
                        bulkRequest.add(indexRequest);
                    }
                }
                if (!childProcessingEnabled || logDataEntry.childs == null) continue;
                for (Map<String, Object> childData : logDataEntry.childs) {
                    childData = this.createDataContainerWithLookupJoinData(childData, lookupJoins);
                    childData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithoutFieldsToSkip(childData, childFieldsToSkip);
                    childData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithReplacedSysdatePlaceholders(childData, childTimestampFieldsInLowerCase, currentDateTime, null);
                    childData = this.createDataContainerWithConvertedValuesLikeOpenSearchNeedsThem(childData);
                    String childRecordId = this.createRecordId(keysConfig.child.getIdColumnsAsList(), childData);
                    if (logDataEntry.partialUpdate) {
                        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(openSearchConfig.child.index)).id(childRecordId).doc(childData, XContentType.JSON);
                        bulkRequest.add(updateRequest);
                        continue;
                    }
                    IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(openSearchConfig.child.index)).id(childRecordId).source(childData, XContentType.JSON);
                    indexRequest.setPipeline(this.oss.getAttachmentsPipelineName(openSearchConfig.child.index));
                    bulkRequest.add(indexRequest);
                }
            }
            final BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to bulk index the given log service data. OpenSearch error: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            LOG.fine("OpenSearch call done");
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, openSearchConfig.parent.index, bulkResponse);
                        if (childProcessingEnabled) {
                            OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, openSearchConfig.child.index, bulkResponse);
                        }
                        return null;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
        }
        catch (OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to log data in OpenSearch.", ex);
        }
    }

    private Map<String, Object> createDataContainerWithConvertedValuesLikeOpenSearchNeedsThem(Map<String, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            String key = stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (value instanceof Date) {
                result.put(key, this.oss.formatForOpenSearch((Date)value));
                continue;
            }
            if (value instanceof Timestamp) {
                result.put(key, this.oss.formatForOpenSearch((Timestamp)value));
                continue;
            }
            if (value instanceof java.util.Date) {
                result.put(key, this.oss.formatForOpenSearch((java.util.Date)value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOpenSearchIndexMappings(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceSettingsException, OpenSearchRelatedException {
        LOG.info("updateOpenSearchIndexMappings logServiceModuleInstance=...");
        if (logServiceModuleInstance != null) {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
            LogServiceModuleInstance.FieldsConfig fieldsConfig = logServiceModuleInstance.getFieldsConfig();
            boolean childProcessingEnabled = openSearchConfig.child != null;
            Object object = PARENT_INDEX_LOCK;
            synchronized (object) {
                if (this.oss.existsIndex(openSearchConfig.parent.index)) {
                    try {
                        this.oss.updateIndexMapping(openSearchConfig.parent.index, this.fieldsAsOpenSearchMapping(this.oss, fieldsConfig.parent));
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "Failed to update the parent index mapping (" + openSearchConfig.parent.index + ") of the log service module instance: " + logServiceModuleInstance, ex);
                    }
                }
            }
            if (childProcessingEnabled) {
                object = CHILD_INDEX_LOCK;
                synchronized (object) {
                    if (this.oss.existsIndex(openSearchConfig.child.index)) {
                        try {
                            this.oss.updateIndexMapping(openSearchConfig.child.index, this.fieldsAsOpenSearchMapping(this.oss, fieldsConfig.child));
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, "Failed to update the child index mapping (" + openSearchConfig.child.index + ") of the log service module instance: " + logServiceModuleInstance, ex);
                        }
                    }
                }
            }
        }
    }

    @Override
    public LogData getLogData(LogServiceModule logServiceModule, LogServiceModuleInstance moduleInstance, String timeZoneId, Integer start, Integer limit, String parentQuery, String parentFilter, String parentSort, String childSort, boolean addChilds) throws LogServiceException {
        LOG.info("getLogData logServiceModule=..., moduleInstance=..., timeZoneId=" + timeZoneId + ", start=" + start + ", limit=" + limit + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter + ", parentSort=" + parentSort + ", childSort=" + childSort + ", addChilds=" + addChilds);
        try {
            if (start == null || start < 0) {
                start = 0;
                LOG.finest("Not start parameter or out of range. Set start to " + start);
            }
            if (limit == null || limit < 0 || limit > 10000) {
                limit = 100;
                LOG.finest("Not limit parameter or out of range. Set limit to " + limit);
            }
            RestHighLevelClient osClient = this.oss.getClient();
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = moduleInstance.getOpenSearchConfig();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            int maxResultWindowSize = (Integer)logServiceModule.getConfiguration().getSetting("es_data_view_limit").getValue();
            int maxDataCount = (Integer)logServiceModule.getConfiguration().getSetting("es_data_count_limit").getValue();
            try {
                Settings settings = Settings.builder().put("max_result_window", maxResultWindowSize).build();
                osClient.indices().putSettings(new UpdateSettingsRequest(openSearchConfig.parent.index).settings(settings), RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                LOG.warning(e.getLocalizedMessage());
            }
            if (start + limit > maxResultWindowSize) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_QUERY_RANGE_LIMIT, "Requested range ${from} - ${to} is breaking the configured limit (${settingName}) of ${maxResultWindowSize}", MapUtil.mapOf("from", start, "to", start + limit, "settingName", "es_data_view_limit", "maxResultWindowSize", maxResultWindowSize));
            }
            BpcIndexMapping parentIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(openSearchConfig.parent.index));
            List<SortBuilder> parentSortBuilders = this.createSortBuilders(parentSort, keysConfig.parent.getIdColumnsAsList(), "DESC", parentIndexMapping);
            List<SortBuilder> childSortBuilders = null;
            String parentKeyFieldForChildQuery = null;
            if (addChilds) {
                boolean childProcessingEnabled;
                boolean bl = childProcessingEnabled = openSearchConfig.child != null;
                if (childProcessingEnabled) {
                    BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(openSearchConfig.child.index));
                    childSortBuilders = this.createSortBuilders(childSort, keysConfig.child.getIdColumnsAsList(), "ASC", childIndexMapping);
                    parentKeyFieldForChildQuery = childIndexMapping.getPreferredQueryFieldForIDs(keysConfig.child.getIdColumnsAsList().get(0));
                }
            }
            SearchSourceBuilder ssb = new SearchSourceBuilder().from(start).size(limit).trackTotalHitsUpTo(maxDataCount);
            QueryBuilder esQuery = new BpcQueryBuilder(openSearchConfig.parent.index).addSkipPercolatorDocumentsQuery().addStringBasedQuery(parentQuery).addQueriesForFilters(parentFilter, parentIndexMapping, timeZoneId).buildAsBoolFilterQuery();
            ssb.query(esQuery);
            for (SortBuilder parentSortBuilder : parentSortBuilders) {
                ssb.sort(parentSortBuilder);
            }
            SearchRequest searchRequest = new SearchRequest().indices(openSearchConfig.parent.index).source(ssb);
            LogData logData = new LogData();
            logData.entries = new ArrayList<LogData.LogDataEntry>();
            SearchResponse searchResponse = osClient.search(searchRequest, RequestOptions.DEFAULT);
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                LogData.LogDataEntry logDataEntry = new LogData.LogDataEntry();
                logDataEntry.partialUpdate = false;
                logDataEntry.parent = sourceAsMap;
                logDataEntry.childs = null;
                if (addChilds) {
                    boolean childProcessingEnabled;
                    boolean bl = childProcessingEnabled = openSearchConfig.child != null;
                    if (childProcessingEnabled) {
                        String parentId = hit.getId();
                        logDataEntry.childs = this.getAllChildDocumentsOfParent(openSearchConfig, parentKeyFieldForChildQuery, parentId, childSortBuilders);
                    }
                }
                logData.entries.add(logDataEntry);
            }
            return logData;
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from OpenSearch.", ex);
        }
    }

    @Override
    public LogData getLogData(LogServiceModuleInstance moduleInstance, String parentId) throws LogServiceException {
        LOG.info("getLogData moduleInstance=..., parentId=" + parentId);
        try {
            boolean childProcessingEnabled;
            RestHighLevelClient osClient = this.oss.getClient();
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = moduleInstance.getOpenSearchConfig();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            String parentDocumentId = OpenSearchRecordID.create(List.of(parentId));
            Map<String, Object> parentDocument = this.fetchDocumentFromIndexById(osClient, openSearchConfig.parent.index, parentDocumentId);
            LogData.LogDataEntry logDataEntry = new LogData.LogDataEntry();
            logDataEntry.partialUpdate = false;
            logDataEntry.parent = parentDocument;
            logDataEntry.childs = null;
            boolean bl = childProcessingEnabled = openSearchConfig.child != null;
            if (childProcessingEnabled) {
                BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(openSearchConfig.child.index));
                List<SortBuilder> childSortBuilders = this.createSortBuilders(null, keysConfig.child.getIdColumnsAsList(), "ASC", childIndexMapping);
                String parentKeyField = childIndexMapping.getPreferredQueryFieldForIDs(keysConfig.child.getIdColumnsAsList().get(0));
                logDataEntry.childs = this.getAllChildDocumentsOfParent(openSearchConfig, parentKeyField, parentId, childSortBuilders);
            }
            LogData logData = new LogData();
            logData.entries = new ArrayList<LogData.LogDataEntry>();
            logData.entries.add(logDataEntry);
            return logData;
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from OpenSearch.", ex);
        }
    }

    @Override
    public LogData getLogData(LogServiceModuleInstance moduleInstance, String parentId, String childId) throws LogServiceException {
        LOG.info("getLogData moduleInstance=..., parentId=" + parentId + ", childId=" + childId);
        try {
            boolean childProcessingEnabled;
            RestHighLevelClient osClient = this.oss.getClient();
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = moduleInstance.getOpenSearchConfig();
            boolean bl = childProcessingEnabled = openSearchConfig.child != null;
            if (!childProcessingEnabled) {
                return null;
            }
            String parentDocumentId = OpenSearchRecordID.create(List.of(parentId));
            Map<String, Object> parentDocument = this.fetchDocumentFromIndexById(osClient, openSearchConfig.parent.index, parentDocumentId);
            String childDocumentId = OpenSearchRecordID.create(List.of(parentId, childId));
            Map<String, Object> childDocument = this.fetchDocumentFromIndexById(osClient, openSearchConfig.child.index, childDocumentId);
            LogData.LogDataEntry logDataEntry = new LogData.LogDataEntry();
            logDataEntry.partialUpdate = true;
            logDataEntry.parent = parentDocument;
            logDataEntry.childs = new ArrayList<Map<String, Object>>();
            logDataEntry.childs.add(childDocument);
            LogData logData = new LogData();
            logData.entries = new ArrayList<LogData.LogDataEntry>();
            logData.entries.add(logDataEntry);
            return logData;
        }
        catch (IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from OpenSearch.", ex);
        }
    }

    private Map<String, Object> fetchDocumentFromIndexById(RestHighLevelClient osClient, String index, String documentId) throws IOException {
        LOG.info("fetchDocumentFromIndexById osClient=..., index=" + index + ", documentId=" + documentId);
        GetRequest getReq = ((GetRequest)new GetRequest().index(index)).id(documentId);
        GetResponse response = osClient.get(getReq, RequestOptions.DEFAULT);
        return response.getSourceAsMap();
    }
}

