/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.resource.response.SimpleModuleConfigImpl;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.TimeZoneUtil;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="log")
public class LogServiceEndpoint {
    private static final Logger LOG = Logger.getLogger(LogServiceEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public LogServiceEndpoint(BundleContext bundleContext) {
        LOG.info("LogServiceEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private LogServiceModule getLogServiceModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (LogServiceModule)this.moduleManagerTracker.getService().getModuleById("logservice");
    }

    @GET
    @Path(value="/instances")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_CONFIG_GET_INSTANCES")
    public Response getInstances(@Context HttpServletRequest req) {
        LOG.info("getInstances");
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            ArrayList<Map<String, Boolean>> instances = new ArrayList<Map<String, Boolean>>();
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                instances.add(Map.of("id", logServiceModuleInstance.getModuleId(), "name", logServiceModuleInstance.getConfiguration().getSettingValue("module_name").asString(""), "description", logServiceModuleInstance.getConfiguration().getSettingValue("moduleHeader_description").asString(""), "maintenanceEnabled", logServiceModuleInstance.isMaintenanceEnabled()));
            }
            return Response.ok(Map.of("instances", instances)).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get list of log service instances failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/instances/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_CONFIG_GET_INSTANCE")
    public Response getInstanceConfig(@PathParam(value="instanceIdOrName") String instanceIdOrName, @Context HttpServletRequest req) {
        LOG.info("getInstanceConfig instanceIdOrName=" + instanceIdOrName);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            return Response.ok((Object)new SimpleModuleConfigImpl(logServiceModuleInstance)).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get log service instance config failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    public Response getConfigOrData(@PathParam(value="instanceIdOrName") String instanceIdOrName, @QueryParam(value="timezoneOffset") String timezoneOffset, @QueryParam(value="timezoneName") String timezoneName, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="parentQuery") String parentQuery, @QueryParam(value="parentFilter") String parentFilter, @QueryParam(value="parentSort") String parentSort, @QueryParam(value="childSort") String childSort, @QueryParam(value="addChilds") @DefaultValue(value="true") boolean addChilds, @Context HttpServletRequest req) {
        LOG.info("getConfigOrData instanceIdOrName=" + instanceIdOrName);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
            return Response.ok((Object)logServiceModule.getLogData(logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, childSort, addChilds)).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get config or data failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{instanceIdOrName}/{parentId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    public Response getData(@PathParam(value="instanceIdOrName") String instanceIdOrName, @PathParam(value="parentId") String parentId, @Context HttpServletRequest req) {
        LOG.info("getData instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            LogData logData = logServiceModule.getLogData(logServiceModuleInstance, parentId);
            return Response.ok((Object)logData).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Getting the requested log data by parentId failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{instanceIdOrName}/{parentId}/{childId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    public Response getData(@PathParam(value="instanceIdOrName") String instanceIdOrName, @PathParam(value="parentId") String parentId, @PathParam(value="childId") String childId, @Context HttpServletRequest req) {
        LOG.info("getData instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId + ", childId=" + childId);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            LogData logData = logServiceModule.getLogData(logServiceModuleInstance, parentId, childId);
            return Response.ok((Object)logData).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Getting the requested log data by parentId and childId failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_WRITE_DATA")
    public Response log(@PathParam(value="instanceIdOrName") String instanceIdOrName, @QueryParam(value="async") @DefaultValue(value="false") boolean async, @Context HttpServletRequest req, String json) {
        LOG.info("log (" + (async ? "asynchron" : "synchron") + ")");
        try {
            LogData logData;
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            if (StringUtil.isNullOrEmpty(json)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No data to log given");
            }
            try {
                logData = JsonUtil.getInstance().convertJsonStringToPojo(json, LogData.class);
            }
            catch (IOException ex) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Could not convert the given data to a LogData object. Invalid JSON structure?", ex);
            }
            if (logData == null || logData.entries == null || logData.entries.size() == 0) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No JSON data to log given");
            }
            if (logServiceModuleInstance.isOpenSearchLoggingEnabled() && logServiceModule.areUsedIndicesTemporaryUnavailable(logServiceModuleInstance)) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' uses an index that is temporary unavailable.", MapUtil.mapOf("moduleId", "logservice", "instanceId", instanceIdOrName));
            }
            logServiceModule.log(async, logServiceModuleInstance, logData);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Logging failed", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{instanceIdOrName}/{parentId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    public Response deleteEntry(@PathParam(value="instanceIdOrName") String instanceIdOrName, @PathParam(value="parentId") String parentId, @Context HttpServletRequest req) {
        LOG.info("deleteEntry instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId);
        return this.deleteEntry(req, instanceIdOrName, parentId, null);
    }

    @DELETE
    @Path(value="/{instanceIdOrName}/{parentId}/{childId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    public Response deleteEntry(@PathParam(value="instanceIdOrName") String instanceIdOrName, @PathParam(value="parentId") String parentId, @PathParam(value="childId") String childId, @Context HttpServletRequest req) {
        LOG.info("deleteEntry instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId + ", childId=" + childId);
        return this.deleteEntry(req, instanceIdOrName, parentId, childId);
    }

    private Response deleteEntry(HttpServletRequest req, String instanceIdOrName, String parentId, String childId) {
        LOG.info("deleteEntry req=..., moduleManager=..., instanceIdOrName=" + instanceIdOrName + ", parentId=" + parentId + ", childId=" + childId);
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            LogServiceModule logServiceModule = this.getLogServiceModule();
            this.doClientCertificateAuthCheck(logServiceModule, req);
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
            if (logServiceModuleInstance.isOpenSearchLoggingEnabled() && logServiceModule.areUsedIndicesTemporaryUnavailable(logServiceModuleInstance)) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' uses an index that is temporary unavailable.", MapUtil.mapOf("moduleId", "logservice", "instanceId", instanceIdOrName));
            }
            if (childId == null) {
                List<String> parentIDs = StringUtil.explode(parentId, ",");
                logServiceModule.deleteEntries(logServiceModuleInstance, parentIDs);
            } else {
                List<String> childIDs = StringUtil.explode(childId, ",");
                logServiceModule.deleteChildEntries(logServiceModuleInstance, parentId, childIDs);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Delete failed.", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private void doClientCertificateAuthCheck(LogServiceModule logServiceModule, HttpServletRequest req) throws LogServiceException {
        boolean isClientCertificateAuthMandatory = logServiceModule.getConfiguration().getSettingValue("clientCertificateAuthMandatory").asBoolean(false);
        if (isClientCertificateAuthMandatory) {
            if (req == null) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_UNAUTHORIZED, "Not authorized");
            }
            X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
            if (certs == null || certs.length == 0) {
                LOG.info("No mutual client certificate given");
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_UNAUTHORIZED, "Not authorized (cca)");
            }
            for (X509Certificate cert : certs) {
                LOG.info("Mutual client certificate given: " + cert.getSubjectX500Principal().getName());
            }
        }
    }

    private void doGlobalMaintenanceModeEnabledCheck() throws ServiceNotFoundException, LogServiceException {
        if (this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The core is currently in maintenance.");
        }
    }

    private void doModuleInstanceMaintenanceModeEnabledCheck(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceException {
        if (logServiceModuleInstance.isMaintenanceEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' is currently in maintenance.", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
        if (!logServiceModuleInstance.isOpenSearchLoggingEnabled() && !logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' is currently in maintenance (ES and RDMS logging disabled).", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
    }
}

