/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import com.fasterxml.jackson.databind.type.TypeFactory;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class ModuleActivator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(ModuleActivator.class.getName());
    private BundleContext bundleContext;
    private ServiceTracker moduleManagerTracker;
    private Class<? extends Module> moduleClass = this.getBpcModuleClass();
    private Module module;

    public abstract Class<? extends Module> getBpcModuleClass();

    @Deprecated(since="3.0.0", forRemoval=true)
    public BundleContext getContext() {
        return this.bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void start(BundleContext bundleContext) throws Exception {
        LOG.info("BPC Module start: " + this.moduleClass.getName());
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new ServiceTracker(bundleContext, ModuleManager.class, null){

            public Object addingService(ServiceReference reference) {
                LOG.info("BPC Service tracked");
                ModuleManager moduleManager = (ModuleManager)this.context.getService(reference);
                try {
                    Constructor<?> ctor;
                    Constructor<?>[] ctors = ModuleActivator.this.moduleClass.getDeclaredConstructors();
                    Constructor<?> moduleConstructor = null;
                    Constructor<?>[] constructorArray = ctors;
                    int n = constructorArray.length;
                    for (int i = 0; !(i >= n || (moduleConstructor = (ctor = constructorArray[i])).getParameterTypes().length == 1 && moduleConstructor.getParameterTypes()[0].equals(ModuleManager.class)); ++i) {
                    }
                    ModuleActivator.this.module = (Module)moduleConstructor.newInstance(moduleManager);
                    ModuleActivator.this.module.setModuleBundle(this.context.getBundle());
                    moduleManager.loadModule(ModuleActivator.this.module);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                    LOG.log(Level.SEVERE, "Failed to create an Java instance of a module.", ex);
                }
                catch (SettingException ex) {
                    LOG.log(Level.SEVERE, "Failed to load module.", ex);
                }
                catch (ServiceNotFoundException ex) {
                    LOG.log(Level.SEVERE, "Failed to load module due to missing service.", ex);
                }
                return moduleManager;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                LOG.info("BPC Service changed");
            }

            public void removedService(ServiceReference reference, Object service) {
                LOG.info("BPC Service lost");
                if (service instanceof ModuleManager) {
                    ((ModuleManager)service).unloadModule(ModuleActivator.this.module);
                    ModuleActivator.this.module = null;
                } else {
                    LOG.log(Level.SEVERE, "There is something wrong. The given service (" + service + ") is not the expected ModuleManager.");
                }
                this.context.ungetService(reference);
            }
        };
        this.moduleManagerTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        LOG.info("BPC Module stop: " + this.moduleClass.getName());
        this.moduleManagerTracker.close();
        TypeFactory.defaultInstance().clearCache();
    }
}

