/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.simple;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.virtimo.bpc.api.CustomFields;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.RestrictedSetting;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.SettingValue;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.module.simple.CustomFieldsImpl;
import de.virtimo.bpc.module.simple.SimpleSettingDeserializer;
import de.virtimo.bpc.module.simple.SimpleSettingSerializer;
import de.virtimo.bpc.module.simple.SimpleSettingValueImpl;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

@JsonSerialize(using=SimpleSettingSerializer.class)
@JsonDeserialize(using=SimpleSettingDeserializer.class)
public class SimpleSettingImpl
implements RestrictedSetting {
    private static final Logger LOG = Logger.getLogger(SimpleSettingImpl.class.getName());
    private static final String ID_NOT_GENERATED = "IdNotGenerated";
    public static Set<String> ReservedFieldNames = new HashSet<String>(Arrays.asList("id", "name", "type", "value", "moduleId", "instanceId", "instanceType", "readProtected", "writeProtected"));
    private String _id = "IdNotGenerated";
    private String name;
    private String type;
    private Object value;
    private String moduleId;
    private String instanceId = "noinstance";
    private String instanceType = "none";
    private CustomFields customFields;

    public SimpleSettingImpl() {
        this.name = "SimpleSettingImplNotInitialized";
        this.type = "SimpleSettingImplNotInitialized";
    }

    public SimpleSettingImpl(Setting s) {
        this(s, s.getValue());
    }

    public SimpleSettingImpl(Setting s, Object value) {
        this(value, s.getName(), s.getType(), s.getModuleId(), s.getInstanceId(), s.getInstanceType(), new CustomFieldsImpl(s.getCustomFields()));
        this._id = s.getId();
    }

    public SimpleSettingImpl(Object value, String name, String type, String moduleId) {
        this(value, name, type, moduleId, "noinstance", "none", null);
    }

    public SimpleSettingImpl(Object value, String name, String type, String moduleId, String instanceId) {
        this(value, name, type, moduleId, instanceId, "none", null);
    }

    public SimpleSettingImpl(Object value, String name, String type, String moduleId, String instanceId, String instanceType) {
        this(value, name, type, moduleId, instanceId, instanceType, null);
    }

    public SimpleSettingImpl(Object value, String name, String type, String moduleId, String instanceId, String instanceType, CustomFields customFields) {
        this._id = ID_NOT_GENERATED;
        this.value = value;
        this.setName(name);
        this.type = type;
        this.moduleId = moduleId;
        this.setInstanceId(instanceId);
        this.setInstanceType(instanceType);
        this.customFields = customFields != null ? customFields : new CustomFieldsImpl();
    }

    @Override
    public String getId() {
        if (ID_NOT_GENERATED.equals(this._id)) {
            this._id = StringUtil.isNullOrEmpty(this.moduleId) || StringUtil.isNullOrEmpty(this.instanceId) || StringUtil.isNullOrEmpty(this.name) ? null : this.moduleId + "_" + this.instanceId + "_" + this.name;
        }
        return this._id;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public void setModuleId(String moduleId) {
        if (moduleId != null && !Objects.equals(this.moduleId, moduleId)) {
            this._id = ID_NOT_GENERATED;
        }
        this.moduleId = moduleId;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void setInstanceId(String instanceId) {
        if (instanceId != null && !Objects.equals(this.instanceId, instanceId)) {
            this._id = ID_NOT_GENERATED;
        }
        if (StringUtil.isNullOrEmpty(instanceId)) {
            instanceId = "noinstance";
        }
        this.instanceId = instanceId;
    }

    @Override
    public String getInstanceType() {
        return this.instanceType;
    }

    @Override
    public void setInstanceType(String instanceType) {
        if (StringUtil.isNullOrEmpty(instanceType)) {
            instanceType = "none";
        }
        this.instanceType = instanceType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && !Objects.equals(this.name, name)) {
            this._id = ID_NOT_GENERATED;
        }
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public SettingValue getSettingValue() {
        return new SimpleSettingValueImpl(this);
    }

    private boolean isReadableOrWriteableByRoles(List<Role> roles, String fieldName, List<String> defaultRoles) {
        if (roles == null || roles.isEmpty()) {
            return false;
        }
        Object readableOrWriteableByRolesObject = this.customFields.getObjectValue(fieldName, defaultRoles);
        if (!(readableOrWriteableByRolesObject instanceof List)) {
            LOG.warning("The '" + fieldName + "' value of the following setting must be a string array: " + this);
            return false;
        }
        List readableOrWriteableByRoles = (List)readableOrWriteableByRolesObject;
        for (Role role : roles) {
            for (String readableOrWriteableByRole : readableOrWriteableByRoles) {
                if (!readableOrWriteableByRole.equalsIgnoreCase(role.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isWriteableByRoles(List<Role> roles) {
        return this.isReadableOrWriteableByRoles(roles, "_writeableByRoles", RestrictedSetting.DefaultWriteableByRoles);
    }

    @Override
    public boolean isReadableByRoles(List<Role> roles) {
        return this.isReadableOrWriteableByRoles(roles, "_readableByRoles", RestrictedSetting.DefaultReadableByRoles);
    }

    @Override
    @NotNull
    public CustomFields getCustomFields() {
        return this.customFields;
    }

    @Override
    public byte[] toJsonAsBytes() throws SettingException {
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            byte[] byArray = mapper.writeValueAsBytes((Object)this);
            return byArray;
        }
        catch (IOException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to convert the JSON of the setting with the ID '${settingId}' to a byte array.", MapUtil.mapOf("settingId", this.getId()), (Throwable)ex);
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSettingImpl that = (SimpleSettingImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value) && Objects.equals(this.moduleId, that.moduleId) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.instanceType, that.instanceType) && Objects.equals(this.customFields, that.customFields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.value, this.moduleId, this.instanceId, this.instanceType, this.customFields);
    }

    public String toString() {
        return "SimpleSettingImpl{name='" + this.name + "', type='" + this.type + "', value=..., moduleId='" + this.moduleId + "', instanceId='" + this.instanceId + "', instanceType='" + this.instanceType + "', customFields=" + this.customFields + "}";
    }
}

