/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.vibur.objectpool.ConcurrentPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ConcurrentCollection;
import org.vibur.objectpool.util.ConcurrentLinkedQueueCollection;

public class ObjectMapperPool {
    private static PoolService<ObjectMapper> objectMapperPool;

    private ObjectMapperPool() {
    }

    public static ObjectMapper createCustomizedObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new JavaTimeModule());
        om.getFactory().disable(JsonFactory.Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING);
        return om;
    }

    public static PoolService<ObjectMapper> getInstance() {
        if (objectMapperPool == null) {
            objectMapperPool = new ConcurrentPool((ConcurrentCollection)new ConcurrentLinkedQueueCollection(), (PoolObjectFactory)new ObjectMapperPoolFactory(), 10, 100, false);
        }
        return objectMapperPool;
    }

    public static void destroySingleton() {
        if (objectMapperPool != null) {
            objectMapperPool.close();
        }
        objectMapperPool = null;
    }

    public static class ObjectMapperPoolFactory
    implements PoolObjectFactory<ObjectMapper> {
        public ObjectMapper create() {
            return ObjectMapperPool.createCustomizedObjectMapper();
        }

        public boolean readyToTake(ObjectMapper obj) {
            return true;
        }

        public boolean readyToRestore(ObjectMapper obj) {
            return true;
        }

        public void destroy(ObjectMapper obj) {
        }
    }
}

