/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class FreeTextSuggester
extends Lookup {
    public static final String CODEC_NAME = "freetextsuggest";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final int DEFAULT_GRAMS = 2;
    public static final double ALPHA = 0.4;
    private FST<Long> fst;
    private final Analyzer indexAnalyzer;
    private long totTokens;
    private final Analyzer queryAnalyzer;
    private final int grams;
    private final byte separator;
    private volatile long count = 0L;
    public static final byte DEFAULT_SEPARATOR = 30;
    static final Comparator<Long> weightComparator = new Comparator<Long>(){

        @Override
        public int compare(Long left, Long right) {
            return left.compareTo(right);
        }
    };

    public FreeTextSuggester(Analyzer analyzer) {
        this(analyzer, analyzer, 2);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(indexAnalyzer, queryAnalyzer, 2);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int grams) {
        this(indexAnalyzer, queryAnalyzer, grams, 30);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int grams, byte separator) {
        this.grams = grams;
        this.indexAnalyzer = this.addShingles(indexAnalyzer);
        this.queryAnalyzer = this.addShingles(queryAnalyzer);
        if (grams < 1) {
            throw new IllegalArgumentException("grams must be >= 1");
        }
        if ((separator & 0x80) != 0) {
            throw new IllegalArgumentException("separator must be simple ascii character");
        }
        this.separator = separator;
    }

    @Override
    public long ramBytesUsed() {
        if (this.fst == null) {
            return 0L;
        }
        return this.fst.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        if (this.fst == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Accountables.namedAccountable("fst", this.fst));
    }

    private Analyzer addShingles(final Analyzer other) {
        if (this.grams == 1) {
            return other;
        }
        return new AnalyzerWrapper(other.getReuseStrategy()){

            @Override
            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return other;
            }

            @Override
            protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
                ShingleFilter shingles = new ShingleFilter(components.getTokenStream(), 2, FreeTextSuggester.this.grams);
                shingles.setTokenSeparator(Character.toString((char)FreeTextSuggester.this.separator));
                return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)shingles);
            }
        };
    }

    @Override
    public void build(InputIterator iterator) throws IOException {
        this.build(iterator, 16.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(InputIterator iterator, double ramBufferSizeMB) throws IOException {
        Path tempIndexPath;
        block16: {
            if (iterator.hasPayloads()) {
                throw new IllegalArgumentException("this suggester doesn't support payloads");
            }
            if (iterator.hasContexts()) {
                throw new IllegalArgumentException("this suggester doesn't support contexts");
            }
            String prefix = this.getClass().getSimpleName();
            tempIndexPath = Files.createTempDirectory(prefix + ".index.", new FileAttribute[0]);
            FSDirectory dir = FSDirectory.open(tempIndexPath);
            IndexWriterConfig iwc = new IndexWriterConfig(this.indexAnalyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            iwc.setRAMBufferSizeMB(ramBufferSizeMB);
            IndexWriter writer = new IndexWriter(dir, iwc);
            FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
            ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
            ft.setOmitNorms(true);
            ft.freeze();
            Document doc = new Document();
            Field field = new Field("body", "", (IndexableFieldType)ft);
            doc.add(field);
            this.totTokens = 0L;
            DirectoryReader reader = null;
            boolean success = false;
            long newCount = 0L;
            try {
                BytesRef term;
                BytesRef surfaceForm;
                while ((surfaceForm = iterator.next()) != null) {
                    field.setStringValue(surfaceForm.utf8ToString());
                    writer.addDocument(doc);
                    ++newCount;
                }
                reader = DirectoryReader.open(writer);
                Terms terms = MultiTerms.getTerms(reader, "body");
                if (terms == null) {
                    throw new IllegalArgumentException("need at least one suggestion");
                }
                TermsEnum termsEnum = terms.iterator();
                PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
                FSTCompiler<Long> fstCompiler = new FSTCompiler<Long>(FST.INPUT_TYPE.BYTE1, outputs);
                IntsRefBuilder scratchInts = new IntsRefBuilder();
                while ((term = termsEnum.next()) != null) {
                    int ngramCount = this.countGrams(term);
                    if (ngramCount > this.grams) {
                        throw new IllegalArgumentException("tokens must not contain separator byte; got token=" + term + " but gramCount=" + ngramCount + ", which is greater than expected max ngram size=" + this.grams);
                    }
                    if (ngramCount == 1) {
                        this.totTokens += termsEnum.totalTermFreq();
                    }
                    fstCompiler.add(Util.toIntsRef(term, scratchInts), this.encodeWeight(termsEnum.totalTermFreq()));
                }
                FST<Long> newFst = fstCompiler.compile();
                if (newFst == null) {
                    throw new IllegalArgumentException("need at least one suggestion");
                }
                this.fst = newFst;
                this.count = newCount;
                writer.rollback();
                success = true;
            }
            catch (Throwable throwable) {
                block17: {
                    try {
                        if (success) {
                            IOUtils.close(reader, dir);
                            break block17;
                        }
                        IOUtils.closeWhileHandlingException(reader, writer, dir);
                    }
                    catch (Throwable throwable2) {
                        IOUtils.rm(tempIndexPath);
                        throw throwable2;
                    }
                }
                IOUtils.rm(tempIndexPath);
                throw throwable;
            }
            try {
                if (success) {
                    IOUtils.close(reader, dir);
                    break block16;
                }
                IOUtils.closeWhileHandlingException(reader, writer, dir);
            }
            catch (Throwable throwable) {
                IOUtils.rm(tempIndexPath);
                throw throwable;
            }
        }
        IOUtils.rm(tempIndexPath);
    }

    @Override
    public boolean store(DataOutput output) throws IOException {
        CodecUtil.writeHeader(output, CODEC_NAME, 0);
        output.writeVLong(this.count);
        output.writeByte(this.separator);
        output.writeVInt(this.grams);
        output.writeVLong(this.totTokens);
        this.fst.save(output, output);
        return true;
    }

    @Override
    public boolean load(DataInput input) throws IOException {
        CodecUtil.checkHeader(input, CODEC_NAME, 0, 0);
        this.count = input.readVLong();
        byte separatorOrig = input.readByte();
        if (separatorOrig != this.separator) {
            throw new IllegalStateException("separator=" + this.separator + " is incorrect: original model was built with separator=" + separatorOrig);
        }
        int gramsOrig = input.readVInt();
        if (gramsOrig != this.grams) {
            throw new IllegalStateException("grams=" + this.grams + " is incorrect: original model was built with grams=" + gramsOrig);
        }
        this.totTokens = input.readVLong();
        this.fst = new FST<Long>(input, input, PositiveIntOutputs.getSingleton());
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        return this.lookup(key, null, onlyMorePopular, num);
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, int num) {
        return this.lookup(key, null, true, num);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) {
        try {
            return this.lookup(key, contexts, num);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public long getCount() {
        return this.count;
    }

    private int countGrams(BytesRef token) {
        int count = 1;
        for (int i = 0; i < token.length; ++i) {
            if (token.bytes[token.offset + i] != this.separator) continue;
            ++count;
        }
        return count;
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, int num) throws IOException {
        if (contexts != null) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        if (this.fst == null) {
            throw new IllegalStateException("Lookup not supported at this time");
        }
        try (TokenStream ts = this.queryAnalyzer.tokenStream("", key.toString());){
            boolean lastTokenEnded;
            TermToBytesRefAttribute termBytesAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            OffsetAttribute offsetAtt = ts.addAttribute(OffsetAttribute.class);
            PositionLengthAttribute posLenAtt = ts.addAttribute(PositionLengthAttribute.class);
            PositionIncrementAttribute posIncAtt = ts.addAttribute(PositionIncrementAttribute.class);
            ts.reset();
            BytesRefBuilder[] lastTokens = new BytesRefBuilder[this.grams];
            int maxEndOffset = -1;
            boolean sawRealToken = false;
            while (ts.incrementToken()) {
                BytesRef tokenBytes = termBytesAtt.getBytesRef();
                sawRealToken |= tokenBytes.length > 0;
                int gramCount = posLenAtt.getPositionLength();
                assert (gramCount <= this.grams);
                if (this.countGrams(tokenBytes) != gramCount) {
                    throw new IllegalArgumentException("tokens must not contain separator byte; got token=" + tokenBytes + " but gramCount=" + gramCount + " does not match recalculated count=" + this.countGrams(tokenBytes));
                }
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
                BytesRefBuilder b = new BytesRefBuilder();
                b.append(tokenBytes);
                lastTokens[gramCount - 1] = b;
            }
            ts.end();
            if (!sawRealToken) {
                throw new IllegalArgumentException("no tokens produced by analyzer, or the only tokens were empty strings");
            }
            int endPosInc = posIncAtt.getPositionIncrement();
            boolean bl = lastTokenEnded = offsetAtt.endOffset() > maxEndOffset || endPosInc > 0;
            if (lastTokenEnded) {
                for (int i = this.grams - 1; i > 0; --i) {
                    BytesRefBuilder token = lastTokens[i - 1];
                    if (token == null) continue;
                    token.append(this.separator);
                    lastTokens[i] = token;
                }
                lastTokens[0] = new BytesRefBuilder();
            }
            FST.Arc<Long> arc = new FST.Arc<Long>();
            FST.BytesReader bytesReader = this.fst.getBytesReader();
            double backoff = 1.0;
            ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(num);
            final HashSet<BytesRef> seen = new HashSet<BytesRef>();
            for (int gram = this.grams - 1; gram >= 0; --gram) {
                BytesRefBuilder token = lastTokens[gram];
                if (token == null || token.length() == 0 && key.length() > 0) continue;
                if (endPosInc > 0 && gram <= endPosInc) break;
                Long prefixOutput = null;
                try {
                    prefixOutput = this.lookupPrefix(this.fst, bytesReader, token.get(), arc);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
                if (prefixOutput == null) {
                    backoff *= 0.4;
                    continue;
                }
                long contextCount = this.totTokens;
                BytesRef lastTokenFragment = null;
                for (int i = token.length() - 1; i >= 0; --i) {
                    if (token.byteAt(i) != this.separator) continue;
                    BytesRef context = new BytesRef(token.bytes(), 0, i);
                    Long output = Util.get(this.fst, Util.toIntsRef(context, new IntsRefBuilder()));
                    assert (output != null);
                    contextCount = this.decodeWeight(output);
                    lastTokenFragment = new BytesRef(token.bytes(), i + 1, token.length() - i - 1);
                    break;
                }
                final BytesRefBuilder finalLastToken = new BytesRefBuilder();
                if (lastTokenFragment == null) {
                    finalLastToken.copyBytes(token.get());
                } else {
                    finalLastToken.copyBytes(lastTokenFragment);
                }
                CharsRefBuilder spare = new CharsRefBuilder();
                Util.TopResults completions = null;
                try {
                    Util.TopNSearcher<Long> searcher = new Util.TopNSearcher<Long>(this.fst, num, num + seen.size(), weightComparator){
                        BytesRefBuilder scratchBytes;
                        {
                            super(arg0, arg1, arg2, arg3);
                            this.scratchBytes = new BytesRefBuilder();
                        }

                        @Override
                        protected void addIfCompetitive(Util.FSTPath<Long> path) {
                            if (path.arc.label() != FreeTextSuggester.this.separator) {
                                super.addIfCompetitive(path);
                            }
                        }

                        @Override
                        protected boolean acceptResult(IntsRef input, Long output) {
                            Util.toBytesRef(input, this.scratchBytes);
                            finalLastToken.grow(finalLastToken.length() + this.scratchBytes.length());
                            int lenSav = finalLastToken.length();
                            finalLastToken.append(this.scratchBytes);
                            boolean ret = !seen.contains(finalLastToken.get());
                            finalLastToken.setLength(lenSav);
                            return ret;
                        }
                    };
                    searcher.addStartPaths(arc, prefixOutput, true, new IntsRefBuilder());
                    completions = searcher.search();
                    assert (completions.isComplete);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
                int prefixLength = token.length();
                BytesRefBuilder suffix = new BytesRefBuilder();
                for (Util.Result completion : completions) {
                    token.setLength(prefixLength);
                    Util.toBytesRef(completion.input, suffix);
                    token.append(suffix);
                    BytesRef lastToken = token.get();
                    for (int i = token.length() - 1; i >= 0; --i) {
                        if (token.byteAt(i) != this.separator) continue;
                        assert (token.length() - i - 1 > 0);
                        lastToken = new BytesRef(token.bytes(), i + 1, token.length() - i - 1);
                        break;
                    }
                    if (seen.contains(lastToken)) continue;
                    seen.add(BytesRef.deepCopyOf(lastToken));
                    spare.copyUTF8Bytes(token.get());
                    Lookup.LookupResult result = new Lookup.LookupResult(spare.toString(), (long)(9.223372036854776E18 * backoff * (double)this.decodeWeight((Long)completion.output) / (double)contextCount));
                    results.add(result);
                    assert (results.size() == seen.size());
                }
                backoff *= 0.4;
            }
            Collections.sort(results, new Comparator<Lookup.LookupResult>(){

                @Override
                public int compare(Lookup.LookupResult a, Lookup.LookupResult b) {
                    if (a.value > b.value) {
                        return -1;
                    }
                    if (a.value < b.value) {
                        return 1;
                    }
                    return ((String)a.key).compareTo((String)b.key);
                }
            });
            if (results.size() > num) {
                results.subList(num, results.size()).clear();
            }
            ArrayList<Lookup.LookupResult> arrayList = results;
            return arrayList;
        }
    }

    private long encodeWeight(long ngramCount) {
        return Long.MAX_VALUE - ngramCount;
    }

    private long decodeWeight(Long output) {
        assert (output != null);
        return (int)(Long.MAX_VALUE - output);
    }

    private Long lookupPrefix(FST<Long> fst, FST.BytesReader bytesReader, BytesRef scratch, FST.Arc<Long> arc) throws IOException {
        Long output = (Long)fst.outputs.getNoOutput();
        fst.getFirstArc(arc);
        byte[] bytes = scratch.bytes;
        int pos = scratch.offset;
        int end = pos + scratch.length;
        while (pos < end) {
            if (fst.findTargetArc(bytes[pos++] & 0xFF, arc, arc, bytesReader) == null) {
                return null;
            }
            output = fst.outputs.add(output, arc.output());
        }
        return output;
    }

    public Object get(CharSequence key) {
        throw new UnsupportedOperationException();
    }
}

