/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.decommission.awareness.get;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;

public class GetDecommissionStateRequest
extends ClusterManagerNodeReadRequest<GetDecommissionStateRequest> {
    private String attributeName;

    public GetDecommissionStateRequest() {
    }

    public GetDecommissionStateRequest(String attributeName) {
        this.attributeName = attributeName;
    }

    public GetDecommissionStateRequest(StreamInput in) throws IOException {
        super(in);
        this.attributeName = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.attributeName);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.attributeName == null || Strings.isEmpty(this.attributeName)) {
            validationException = ValidateActions.addValidationError("attribute name is missing", validationException);
        }
        return validationException;
    }

    public GetDecommissionStateRequest attributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public String attributeName() {
        return this.attributeName;
    }
}

