/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.transport.RemoteConnectionInfo;

public final class RemoteInfoResponse
extends ActionResponse
implements ToXContentObject {
    private List<RemoteConnectionInfo> infos;

    RemoteInfoResponse(StreamInput in) throws IOException {
        super(in);
        this.infos = in.readList(RemoteConnectionInfo::new);
    }

    public RemoteInfoResponse(Collection<RemoteConnectionInfo> infos) {
        this.infos = Collections.unmodifiableList(new ArrayList<RemoteConnectionInfo>(infos));
    }

    public List<RemoteConnectionInfo> getInfos() {
        return this.infos;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.infos);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (RemoteConnectionInfo info : this.infos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

