/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Collection;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.opensearch.common.ParseField;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class SnapshotShardsStats
implements ToXContentObject {
    private int initializingShards;
    private int startedShards;
    private int finalizingShards;
    private int doneShards;
    private int failedShards;
    private int totalShards;
    static final ConstructingObjectParser<SnapshotShardsStats, Void> PARSER = new ConstructingObjectParser("shards_stats", true, parsedObjects -> {
        int i = 0;
        int initializingShards = (Integer)parsedObjects[i++];
        int startedShards = (Integer)parsedObjects[i++];
        int finalizingShards = (Integer)parsedObjects[i++];
        int doneShards = (Integer)parsedObjects[i++];
        int failedShards = (Integer)parsedObjects[i++];
        int totalShards = (Integer)parsedObjects[i];
        return new SnapshotShardsStats(initializingShards, startedShards, finalizingShards, doneShards, failedShards, totalShards);
    });

    SnapshotShardsStats(Collection<SnapshotIndexShardStatus> shards) {
        block7: for (SnapshotIndexShardStatus shard : shards) {
            ++this.totalShards;
            switch (shard.getStage()) {
                case INIT: {
                    ++this.initializingShards;
                    continue block7;
                }
                case STARTED: {
                    ++this.startedShards;
                    continue block7;
                }
                case FINALIZE: {
                    ++this.finalizingShards;
                    continue block7;
                }
                case DONE: {
                    ++this.doneShards;
                    continue block7;
                }
                case FAILURE: {
                    ++this.failedShards;
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unknown stage type " + shard.getStage());
        }
    }

    public SnapshotShardsStats(int initializingShards, int startedShards, int finalizingShards, int doneShards, int failedShards, int totalShards) {
        this.initializingShards = initializingShards;
        this.startedShards = startedShards;
        this.finalizingShards = finalizingShards;
        this.doneShards = doneShards;
        this.failedShards = failedShards;
        this.totalShards = totalShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getStartedShards() {
        return this.startedShards;
    }

    public int getFinalizingShards() {
        return this.finalizingShards;
    }

    public int getDoneShards() {
        return this.doneShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("initializing", this.getInitializingShards());
        builder.field("started", this.getStartedShards());
        builder.field("finalizing", this.getFinalizingShards());
        builder.field("done", this.getDoneShards());
        builder.field("failed", this.getFailedShards());
        builder.field("total", this.getTotalShards());
        builder.endObject();
        return builder;
    }

    public static SnapshotShardsStats fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotShardsStats that = (SnapshotShardsStats)o;
        if (this.initializingShards != that.initializingShards) {
            return false;
        }
        if (this.startedShards != that.startedShards) {
            return false;
        }
        if (this.finalizingShards != that.finalizingShards) {
            return false;
        }
        if (this.doneShards != that.doneShards) {
            return false;
        }
        if (this.failedShards != that.failedShards) {
            return false;
        }
        return this.totalShards == that.totalShards;
    }

    public int hashCode() {
        int result = this.initializingShards;
        result = 31 * result + this.startedShards;
        result = 31 * result + this.finalizingShards;
        result = 31 * result + this.doneShards;
        result = 31 * result + this.failedShards;
        result = 31 * result + this.totalShards;
        return result;
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("initializing", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("started", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("finalizing", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("done", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("failed", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("total", new String[0]));
    }

    static final class Fields {
        static final String SHARDS_STATS = "shards_stats";
        static final String INITIALIZING = "initializing";
        static final String STARTED = "started";
        static final String FINALIZING = "finalizing";
        static final String DONE = "done";
        static final String FAILED = "failed";
        static final String TOTAL = "total";

        Fields() {
        }
    }
}

